/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.impl.Node;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.SelectionHandler;
import com.hazelcast.nio.SelectorBase;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;

public final class OutSelector
extends SelectorBase {
    AtomicLong writeQueueSize = new AtomicLong();

    public OutSelector(Node node) {
        super(node, 1);
    }

    public void connect(Address address) {
        this.logger.log(Level.FINEST, "connect to " + address);
        Connector connector = new Connector(address);
        this.addTask(connector);
    }

    public void publishUtilization() {
        this.node.getCpuUtilization().outThread = this.threadWatcher.publish();
    }

    public long getWriteQueueSize() {
        return this.writeQueueSize.get();
    }

    private class Connector
    implements Runnable,
    SelectionHandler {
        final Address address;
        SocketChannel socketChannel = null;

        public Connector(Address address) {
            this.address = address;
        }

        public void handle() {
            try {
                boolean finished = this.socketChannel.finishConnect();
                if (!finished) {
                    this.socketChannel.register(OutSelector.this.selector, 8, this);
                    return;
                }
                OutSelector.this.logger.log(Level.FINEST, "connected to " + this.address);
                Connection connection = OutSelector.this.createConnection(this.socketChannel, false);
                OutSelector.this.node.connectionManager.bind(this.address, connection, false);
            }
            catch (Exception e) {
                try {
                    String msg = "Couldn't connect to " + this.address + ", cause: " + e.getMessage();
                    OutSelector.this.logger.log(Level.FINEST, msg, e);
                    this.socketChannel.close();
                    OutSelector.this.node.connectionManager.failedConnection(this.address);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void run() {
            try {
                this.socketChannel = SocketChannel.open();
                OutSelector.this.initSocket(this.socketChannel.socket());
                Address thisAddress = OutSelector.this.node.getThisAddress();
                try {
                    this.socketChannel.configureBlocking(false);
                    this.socketChannel.socket().bind(new InetSocketAddress(thisAddress.getInetAddress(), 0));
                    OutSelector.this.logger.log(Level.FINEST, "connecting to " + this.address);
                    boolean connected = this.socketChannel.connect(new InetSocketAddress(this.address.getInetAddress(), this.address.getPort()));
                    OutSelector.this.logger.log(Level.FINEST, "connection check. connected: " + connected + ", " + this.address);
                    if (connected) {
                        this.handle();
                        return;
                    }
                }
                catch (Throwable e) {
                    OutSelector.this.logger.log(Level.FINEST, this.address + " ConnectionFailed.", e);
                }
                this.socketChannel.register(OutSelector.this.selector, 8, this);
            }
            catch (Throwable e) {
                if (this.socketChannel != null) {
                    try {
                        this.socketChannel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                OutSelector.this.node.connectionManager.failedConnection(this.address);
            }
        }
    }
}

