/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.nio.AbstractSelectionHandler;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.SocketPacketReader;
import com.hazelcast.nio.SocketReader;
import com.hazelcast.nio.WriteHandler;
import com.hazelcast.nio.ascii.SocketTextReader;
import java.nio.ByteBuffer;
import java.util.logging.Level;

class ReadHandler
extends AbstractSelectionHandler
implements Runnable {
    final ByteBuffer inBuffer;
    final ByteBuffer protocolBuffer = ByteBuffer.allocate(3);
    SocketReader socketReader = null;

    public ReadHandler(Connection connection) {
        super(connection);
        this.inBuffer = ByteBuffer.allocate(this.node.connectionManager.SOCKET_RECEIVE_BUFFER_SIZE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handle() {
        if (!this.connection.live()) {
            this.logger.log(Level.FINEST, ">>>> We are being to asked to read, but connection is not live so we won't");
            return;
        }
        try {
            int readBytes;
            if (this.socketReader == null) {
                readBytes = this.socketChannel.read(this.protocolBuffer);
                if (readBytes == -1) {
                    this.connection.close();
                    return;
                }
                if (!this.protocolBuffer.hasRemaining()) {
                    String protocol = new String(this.protocolBuffer.array());
                    WriteHandler writeHandler = this.connection.getWriteHandler();
                    if ("HZC".equals(protocol)) {
                        writeHandler.setProtocol("HZC");
                        this.socketReader = new SocketPacketReader(this.node, this.socketChannel, this.connection);
                    } else {
                        writeHandler.setProtocol("TEXT");
                        this.inBuffer.put(this.protocolBuffer.array());
                        this.socketReader = new SocketTextReader(this.node, this.connection);
                        this.connection.connectionManager.incrementTextConnections();
                    }
                }
            }
            if (this.socketReader == null) {
                return;
            }
            readBytes = this.socketChannel.read(this.inBuffer);
            if (readBytes == -1) {
                this.connection.close();
                return;
            }
        }
        catch (Throwable e) {
            this.handleSocketException(e);
            return;
        }
        try {
            if (this.inBuffer.position() == 0) {
                return;
            }
            this.inBuffer.flip();
            this.socketReader.read(this.inBuffer);
            if (this.inBuffer.hasRemaining()) {
                this.inBuffer.compact();
            } else {
                this.inBuffer.clear();
            }
        }
        catch (Exception t) {
            this.handleSocketException(t);
        }
        finally {
            this.registerOp(this.inSelector.selector, 1);
        }
    }

    public final void run() {
        this.registerOp(this.inSelector.selector, 1);
    }
}

