/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.util.ThreadStats;

public class ThreadWatcher {
    long start = 0L;
    long totalWait = 0L;
    long totalTime = 0L;
    long waitCount = 0L;
    long runCount = 0L;

    public void addWait(long totalWaitNanos, long now) {
        if (this.start == 0L) {
            this.start = now;
        } else {
            this.totalWait += totalWaitNanos;
            this.totalTime += now - this.start;
            this.start = now;
        }
        ++this.waitCount;
    }

    public long incrementRunCount() {
        long now = System.nanoTime();
        if (this.start == 0L) {
            this.start = now;
        } else {
            this.totalTime += now - this.start;
            this.start = now;
        }
        return this.runCount++;
    }

    public ThreadStats publish() {
        long now = System.nanoTime();
        this.totalTime += now - this.start;
        long totalRun = this.totalTime - this.totalWait;
        int utilizationPercentage = this.totalTime <= 0L || this.runCount <= 1L ? 0 : (int)(totalRun * 100L / this.totalTime);
        ThreadStats threadStats = new ThreadStats(utilizationPercentage, this.runCount, this.waitCount);
        this.start = now;
        this.totalTime = 0L;
        this.totalWait = 0L;
        return threadStats;
    }
}

