/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.cluster.AbstractRemotelyCallable;
import com.hazelcast.cluster.AddOrRemoveConnection;
import com.hazelcast.cluster.ConnectionCheckCall;
import com.hazelcast.cluster.FinalizeJoin;
import com.hazelcast.cluster.JoinInfo;
import com.hazelcast.cluster.JoinRequest;
import com.hazelcast.cluster.Master;
import com.hazelcast.cluster.MemberInfo;
import com.hazelcast.cluster.MemberRemover;
import com.hazelcast.cluster.MembersUpdateCall;
import com.hazelcast.cluster.RemotelyProcessable;
import com.hazelcast.cluster.SyncProcess;
import com.hazelcast.core.Member;
import com.hazelcast.impl.BaseManager;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.FallThroughRunnable;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.NodeType;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.Request;
import com.hazelcast.impl.SplitBrainHandler;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.base.Call;
import com.hazelcast.impl.base.PacketProcessor;
import com.hazelcast.impl.base.ScheduledAction;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListener;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.Packet;
import com.hazelcast.util.Prioritized;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClusterManager
extends BaseManager
implements ConnectionListener {
    private final long WAIT_MILLIS_BEFORE_JOIN;
    private final long MAX_NO_HEARTBEAT_MILLIS;
    private final long HEARTBEAT_INTERVAL_MILLIS;
    private final int ICMP_TIMEOUT_MILLIS;
    private final boolean ICMP_ENABLED;
    private final int MAX_PING_RETRY_COUNT;
    private final Set<ScheduledAction> setScheduledActions = new LinkedHashSet<ScheduledAction>(1000);
    private final Set<MemberInfo> setJoins = new LinkedHashSet<MemberInfo>(100);
    private boolean joinInProgress = false;
    private long timeToStartJoin = 0L;
    private final List<MemberImpl> lsMembersBefore = new ArrayList<MemberImpl>();
    private long lastHeartbeat = 0L;

    public ClusterManager(final Node node) {
        super(node);
        this.WAIT_MILLIS_BEFORE_JOIN = (long)node.groupProperties.WAIT_SECONDS_BEFORE_JOIN.getInteger() * 1000L;
        this.MAX_NO_HEARTBEAT_MILLIS = (long)node.groupProperties.MAX_NO_HEARTBEAT_SECONDS.getInteger() * 1000L;
        this.HEARTBEAT_INTERVAL_MILLIS = (long)node.groupProperties.HEARTBEAT_INTERVAL_SECONDS.getInteger() * 1000L;
        this.ICMP_TIMEOUT_MILLIS = node.groupProperties.ICMP_TIMEOUT.getInteger() * 1000;
        this.ICMP_ENABLED = node.groupProperties.ICMP_ENABLED.getBoolean();
        this.MAX_PING_RETRY_COUNT = node.groupProperties.MAX_PING_RETRY_COUNT.getInteger();
        node.clusterService.registerPeriodicRunnable(new SplitBrainHandler(node));
        node.clusterService.registerPeriodicRunnable(new Runnable(){

            public void run() {
                long now = System.currentTimeMillis();
                if (now - ClusterManager.this.lastHeartbeat >= ClusterManager.this.HEARTBEAT_INTERVAL_MILLIS) {
                    ClusterManager.this.heartBeater();
                    ClusterManager.this.lastHeartbeat = now;
                }
            }
        });
        node.clusterService.registerPeriodicRunnable(new Runnable(){

            public void run() {
                ClusterManager.this.checkScheduledActions();
            }
        });
        node.connectionManager.addConnectionListener(this);
        this.registerPacketProcessor(ClusterOperation.RESPONSE, new PacketProcessor(){

            public void process(Packet packet) {
                ClusterManager.this.handleResponse(packet);
            }
        });
        this.registerPacketProcessor(ClusterOperation.HEARTBEAT, new PacketProcessor(){

            public void process(Packet packet) {
                ClusterManager.this.releasePacket(packet);
            }
        });
        this.registerPacketProcessor(ClusterOperation.LOG, new PacketProcessor(){

            public void process(Packet packet) {
                ClusterManager.this.logger.log(Level.parse(packet.name), IOUtil.toObject(packet.getValueData()).toString());
                ClusterManager.this.releasePacket(packet);
            }
        });
        this.registerPacketProcessor(ClusterOperation.JOIN_CHECK, new PacketProcessor(){

            public void process(Packet packet) {
                Connection conn = packet.conn;
                Request request = Request.copy(packet);
                JoinInfo joinInfo = (JoinInfo)IOUtil.toObject(request.value);
                request.clearForResponse();
                if (joinInfo != null && node.joined() && node.isActive()) {
                    try {
                        node.validateJoinRequest(joinInfo);
                        request.response = IOUtil.toData(node.createJoinInfo());
                    }
                    catch (Exception e) {
                        request.response = IOUtil.toData(e);
                    }
                }
                ClusterManager.this.returnResponse(request, conn);
                ClusterManager.this.releasePacket(packet);
            }
        });
        this.registerPacketProcessor(ClusterOperation.REMOTELY_PROCESS_AND_RESPOND, new PacketProcessor(){

            public void process(Packet packet) {
                Data data = packet.getValueData();
                RemotelyProcessable rp = (RemotelyProcessable)IOUtil.toObject(data);
                rp.setConnection(packet.conn);
                rp.setNode(node);
                rp.process();
                ClusterManager.this.sendResponse(packet);
            }
        });
        this.registerPacketProcessor(ClusterOperation.REMOTELY_PROCESS, new PacketProcessor(){

            public void process(Packet packet) {
                Data data = packet.getValueData();
                RemotelyProcessable rp = (RemotelyProcessable)IOUtil.toObject(data);
                rp.setConnection(packet.conn);
                rp.setNode(node);
                rp.process();
                ClusterManager.this.releasePacket(packet);
            }
        });
        this.registerPacketProcessor(ClusterOperation.REMOTELY_CALLABLE_BOOLEAN, new PacketProcessor(){

            public void process(Packet packet) {
                Boolean result;
                AbstractRemotelyCallable callable = null;
                try {
                    Data data = packet.getValueData();
                    callable = (AbstractRemotelyCallable)IOUtil.toObject(data);
                    callable.setConnection(packet.conn);
                    callable.setNode(node);
                    result = (Boolean)callable.call();
                }
                catch (Exception e) {
                    ClusterManager.this.logger.log(Level.SEVERE, "Error processing " + callable, e);
                    result = Boolean.FALSE;
                }
                if (result == Boolean.TRUE) {
                    ClusterManager.this.sendResponse(packet);
                } else {
                    ClusterManager.this.sendResponseFailure(packet);
                }
            }
        });
        this.registerPacketProcessor(ClusterOperation.REMOTELY_CALLABLE_OBJECT, new PacketProcessor(){

            public void process(Packet packet) {
                Object result;
                AbstractRemotelyCallable callable = null;
                try {
                    Data data = packet.getValueData();
                    callable = (AbstractRemotelyCallable)IOUtil.toObject(data);
                    callable.setConnection(packet.conn);
                    callable.setNode(node);
                    result = callable.call();
                }
                catch (Exception e) {
                    ClusterManager.this.logger.log(Level.SEVERE, "Error processing " + callable, e);
                    result = null;
                }
                if (result != null) {
                    Data value = result instanceof Data ? (Data)result : IOUtil.toData(result);
                    packet.setValue(value);
                }
                ClusterManager.this.sendResponse(packet);
            }
        });
    }

    public boolean shouldTryMerge() {
        return !this.joinInProgress && this.setJoins.size() == 0;
    }

    public JoinInfo checkJoin(Connection conn) {
        return new JoinCall(conn).checkJoin();
    }

    public void appendState(StringBuffer sbState) {
        sbState.append("\nClusterManager {");
        for (ScheduledAction sa : this.setScheduledActions) {
            sbState.append("\n\t" + sa + ", from:" + sa.getRequest().caller);
        }
        sbState.append("\n}");
    }

    void logMissingConnection(Address address) {
        String msg = this.thisMember + " has no connection to " + address;
        this.logAtMaster(Level.WARNING, msg);
        this.logger.log(Level.WARNING, msg);
    }

    public void logAtMaster(Level level, String msg) {
        Address master = this.getMasterAddress();
        if (!this.isMaster() && master != null) {
            Connection connMaster = this.node.connectionManager.getConnection(this.getMasterAddress());
            if (connMaster != null) {
                Packet packet = this.obtainPacket(level.toString(), null, IOUtil.toData(msg), ClusterOperation.LOG, 0L);
                this.sendOrReleasePacket(packet, connMaster);
            }
        } else {
            this.logger.log(level, msg);
        }
    }

    public final void heartBeater() {
        block21: {
            long now;
            block20: {
                if (!this.node.joined() || !this.node.isActive()) {
                    return;
                }
                now = System.currentTimeMillis();
                if (!this.isMaster()) break block20;
                ArrayList<Address> lsDeadAddresses = null;
                for (MemberImpl memberImpl : this.lsMembers) {
                    Address address = memberImpl.getAddress();
                    if (this.thisAddress.equals(address)) continue;
                    try {
                        Connection conn = this.node.connectionManager.getConnection(address);
                        if (conn != null && conn.live()) {
                            if (now - memberImpl.getLastRead() >= this.MAX_NO_HEARTBEAT_MILLIS) {
                                conn = null;
                                if (lsDeadAddresses == null) {
                                    lsDeadAddresses = new ArrayList<Address>();
                                }
                                this.logger.log(Level.WARNING, "Added " + address + " to list of dead addresses because of timeout since last read");
                                lsDeadAddresses.add(address);
                            } else if (now - memberImpl.getLastRead() >= 5000L && now - memberImpl.getLastPing() >= 5000L) {
                                this.ping(memberImpl);
                            }
                            if (now - memberImpl.getLastWrite() <= 500L) continue;
                            this.sendHeartbeat(conn);
                            continue;
                        }
                        if (conn != null || now - memberImpl.getLastRead() <= 5000L) continue;
                        this.logMissingConnection(address);
                        memberImpl.didRead();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                if (lsDeadAddresses == null) break block21;
                for (Address address : lsDeadAddresses) {
                    this.logger.log(Level.FINEST, "NO HEARTBEAT should remove " + address);
                    this.doRemoveAddress(address);
                    this.sendRemoveMemberToOthers(address);
                }
                break block21;
            }
            Address masterAddress = this.getMasterAddress();
            if (masterAddress != null) {
                MemberImpl masterMember = this.getMember(masterAddress);
                boolean removed = false;
                if (masterMember != null) {
                    if (now - masterMember.getLastRead() >= this.MAX_NO_HEARTBEAT_MILLIS) {
                        this.logger.log(Level.FINEST, "Master node has timed out it's heartbeat and will be removed");
                        this.doRemoveAddress(masterAddress);
                        removed = true;
                    } else if (now - masterMember.getLastRead() >= 5000L && now - masterMember.getLastPing() >= 5000L) {
                        this.ping(masterMember);
                    }
                }
                if (!removed) {
                    Connection connMaster = this.node.connectionManager.getOrConnect(this.getMasterAddress());
                    this.sendHeartbeat(connMaster);
                }
            }
            for (MemberImpl member : this.lsMembers) {
                Connection conn;
                if (member.localMember()) continue;
                Address address = member.getAddress();
                if (this.shouldConnectTo(address)) {
                    conn = this.node.connectionManager.getOrConnect(address);
                    if (conn != null) {
                        this.sendHeartbeat(conn);
                        continue;
                    }
                    this.logger.log(Level.FINEST, "could not connect to " + address + " to send heartbeat");
                    continue;
                }
                conn = this.node.connectionManager.getConnection(address);
                if (conn != null && conn.live()) {
                    if (now - member.getLastWrite() <= 500L) continue;
                    this.sendHeartbeat(conn);
                    continue;
                }
                this.logger.log(Level.FINEST, "not sending heartbeat because connection is null or not live " + address);
                if (conn != null || now - member.getLastRead() <= 5000L) continue;
                this.logMissingConnection(address);
                member.didRead();
            }
        }
    }

    private void ping(final MemberImpl memberImpl) {
        if (!this.ICMP_ENABLED) {
            return;
        }
        memberImpl.didPing();
        this.node.executorManager.executeNow(new Runnable(){

            public void run() {
                try {
                    final Address address = memberImpl.getAddress();
                    ClusterManager.this.logger.log(Level.WARNING, ClusterManager.this.thisAddress + " will ping " + address);
                    for (int i = 0; i < ClusterManager.this.MAX_PING_RETRY_COUNT; ++i) {
                        try {
                            if (!address.getInetAddress().isReachable(ClusterManager.this.ICMP_TIMEOUT_MILLIS)) continue;
                            ClusterManager.this.logger.log(Level.INFO, ClusterManager.this.thisAddress + " pings successfully. Target: " + address + " with timeout: " + ClusterManager.this.ICMP_TIMEOUT_MILLIS + " ms.");
                            return;
                        }
                        catch (ConnectException connectException) {
                            // empty catch block
                        }
                    }
                    ClusterManager.this.logger.log(Level.WARNING, ClusterManager.this.thisAddress + " couldn't ping " + address);
                    ClusterManager.this.enqueueAndReturn(new Processable(){

                        public void process() {
                            ClusterManager.this.doRemoveAddress(address);
                        }
                    });
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    void sendHeartbeat(Connection conn) {
        Packet packet = this.obtainPacket("heartbeat", null, null, ClusterOperation.HEARTBEAT, 0L);
        this.sendOrReleasePacket(packet, conn);
    }

    public boolean shouldConnectTo(Address address) {
        return !this.node.joined() || this.lsMembers.indexOf(this.getMember(this.thisAddress)) > this.lsMembers.indexOf(this.getMember(address));
    }

    private void sendRemoveMemberToOthers(Address deadAddress) {
        for (MemberImpl member : this.lsMembers) {
            Address address = member.getAddress();
            if (this.thisAddress.equals(address) || address.equals(deadAddress)) continue;
            this.sendProcessableTo((RemotelyProcessable)new MemberRemover(deadAddress), address);
        }
    }

    public void handleMaster(Master master) {
        if (!this.node.joined() && !this.thisAddress.equals(master.address)) {
            this.node.setMasterAddress(master.address);
            Connection connMaster = this.node.connectionManager.getOrConnect(master.address);
            if (connMaster != null) {
                this.sendJoinRequest(master.address);
            }
        }
    }

    public void handleAddRemoveConnection(AddOrRemoveConnection connection) {
        if (connection.add) {
            if (!connection.address.equals(this.thisAddress)) {
                this.node.connectionManager.getOrConnect(connection.address);
            }
        } else if (connection.address != null) {
            this.doRemoveAddress(connection.address);
        }
    }

    void doRemoveAddress(Address deadAddress) {
        MemberImpl deadMember;
        Connection conn;
        this.logger.log(Level.INFO, "Removing Address " + deadAddress);
        if (!this.node.joined()) {
            this.node.failedConnection(deadAddress);
            return;
        }
        if (deadAddress.equals(this.thisAddress)) {
            return;
        }
        if (deadAddress.equals(this.getMasterAddress())) {
            if (this.node.joined()) {
                MemberImpl newMaster = this.getNextMemberAfter(deadAddress, false, 1);
                if (newMaster != null) {
                    this.node.setMasterAddress(newMaster.getAddress());
                } else {
                    this.node.setMasterAddress(null);
                }
            } else {
                this.node.setMasterAddress(null);
            }
            this.logger.log(Level.FINEST, "Now Master " + this.node.getMasterAddress());
        }
        if (this.isMaster()) {
            this.setJoins.remove(new MemberInfo(deadAddress));
        }
        if ((conn = this.node.connectionManager.getConnection(deadAddress)) != null) {
            this.node.connectionManager.destroyConnection(conn);
        }
        if ((deadMember = this.getMember(deadAddress)) != null) {
            Object[] calls;
            this.lsMembersBefore.clear();
            for (MemberImpl memberBefore : this.lsMembers) {
                this.lsMembersBefore.add(memberBefore);
            }
            this.removeMember(deadMember);
            this.node.concurrentMapManager.syncForDead(deadMember);
            this.node.listenerManager.syncForDead(deadAddress);
            this.node.topicManager.syncForDead(deadAddress);
            this.node.getClusterImpl().setMembers(this.lsMembers);
            for (Object call : calls = this.mapCalls.values().toArray()) {
                ((Call)call).onDisconnect(deadAddress);
            }
            this.logger.log(Level.INFO, this.toString());
        }
        if (this.isMaster()) {
            this.sendProcessableToAll(new RemoveMember(deadAddress), false);
        }
    }

    public List<MemberImpl> getMembersBeforeSync() {
        return this.lsMembersBefore;
    }

    public boolean isNextChanged(int distance) {
        if (distance <= 0) {
            return false;
        }
        if (this.lsMembers.size() == 0) {
            return false;
        }
        if (this.lsMembersBefore.size() == 0) {
            return true;
        }
        int indexBefore = this.lsMembersBefore.indexOf(this.thisMember);
        int indexNow = this.lsMembers.indexOf(this.thisMember);
        for (int i = 1; i < distance + 1; ++i) {
            Member before = this.memberAt(this.lsMembersBefore, (indexBefore + i) % this.lsMembersBefore.size());
            Member now = this.memberAt(this.lsMembers, (indexNow + i) % this.lsMembers.size());
            if (before == null && now == null || before != null && now != null && now.equals(before) && !now.isSuperClient() && !before.isSuperClient()) continue;
            return true;
        }
        return false;
    }

    public boolean isPreviousChanged(int distance) {
        if (distance <= 0) {
            return false;
        }
        if (this.lsMembers.size() == 0) {
            return false;
        }
        if (this.lsMembersBefore.size() == 0) {
            return true;
        }
        int indexBefore = this.lsMembersBefore.indexOf(this.thisMember);
        int indexNow = this.lsMembers.indexOf(this.thisMember);
        for (int i = 1; i < distance + 1; ++i) {
            Member before = this.memberAt(this.lsMembersBefore, (this.lsMembersBefore.size() + indexBefore - i) % this.lsMembersBefore.size());
            Member now = this.memberAt(this.lsMembers, (this.lsMembers.size() + indexNow - i) % this.lsMembers.size());
            if (before == null && now == null || before != null && now != null && now.equals(before) && !now.isSuperClient() && !before.isSuperClient()) continue;
            return true;
        }
        return false;
    }

    private Member memberAt(List<MemberImpl> lsMembers, int index) {
        if (index < 0 || index >= lsMembers.size()) {
            return null;
        }
        return lsMembers.get(index);
    }

    void handleJoinRequest(JoinRequest joinRequest) {
        boolean validateJoinRequest;
        this.logger.log(Level.FINEST, this.joinInProgress + " Handling join from " + joinRequest.address + " timeToStart: " + (this.timeToStartJoin - System.currentTimeMillis()));
        if (this.getMember(joinRequest.address) != null) {
            return;
        }
        Connection conn = joinRequest.getConnection();
        try {
            validateJoinRequest = this.node.validateJoinRequest(joinRequest);
        }
        catch (Exception e) {
            validateJoinRequest = false;
        }
        if (validateJoinRequest) {
            if (!this.node.getConfig().getNetworkConfig().getJoin().getMulticastConfig().isEnabled() && this.node.isActive() && this.node.joined() && this.node.getMasterAddress() != null && !this.isMaster()) {
                this.sendProcessableTo((RemotelyProcessable)new Master(this.node.getMasterAddress()), conn);
            }
            if (this.isMaster() && this.node.joined() && this.node.isActive()) {
                if (joinRequest.to != null && !joinRequest.to.equals(this.thisAddress)) {
                    this.sendProcessableTo((RemotelyProcessable)new Master(this.node.getMasterAddress()), conn);
                    return;
                }
                if (!this.joinInProgress) {
                    MemberInfo newMemberInfo = new MemberInfo(joinRequest.address, joinRequest.nodeType);
                    if (this.setJoins.add(newMemberInfo)) {
                        this.sendProcessableTo((RemotelyProcessable)new Master(this.node.getMasterAddress()), conn);
                        this.timeToStartJoin = System.currentTimeMillis() + this.WAIT_MILLIS_BEFORE_JOIN;
                    } else if (System.currentTimeMillis() > this.timeToStartJoin) {
                        this.startJoin();
                    }
                }
            }
        } else {
            conn.close();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("\n\nMembers [");
        sb.append(this.lsMembers.size());
        sb.append("] {");
        for (MemberImpl member : this.lsMembers) {
            sb.append("\n\t").append(member);
        }
        sb.append("\n}\n");
        return sb.toString();
    }

    public int getMemberDistance(Address target) {
        int indexThis = -1;
        int indexTarget = -1;
        int index = 0;
        for (MemberImpl member : this.lsMembers) {
            if (member.getAddress().equals(this.thisAddress)) {
                indexThis = index;
            } else if (member.getAddress().equals(target)) {
                indexTarget = index;
            }
            if (indexThis > -1 && indexTarget > -1) {
                int distance = indexThis - indexTarget;
                if (distance < 0) {
                    distance += this.lsMembers.size();
                }
                return distance;
            }
            ++index;
        }
        return 0;
    }

    public Packet createRemotelyProcessablePacket(RemotelyProcessable rp) {
        Data value = ThreadContext.get().toData(rp);
        Packet packet = this.obtainPacket();
        packet.set("remotelyProcess", ClusterOperation.REMOTELY_PROCESS, null, value);
        return packet;
    }

    public void sendProcessableTo(RemotelyProcessable rp, Connection conn) {
        Packet packet = this.createRemotelyProcessablePacket(rp);
        boolean sent = this.send(packet, conn);
        if (!sent) {
            this.releasePacket(packet);
        }
    }

    void joinReset() {
        this.joinInProgress = false;
        this.setJoins.clear();
        this.timeToStartJoin = System.currentTimeMillis() + this.WAIT_MILLIS_BEFORE_JOIN;
    }

    public void onRestart() {
        this.enqueueAndWait(new Processable(){

            public void process() {
                ClusterManager.this.joinReset();
                ClusterManager.this.lsMembers.clear();
                ClusterManager.this.mapMembers.clear();
            }
        }, 5);
    }

    public void finalizeJoin() {
        Set<Member> members = this.node.getClusterImpl().getMembers();
        ArrayList<AsyncRemotelyBooleanCallable> calls = new ArrayList<AsyncRemotelyBooleanCallable>();
        for (Member m : members) {
            MemberImpl member = (MemberImpl)m;
            if (member.localMember()) continue;
            AsyncRemotelyBooleanCallable rrp = new AsyncRemotelyBooleanCallable();
            rrp.executeProcess(member.getAddress(), new FinalizeJoin());
            calls.add(rrp);
        }
        for (AsyncRemotelyBooleanCallable call : calls) {
            call.getResultAsBoolean();
        }
    }

    void startJoin() {
        this.logger.log(Level.FINEST, "Starting join.");
        this.joinInProgress = true;
        MembersUpdateCall membersUpdate = new MembersUpdateCall(this.lsMembers, this.node.getClusterImpl().getClusterTime());
        if (this.setJoins != null && this.setJoins.size() > 0) {
            for (MemberInfo memberJoined : this.setJoins) {
                membersUpdate.addMemberInfo(memberJoined);
            }
        }
        membersUpdate.setNode(this.node);
        membersUpdate.call();
        this.node.executorManager.executeNow(new JoinRunnable(membersUpdate));
    }

    void updateMembers(Collection<MemberInfo> lsMemberInfos) {
        this.checkServiceThread();
        this.logger.log(Level.FINEST, "MEMBERS UPDATE!!");
        this.lsMembersBefore.clear();
        HashMap<Address, MemberImpl> mapOldMembers = new HashMap<Address, MemberImpl>();
        for (MemberImpl member : this.lsMembers) {
            this.lsMembersBefore.add(member);
            mapOldMembers.put(member.getAddress(), member);
        }
        this.lsMembers.clear();
        this.mapMembers.clear();
        for (MemberInfo memberInfo : lsMemberInfos) {
            MemberImpl member = (MemberImpl)mapOldMembers.get(memberInfo.address);
            if (member == null) {
                member = this.addMember(memberInfo.address, memberInfo.nodeType);
            } else {
                this.addMember(member);
            }
            member.didRead();
        }
        if (!this.lsMembers.contains(this.thisMember)) {
            throw new RuntimeException("Member list doesn't contain local member!");
        }
        this.heartBeater();
        this.node.getClusterImpl().setMembers(this.lsMembers);
        this.node.setJoined();
        this.logger.log(Level.INFO, this.toString());
    }

    public void sendJoinRequest(Address toAddress) {
        if (toAddress == null) {
            toAddress = this.node.getMasterAddress();
        }
        this.sendProcessableTo((RemotelyProcessable)this.node.createJoinInfo(), toAddress);
    }

    public void registerScheduledAction(ScheduledAction scheduledAction) {
        this.setScheduledActions.add(scheduledAction);
    }

    public void deregisterScheduledAction(ScheduledAction scheduledAction) {
        this.setScheduledActions.remove(scheduledAction);
    }

    public void checkScheduledActions() {
        if (!this.node.joined() || !this.node.isActive()) {
            return;
        }
        if (this.setScheduledActions.size() > 0) {
            Iterator<ScheduledAction> it = this.setScheduledActions.iterator();
            while (it.hasNext()) {
                ScheduledAction sa = it.next();
                if (sa.expired() && sa.isValid()) {
                    sa.onExpire();
                    it.remove();
                    continue;
                }
                if (sa.isValid()) continue;
                it.remove();
            }
        }
    }

    @Override
    public void connectionAdded(final Connection connection) {
        this.enqueueAndReturn(new Processable(){

            public void process() {
                MemberImpl member = ClusterManager.this.getMember(connection.getEndPoint());
                if (member != null) {
                    member.didRead();
                }
            }
        });
    }

    @Override
    public void connectionRemoved(Connection connection) {
        this.logger.log(Level.FINEST, "Connection is removed " + connection.getEndPoint());
        if (!this.node.joined() && this.getMasterAddress() != null && this.getMasterAddress().equals(connection.getEndPoint())) {
            this.node.setMasterAddress(null);
        }
    }

    public Member addMember(MemberImpl member) {
        return this.addMember(true, member);
    }

    public Member addMember(boolean checkServiceThread, MemberImpl member) {
        if (checkServiceThread) {
            this.checkServiceThread();
        }
        this.logger.log(Level.FINEST, "ClusterManager adding " + member);
        if (this.lsMembers.contains(member)) {
            for (MemberImpl m : this.lsMembers) {
                if (!m.equals(member)) continue;
                member = m;
            }
            this.mapMembers.put(member.getAddress(), member);
        } else {
            this.lsMembers.add(member);
            this.mapMembers.put(member.getAddress(), member);
        }
        return member;
    }

    public void removeMember(MemberImpl member) {
        this.checkServiceThread();
        this.logger.log(Level.FINEST, "removing  " + member);
        this.mapMembers.remove(member.getAddress());
        this.lsMembers.remove(member);
    }

    protected MemberImpl createMember(Address address, NodeType nodeType) {
        return new MemberImpl(address, this.thisAddress.equals(address), nodeType);
    }

    public MemberImpl getMember(Address address) {
        if (address == null) {
            return null;
        }
        return (MemberImpl)this.mapMembers.get(address);
    }

    public final MemberImpl addMember(Address address, NodeType nodeType) {
        this.checkServiceThread();
        if (address == null) {
            this.logger.log(Level.FINEST, "Address cannot be null");
            return null;
        }
        MemberImpl member = this.getMember(address);
        if (member == null) {
            member = this.createMember(address, nodeType);
        }
        this.addMember(member);
        return member;
    }

    public void stop() {
        if (this.setJoins != null) {
            this.setJoins.clear();
        }
        this.timeToStartJoin = 0L;
        if (this.lsMembers != null) {
            this.lsMembers.clear();
        }
        if (this.mapMembers != null) {
            this.mapMembers.clear();
        }
        if (this.lsMembersBefore != null) {
            this.lsMembersBefore.clear();
        }
        if (this.mapCalls != null) {
            this.mapCalls.clear();
        }
    }

    class JoinRunnable
    extends FallThroughRunnable
    implements Prioritized {
        final MembersUpdateCall membersUpdate;

        JoinRunnable(MembersUpdateCall membersUpdate) {
            this.membersUpdate = membersUpdate;
        }

        public void doRun() {
            Collection<MemberInfo> lsMemberInfos = this.membersUpdate.getMemberInfos();
            ArrayList<Address> newMemberList = new ArrayList<Address>(lsMemberInfos.size());
            for (MemberInfo memberInfo : lsMemberInfos) {
                newMemberList.add(memberInfo.address);
            }
            ArrayList<AsyncRemotelyBooleanCallable> calls = new ArrayList<AsyncRemotelyBooleanCallable>(lsMemberInfos.size());
            for (Address target : newMemberList) {
                if (ClusterManager.this.thisAddress.equals(target)) continue;
                AsyncRemotelyBooleanCallable rrp = new AsyncRemotelyBooleanCallable();
                rrp.executeProcess(target, this.membersUpdate);
                calls.add(rrp);
            }
            for (AsyncRemotelyBooleanCallable call : calls) {
                if (call.getResultAsBoolean()) continue;
                newMemberList.remove(call.getTarget());
            }
            calls.clear();
            for (Address target : newMemberList) {
                AsyncRemotelyBooleanCallable call = new AsyncRemotelyBooleanCallable();
                call.executeProcess(target, new SyncProcess());
                calls.add(call);
            }
            for (AsyncRemotelyBooleanCallable call : calls) {
                if (call.getResultAsBoolean()) continue;
                newMemberList.remove(call.getTarget());
            }
            calls.clear();
            ConnectionCheckCall connCheckCallable = new ConnectionCheckCall();
            for (Address target : newMemberList) {
                AsyncRemotelyBooleanCallable call = new AsyncRemotelyBooleanCallable();
                call.executeProcess(target, connCheckCallable);
                calls.add(call);
            }
            for (AsyncRemotelyBooleanCallable call : calls) {
                if (call.getResultAsBoolean()) continue;
                newMemberList.remove(call.getTarget());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AsyncRemotelyBooleanCallable
    extends BaseManager.TargetAwareOp {
        AbstractRemotelyCallable<Boolean> arp;

        public AsyncRemotelyBooleanCallable() {
            super(ClusterManager.this);
            this.arp = null;
        }

        public void executeProcess(Address address, AbstractRemotelyCallable<Boolean> arp) {
            this.arp = arp;
            this.target = address;
            arp.setNode(ClusterManager.this.node);
            this.setLocal(ClusterOperation.REMOTELY_CALLABLE_BOOLEAN, "call", null, arp, 0L, -1L);
            this.request.setBooleanRequest();
            this.doOp();
        }

        @Override
        public Address getTarget() {
            return this.target;
        }

        @Override
        public void onDisconnect(Address dead) {
            if (dead.equals(this.target)) {
                ClusterManager.this.removeCall(this.getCallId());
                this.setResult(Boolean.FALSE);
            }
        }

        @Override
        public void process() {
            if (!ClusterManager.this.thisAddress.equals(this.target) && ((ClusterManager)ClusterManager.this).node.connectionManager.getConnection(this.target) == null) {
                this.setResult(Boolean.FALSE);
            } else {
                super.process();
            }
        }

        @Override
        public void doLocalOp() {
            try {
                Boolean result = (Boolean)this.arp.call();
                this.setResult(result);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void setTarget() {
        }

        @Override
        public void redo() {
            ClusterManager.this.removeCall(this.getCallId());
            this.setResult(Boolean.FALSE);
        }

        @Override
        protected void memberDoesNotExist() {
            this.setResult(Boolean.FALSE);
        }

        @Override
        protected void packetNotSent() {
            this.setResult(Boolean.FALSE);
        }
    }

    public static class RemoveMember
    implements RemotelyProcessable {
        Address deadAddress;
        transient Node node;

        public RemoveMember(Address deadAddress) {
            this.deadAddress = deadAddress;
        }

        public RemoveMember() {
        }

        public void setConnection(Connection conn) {
        }

        public void writeData(DataOutput out) throws IOException {
            this.deadAddress.writeData(out);
        }

        public void readData(DataInput in) throws IOException {
            this.deadAddress = new Address();
            this.deadAddress.readData(in);
        }

        public Node getNode() {
            return this.node;
        }

        public void setNode(Node node) {
            this.node = node;
        }

        public void process() {
            this.node.clusterManager.doRemoveAddress(this.deadAddress);
        }
    }

    class JoinCall
    extends BaseManager.ConnectionAwareOp {
        JoinCall(Connection target) {
            super(ClusterManager.this, target);
        }

        JoinInfo checkJoin() {
            this.setLocal(ClusterOperation.JOIN_CHECK, "join", null, ClusterManager.this.node.createJoinInfo(), 0L, 0L);
            this.doOp();
            return (JoinInfo)this.getResultAsObject();
        }
    }
}

