/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.impl.LocalTopicOperationStatsImpl;
import com.hazelcast.monitor.LocalTopicOperationStats;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopicOperationsCounter {
    private AtomicLong messagePublishes = new AtomicLong();
    private AtomicLong receivedMessages = new AtomicLong();
    private long startTime = this.now();
    private long endTime = Long.MAX_VALUE;
    private transient LocalTopicOperationStats published = null;
    private List<TopicOperationsCounter> listOfSubStats = new ArrayList<TopicOperationsCounter>();
    private final Object lock = new Object();
    private final LocalTopicOperationStats empty = new LocalTopicOperationStatsImpl();
    private final long interval;

    public TopicOperationsCounter() {
        this(5000L);
    }

    public TopicOperationsCounter(long interval) {
        this.interval = interval;
    }

    private TopicOperationsCounter getAndReset() {
        TopicOperationsCounter newOne = new TopicOperationsCounter();
        newOne.messagePublishes.set(this.messagePublishes.getAndSet(0L));
        newOne.receivedMessages.set(this.receivedMessages.getAndSet(0L));
        newOne.startTime = this.startTime;
        this.startTime = newOne.endTime = this.now();
        return newOne;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalTopicOperationStats getPublishedStats() {
        if (this.published == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.published == null) {
                    this.published = this.getThis();
                }
            }
        }
        if (this.published.getPeriodEnd() < this.now() - this.interval) {
            return this.empty;
        }
        return this.published;
    }

    public void incrementPublishes() {
        this.messagePublishes.incrementAndGet();
        this.publishSubResult();
    }

    public void incrementReceivedMessages() {
        this.receivedMessages.incrementAndGet();
        this.publishSubResult();
    }

    long now() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishSubResult() {
        long subInterval = this.interval / 5L;
        if (this.now() - this.startTime > subInterval) {
            Object object = this.lock;
            synchronized (object) {
                if (this.now() - this.startTime >= subInterval) {
                    TopicOperationsCounter copy = this.getAndReset();
                    if (this.listOfSubStats.size() == 5) {
                        this.listOfSubStats.remove(0);
                    }
                    this.listOfSubStats.add(copy);
                    this.published = this.aggregate(this.listOfSubStats);
                }
            }
        }
    }

    private LocalTopicOperationStats aggregate(List<TopicOperationsCounter> list) {
        LocalTopicOperationStatsImpl stats = new LocalTopicOperationStatsImpl();
        stats.periodStart = list.get((int)0).startTime;
        for (int i = 0; i < list.size(); ++i) {
            TopicOperationsCounter sub = list.get(i);
            stats.numberOfPublishes += sub.messagePublishes.get();
            stats.numberOfReceives += sub.receivedMessages.get();
            stats.periodEnd = sub.endTime;
        }
        return stats;
    }

    private LocalTopicOperationStats getThis() {
        LocalTopicOperationStatsImpl stats = new LocalTopicOperationStatsImpl();
        stats.periodStart = this.startTime;
        stats.numberOfPublishes = this.messagePublishes.get();
        stats.numberOfReceives = this.receivedMessages.get();
        stats.periodEnd = this.now();
        return stats;
    }
}

