/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.impl.Node;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.SelectionHandler;
import com.hazelcast.nio.SelectorBase;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;

public final class OutSelector
extends SelectorBase {
    AtomicLong writeQueueSize = new AtomicLong();

    public OutSelector(Node node) {
        super(node, 1);
    }

    public void connect(Address address) {
        this.logger.log(Level.FINEST, "connect to " + address);
        Connector connector = new Connector(address);
        this.addTask(connector);
    }

    public void publishUtilization() {
        this.node.getCpuUtilization().outThread = this.threadWatcher.publish(this.live);
    }

    public long getWriteQueueSize() {
        return this.writeQueueSize.get();
    }

    public void resetWriteQueueSize() {
        this.writeQueueSize.set(this.node.connectionManager.getTotalWriteQueueSize());
    }

    private class Connector
    implements Runnable,
    SelectionHandler {
        final Address address;
        SocketChannel socketChannel = null;
        long startTime;
        long lastCheck = this.startTime = System.currentTimeMillis();

        public Connector(Address address) {
            this.address = address;
        }

        public void handle() {
            try {
                boolean finished = this.socketChannel.finishConnect();
                if (!finished) {
                    long now = System.currentTimeMillis();
                    if (now - this.lastCheck > 5000L) {
                        OutSelector.this.logger.log(Level.WARNING, "Couldn't connect to " + this.address + " for " + (now - this.startTime) / 1000L + " seconds!");
                        this.lastCheck = now;
                    }
                    this.socketChannel.register(OutSelector.this.selector, 8, this);
                    return;
                }
                OutSelector.this.logger.log(Level.FINEST, "connected to " + this.address);
                Connection connection = OutSelector.this.createConnection(this.socketChannel, false);
                OutSelector.this.node.connectionManager.bind(this.address, connection, false);
            }
            catch (Throwable e) {
                try {
                    String msg = "Couldn't connect to " + this.address + ", cause: " + e.getMessage();
                    OutSelector.this.logger.log(Level.FINEST, msg, e);
                    this.socketChannel.close();
                    OutSelector.this.node.connectionManager.failedConnection(this.address);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void run() {
            try {
                this.socketChannel = SocketChannel.open();
                OutSelector.this.initSocket(this.socketChannel.socket());
                Address thisAddress = OutSelector.this.node.getThisAddress();
                this.socketChannel.configureBlocking(false);
                this.socketChannel.socket().bind(new InetSocketAddress(thisAddress.getInetAddress(), 0));
                OutSelector.this.logger.log(Level.FINEST, "connecting to " + this.address);
                boolean connected = this.socketChannel.connect(new InetSocketAddress(this.address.getInetAddress(), this.address.getPort()));
                OutSelector.this.logger.log(Level.FINEST, "connection check. connected: " + connected + ", " + this.address);
                this.handle();
            }
            catch (Throwable e) {
                OutSelector.this.logger.log(Level.WARNING, "Connection failure to " + this.address, e);
                if (this.socketChannel != null) {
                    try {
                        this.socketChannel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                OutSelector.this.node.connectionManager.failedConnection(this.address);
            }
        }
    }
}

