/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.executor;

import com.hazelcast.impl.executor.ParallelExecutor;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ParallelExecutorService {
    private final ExecutorService executorService;

    public ParallelExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void shutdown() {
        try {
            this.executorService.shutdown();
            this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public ParallelExecutor newParallelExecutor(int concurrencyLevel) {
        if (concurrencyLevel > 0 && concurrencyLevel < Integer.MAX_VALUE) {
            return new ParallelExecutorImpl(concurrencyLevel);
        }
        return new FullyParallelExecutorImpl();
    }

    class ParallelExecutorImpl
    implements ParallelExecutor {
        final ExecutionSegment[] executionSegments;
        final AtomicInteger offerIndex = new AtomicInteger();
        final AtomicInteger activeCount = new AtomicInteger();

        ParallelExecutorImpl(int concurrencyLevel) {
            this.executionSegments = new ExecutionSegment[concurrencyLevel];
            for (int i = 0; i < concurrencyLevel; ++i) {
                this.executionSegments[i] = new ExecutionSegment(i);
            }
        }

        public void execute(Runnable runnable) {
            int hash = this.offerIndex.incrementAndGet();
            int index = hash == Integer.MIN_VALUE ? 0 : Math.abs(hash) % this.executionSegments.length;
            ExecutionSegment segment = this.executionSegments[index];
            segment.offer(runnable);
            if (index >= 1000000) {
                this.offerIndex.set(0);
            }
        }

        public void execute(Runnable runnable, int hash) {
            int index = hash == Integer.MIN_VALUE ? 0 : Math.abs(hash) % this.executionSegments.length;
            ExecutionSegment segment = this.executionSegments[index];
            segment.offer(runnable);
        }

        public void shutdown() {
            for (ExecutionSegment executionSegment : this.executionSegments) {
                executionSegment.shutdown();
            }
        }

        public int getPoolSize() {
            int size = 0;
            for (ExecutionSegment executionSegment : this.executionSegments) {
                size += executionSegment.size();
            }
            return size;
        }

        public int getActiveCount() {
            return this.activeCount.get();
        }

        class ExecutionSegment
        implements Runnable {
            final ConcurrentLinkedQueue<Runnable> q = new ConcurrentLinkedQueue();
            final AtomicInteger size = new AtomicInteger();
            final int segmentIndex;

            ExecutionSegment(int segmentIndex) {
                this.segmentIndex = segmentIndex;
            }

            public void offer(Runnable e) {
                this.q.offer(e);
                if (this.size.incrementAndGet() == 1) {
                    ParallelExecutorService.this.executorService.execute(this);
                }
            }

            public void run() {
                ParallelExecutorImpl.this.activeCount.incrementAndGet();
                Runnable r = this.q.poll();
                while (r != null) {
                    r.run();
                    this.size.decrementAndGet();
                    r = this.q.poll();
                }
                ParallelExecutorImpl.this.activeCount.decrementAndGet();
            }

            public void shutdown() {
                Runnable r = this.q.poll();
                while (r != null) {
                    this.size.decrementAndGet();
                    r = this.q.poll();
                }
            }

            public int size() {
                return this.size.get();
            }
        }
    }

    class FullyParallelExecutorImpl
    implements ParallelExecutor {
        FullyParallelExecutorImpl() {
        }

        public void execute(Runnable runnable) {
            ParallelExecutorService.this.executorService.execute(runnable);
        }

        public void execute(Runnable runnable, int hash) {
            ParallelExecutorService.this.executorService.execute(runnable);
        }

        public void shutdown() {
        }

        public int getPoolSize() {
            return 0;
        }

        public int getActiveCount() {
            return 0;
        }
    }
}

