/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.impl.GroupProperties;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.FastByteArrayInputStream;
import com.hazelcast.nio.FastByteArrayOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.util.Date;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Serializer {
    private static final ILogger logger = Logger.getLogger(Serializer.class.getName());
    private static final byte SERIALIZER_TYPE_DATA = 0;
    private static final byte SERIALIZER_TYPE_OBJECT = 1;
    private static final byte SERIALIZER_TYPE_BYTE_ARRAY = 2;
    private static final byte SERIALIZER_TYPE_INTEGER = 3;
    private static final byte SERIALIZER_TYPE_LONG = 4;
    private static final byte SERIALIZER_TYPE_CLASS = 5;
    private static final byte SERIALIZER_TYPE_STRING = 6;
    private static final byte SERIALIZER_TYPE_DATE = 7;
    private static final byte SERIALIZER_TYPE_BIG_INTEGER = 8;
    private static TypeSerializer[] typeSerializer = new TypeSerializer[9];
    private static int OUTPUT_STREAM_BUFFER_SIZE = 102400;
    private static final boolean gzipEnabled = GroupProperties.SERIALIZER_GZIP_ENABLED.getBoolean();
    final FastByteArrayOutputStream bbos = new FastByteArrayOutputStream(OUTPUT_STREAM_BUFFER_SIZE);
    final FastByteArrayInputStream bbis = new FastByteArrayInputStream(new byte[10]);

    public static Class<?> classForName(String className) throws ClassNotFoundException {
        return Serializer.classForName(null, className);
    }

    public static Object newInstance(Class klass) throws Exception {
        Constructor constructor = klass.getDeclaredConstructor(new Class[0]);
        if (!constructor.isAccessible()) {
            constructor.setAccessible(true);
        }
        return constructor.newInstance(new Object[0]);
    }

    public static Class<?> classForName(ClassLoader classLoader, String className) throws ClassNotFoundException {
        if (className == null) {
            throw new IllegalArgumentException("ClassName cannot be null!");
        }
        if (className.startsWith("com.hazelcast")) {
            return Class.forName(className, true, Serializer.class.getClassLoader());
        }
        ClassLoader theClassLoader = classLoader;
        if (theClassLoader == null) {
            theClassLoader = Thread.currentThread().getContextClassLoader();
        }
        if (theClassLoader != null) {
            return Class.forName(className, true, theClassLoader);
        }
        return Class.forName(className);
    }

    public Data writeObject(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Data) {
            return (Data)obj;
        }
        try {
            this.bbos.reset();
            int typeId = 1;
            if (obj instanceof DataSerializable) {
                typeId = 0;
            } else if (obj instanceof byte[]) {
                typeId = 2;
            } else if (obj instanceof Long) {
                typeId = 4;
            } else if (obj instanceof Integer) {
                typeId = 3;
            } else if (obj instanceof String) {
                typeId = 6;
            } else if (obj instanceof Date) {
                typeId = 7;
            } else if (obj instanceof Class) {
                typeId = 5;
            } else if (obj instanceof BigInteger) {
                typeId = 8;
            }
            this.bbos.writeByte(typeId);
            typeSerializer[typeId].write(this.bbos, obj);
            Data data = new Data(this.bbos.toByteArray());
            if (this.bbos.size() > OUTPUT_STREAM_BUFFER_SIZE) {
                this.bbos.set(new byte[OUTPUT_STREAM_BUFFER_SIZE]);
            }
            return data;
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    public Object readObject(Data data) {
        try {
            if (data == null || data.size() == 0) {
                return null;
            }
            this.bbis.set(data.buffer, data.size());
            byte typeId = this.bbis.readByte();
            Object obj = typeSerializer[typeId].read(this.bbis);
            if (obj instanceof HazelcastInstanceAware) {
                ((HazelcastInstanceAware)obj).setHazelcastInstance(ThreadContext.get().getCurrentFactory());
            }
            return obj;
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    private static void registerTypeSerializer(TypeSerializer ts) {
        Serializer.typeSerializer[ts.getTypeId()] = ts;
    }

    public static ObjectInputStream newObjectInputStream(InputStream in) throws IOException {
        return new ObjectInputStream(in){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
                return Serializer.classForName(desc.getName());
            }
        };
    }

    static {
        Serializer.registerTypeSerializer(new ObjectSerializer());
        Serializer.registerTypeSerializer(new LongSerializer());
        Serializer.registerTypeSerializer(new IntegerSerializer());
        Serializer.registerTypeSerializer(new StringSerializer());
        Serializer.registerTypeSerializer(new ClassSerializer());
        Serializer.registerTypeSerializer(new ByteArraySerializer());
        Serializer.registerTypeSerializer(new DataSerializer());
        Serializer.registerTypeSerializer(new DateSerializer());
        Serializer.registerTypeSerializer(new BigIntegerSerializer());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface TypeSerializer<T> {
        public byte getTypeId();

        public void write(FastByteArrayOutputStream var1, T var2) throws Exception;

        public T read(FastByteArrayInputStream var1) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ObjectSerializer
    implements TypeSerializer<Object> {
        static final boolean shared = GroupProperties.SERIALIZER_SHARED.getBoolean();

        ObjectSerializer() {
        }

        @Override
        public byte getTypeId() {
            return 1;
        }

        @Override
        public Object read(FastByteArrayInputStream bbis) throws Exception {
            if (gzipEnabled) {
                return this.readGZip(bbis);
            }
            return this.readNormal(bbis);
        }

        @Override
        public void write(FastByteArrayOutputStream bbos, Object obj) throws Exception {
            if (gzipEnabled) {
                this.writeGZip(bbos, obj);
            } else {
                this.writeNormal(bbos, obj);
            }
        }

        private Object readGZip(FastByteArrayInputStream bbis) throws Exception {
            BufferedInputStream zis = new BufferedInputStream(new GZIPInputStream(bbis));
            ObjectInputStream in = Serializer.newObjectInputStream(zis);
            Object result = shared ? in.readObject() : in.readUnshared();
            in.close();
            return result;
        }

        private Object readNormal(FastByteArrayInputStream bbis) throws Exception {
            ObjectInputStream in = Serializer.newObjectInputStream(bbis);
            Object result = shared ? in.readObject() : in.readUnshared();
            in.close();
            return result;
        }

        private void writeGZip(FastByteArrayOutputStream bbos, Object obj) throws Exception {
            BufferedOutputStream zos = new BufferedOutputStream(new GZIPOutputStream(bbos));
            ObjectOutputStream os = new ObjectOutputStream(zos);
            if (shared) {
                os.writeObject(obj);
            } else {
                os.writeUnshared(obj);
            }
            os.flush();
            os.close();
        }

        private void writeNormal(FastByteArrayOutputStream bbos, Object obj) throws Exception {
            ObjectOutputStream os = new ObjectOutputStream(bbos);
            if (shared) {
                os.writeObject(obj);
            } else {
                os.writeUnshared(obj);
            }
            os.flush();
            os.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DataSerializer
    implements TypeSerializer<DataSerializable> {
        DataSerializer() {
        }

        @Override
        public byte getTypeId() {
            return 0;
        }

        @Override
        public DataSerializable read(FastByteArrayInputStream bbis) throws Exception {
            String className = bbis.readUTF();
            try {
                DataSerializable ds = (DataSerializable)Serializer.newInstance(Serializer.classForName(className));
                ds.readData(bbis);
                return ds;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException("Problem reading DataSerializable class : " + className + ", exception: " + e);
            }
        }

        @Override
        public void write(FastByteArrayOutputStream bbos, DataSerializable obj) throws Exception {
            bbos.writeUTF(obj.getClass().getName());
            obj.writeData(bbos);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ByteArraySerializer
    implements TypeSerializer<byte[]> {
        ByteArraySerializer() {
        }

        @Override
        public byte getTypeId() {
            return 2;
        }

        @Override
        public byte[] read(FastByteArrayInputStream bbis) throws Exception {
            int size = bbis.readInt();
            byte[] bytes = new byte[size];
            bbis.read(bytes);
            return bytes;
        }

        @Override
        public void write(FastByteArrayOutputStream bbos, byte[] obj) throws Exception {
            bbos.writeInt(obj.length);
            bbos.write(obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StringSerializer
    implements TypeSerializer<String> {
        StringSerializer() {
        }

        @Override
        public byte getTypeId() {
            return 6;
        }

        @Override
        public String read(FastByteArrayInputStream bbis) throws Exception {
            return bbis.readUTF();
        }

        @Override
        public void write(FastByteArrayOutputStream bbos, String obj) throws Exception {
            bbos.writeUTF(obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ClassSerializer
    implements TypeSerializer<Class> {
        ClassSerializer() {
        }

        @Override
        public byte getTypeId() {
            return 5;
        }

        @Override
        public Class read(FastByteArrayInputStream bbis) throws Exception {
            return Serializer.classForName(bbis.readUTF());
        }

        @Override
        public void write(FastByteArrayOutputStream bbos, Class obj) throws Exception {
            bbos.writeUTF(obj.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IntegerSerializer
    implements TypeSerializer<Integer> {
        IntegerSerializer() {
        }

        @Override
        public byte getTypeId() {
            return 3;
        }

        @Override
        public Integer read(FastByteArrayInputStream bbis) throws Exception {
            return bbis.readInt();
        }

        @Override
        public void write(FastByteArrayOutputStream bbos, Integer obj) throws Exception {
            bbos.writeInt(obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BigIntegerSerializer
    implements TypeSerializer<BigInteger> {
        BigIntegerSerializer() {
        }

        @Override
        public byte getTypeId() {
            return 8;
        }

        @Override
        public BigInteger read(FastByteArrayInputStream bbis) throws Exception {
            byte[] bytes = new byte[bbis.readInt()];
            bbis.read(bytes);
            return new BigInteger(bytes);
        }

        @Override
        public void write(FastByteArrayOutputStream bbos, BigInteger obj) throws Exception {
            byte[] bytes = obj.toByteArray();
            bbos.writeInt(bytes.length);
            bbos.write(bytes);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DateSerializer
    implements TypeSerializer<Date> {
        DateSerializer() {
        }

        @Override
        public byte getTypeId() {
            return 7;
        }

        @Override
        public Date read(FastByteArrayInputStream bbis) throws Exception {
            return new Date(bbis.readLong());
        }

        @Override
        public void write(FastByteArrayOutputStream bbos, Date obj) throws Exception {
            bbos.writeLong(obj.getTime());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LongSerializer
    implements TypeSerializer<Long> {
        LongSerializer() {
        }

        @Override
        public byte getTypeId() {
            return 4;
        }

        @Override
        public Long read(FastByteArrayInputStream bbis) throws Exception {
            return bbis.readLong();
        }

        @Override
        public void write(FastByteArrayOutputStream bbos, Long obj) throws Exception {
            bbos.writeLong(obj);
        }
    }
}

