/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.examples;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.IMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;

public class SimpleFunctionalMapTest {
    public static final int ENTRY_COUNT = 1000;
    public static final int KB = 10240;
    public static final int STATS_SECONDS = 10;

    public static void main(String[] args) {
        int threadCount = 40;
        final Stats stats = new Stats();
        ExecutorService es = Executors.newFixedThreadPool(threadCount);
        for (int i = 0; i < threadCount; ++i) {
            es.submit(new Runnable(){

                public void run() {
                    IMap<String, Object> map = Hazelcast.getMap("default");
                    while (true) {
                        Collection col;
                        int keyInt = (int)(Math.random() * 1000.0);
                        int operation = (int)(Math.random() * 1000.0) % 20;
                        String key = String.valueOf(keyInt);
                        if (operation < 1) {
                            map.size();
                            stats.increment("size");
                            continue;
                        }
                        if (operation < 2) {
                            map.get(key);
                            stats.increment("get");
                            continue;
                        }
                        if (operation < 3) {
                            map.remove(key);
                            stats.increment("remove");
                            continue;
                        }
                        if (operation < 4) {
                            map.containsKey(key);
                            stats.increment("containsKey");
                            continue;
                        }
                        if (operation < 5) {
                            String value = new String(String.valueOf(key));
                            map.containsValue(value);
                            stats.increment("containsValue");
                            continue;
                        }
                        if (operation < 6) {
                            map.putIfAbsent(key, SimpleFunctionalMapTest.createValue());
                            stats.increment("putIfAbsent");
                            continue;
                        }
                        if (operation < 7) {
                            col = map.values();
                            for (Object v : col) {
                            }
                            stats.increment("values");
                            continue;
                        }
                        if (operation < 8) {
                            col = map.keySet();
                            for (Object v : col) {
                            }
                            stats.increment("keySet");
                            continue;
                        }
                        if (operation < 9) {
                            col = map.entrySet();
                            for (Object v : col) {
                            }
                            stats.increment("entrySet");
                            continue;
                        }
                        map.put(key, SimpleFunctionalMapTest.createValue());
                        stats.increment("put");
                    }
                }
            });
        }
        Executors.newSingleThreadExecutor().submit(new Runnable(){

            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(10000L);
                            System.out.println("cluster size:" + Hazelcast.getCluster().getMembers().size());
                            Stats currentStats = stats.getAndReset();
                            System.out.println(currentStats);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
    }

    public static Object createValue() {
        int numberOfK = (int)(Math.random() * 1000.0) % 40 + 1;
        return new byte[numberOfK * 10240];
    }

    public static class Stats {
        Map<String, AtomicLong> mapStats = new ConcurrentHashMap<String, AtomicLong>(10);

        public Stats() {
            this.mapStats.put("put", new AtomicLong(0L));
            this.mapStats.put("get", new AtomicLong(0L));
            this.mapStats.put("remove", new AtomicLong(0L));
            this.mapStats.put("size", new AtomicLong(0L));
            this.mapStats.put("containsKey", new AtomicLong(0L));
            this.mapStats.put("containsValue", new AtomicLong(0L));
            this.mapStats.put("clear", new AtomicLong(0L));
            this.mapStats.put("keySet", new AtomicLong(0L));
            this.mapStats.put("values", new AtomicLong(0L));
            this.mapStats.put("entrySet", new AtomicLong(0L));
            this.mapStats.put("putIfAbsent", new AtomicLong(0L));
        }

        public Stats getAndReset() {
            Stats newOne = new Stats();
            Set<Map.Entry<String, AtomicLong>> entries = newOne.mapStats.entrySet();
            for (Map.Entry<String, AtomicLong> entry : entries) {
                String key = entry.getKey();
                AtomicLong value = entry.getValue();
                value.set(this.mapStats.get(key).getAndSet(0L));
            }
            return newOne;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            long total = 0L;
            Set<Map.Entry<String, AtomicLong>> entries = this.mapStats.entrySet();
            for (Map.Entry<String, AtomicLong> entry : entries) {
                String key = entry.getKey();
                AtomicLong value = entry.getValue();
                sb.append(key + ":" + value.get());
                sb.append("\n");
                total += value.get();
            }
            sb.append("Operations per Second : " + total / 10L + " \n");
            return sb.toString();
        }

        public void increment(String operation) {
            this.mapStats.get(operation).incrementAndGet();
        }
    }
}

