/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.cache;

import com.hazelcast.cache.impl.CacheEventListener;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.client.CacheBatchInvalidationMessage;
import com.hazelcast.cache.impl.client.CacheInvalidationMessage;
import com.hazelcast.cache.impl.client.CacheSingleInvalidationMessage;
import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheAddInvalidationListenerCodec;
import com.hazelcast.client.impl.protocol.task.AbstractCallableMessageTask;
import com.hazelcast.instance.Node;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.serialization.Data;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;

public class CacheAddInvalidationListenerTask
extends AbstractCallableMessageTask<CacheAddInvalidationListenerCodec.RequestParameters> {
    public CacheAddInvalidationListenerTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Object call() {
        final ClientEndpoint endpoint = this.getEndpoint();
        CacheService cacheService = (CacheService)this.getService("hz:impl:cacheService");
        String registrationId = cacheService.addInvalidationListener(((CacheAddInvalidationListenerCodec.RequestParameters)this.parameters).name, new CacheEventListener(){

            @Override
            public void handleEvent(Object eventObject) {
                if (!endpoint.isAlive()) {
                    return;
                }
                if (eventObject instanceof CacheInvalidationMessage) {
                    if (eventObject instanceof CacheSingleInvalidationMessage) {
                        CacheSingleInvalidationMessage message = (CacheSingleInvalidationMessage)eventObject;
                        ClientMessage eventMessage = CacheAddInvalidationListenerCodec.encodeCacheInvalidationEvent(message.getName(), message.getKey(), message.getSourceUuid());
                        CacheAddInvalidationListenerTask.this.sendClientMessage(message.getName(), eventMessage);
                    } else if (eventObject instanceof CacheBatchInvalidationMessage) {
                        CacheBatchInvalidationMessage message = (CacheBatchInvalidationMessage)eventObject;
                        List<CacheSingleInvalidationMessage> invalidationMessages = message.getInvalidationMessages();
                        ArrayList<Data> keys = new ArrayList<Data>(invalidationMessages.size());
                        ArrayList<String> sourceUuids = new ArrayList<String>(invalidationMessages.size());
                        for (CacheSingleInvalidationMessage invalidationMessage : invalidationMessages) {
                            keys.add(invalidationMessage.getKey());
                            sourceUuids.add(invalidationMessage.getSourceUuid());
                        }
                        ClientMessage eventMessage = CacheAddInvalidationListenerCodec.encodeCacheBatchInvalidationEvent(message.getName(), keys, sourceUuids);
                        CacheAddInvalidationListenerTask.this.sendClientMessage(message.getName(), eventMessage);
                    }
                }
            }
        });
        endpoint.setListenerRegistration("hz:impl:cacheService", ((CacheAddInvalidationListenerCodec.RequestParameters)this.parameters).name, registrationId);
        return registrationId;
    }

    @Override
    protected CacheAddInvalidationListenerCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return CacheAddInvalidationListenerCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return CacheAddInvalidationListenerCodec.encodeResponse((String)response);
    }

    @Override
    public String getDistributedObjectName() {
        return ((CacheAddInvalidationListenerCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return null;
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }
}

