/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionType;
import com.hazelcast.nio.SocketWritable;
import com.hazelcast.nio.tcp.IOSelector;
import com.hazelcast.nio.tcp.ReadHandler;
import com.hazelcast.nio.tcp.SocketChannelWrapper;
import com.hazelcast.nio.tcp.TcpIpConnectionManager;
import com.hazelcast.nio.tcp.TcpIpConnectionMonitor;
import com.hazelcast.nio.tcp.WriteHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;

public final class TcpIpConnection
implements Connection {
    private final SocketChannelWrapper socketChannel;
    private final ReadHandler readHandler;
    private final WriteHandler writeHandler;
    private final TcpIpConnectionManager connectionManager;
    private volatile boolean live = true;
    private volatile ConnectionType type = ConnectionType.NONE;
    private Address endPoint;
    private final ILogger logger;
    private final int connectionId;
    private TcpIpConnectionMonitor monitor;

    public TcpIpConnection(TcpIpConnectionManager connectionManager, IOSelector in, IOSelector out, int connectionId, SocketChannelWrapper socketChannel) {
        this.connectionId = connectionId;
        this.logger = connectionManager.ioService.getLogger(TcpIpConnection.class.getName());
        this.connectionManager = connectionManager;
        this.socketChannel = socketChannel;
        this.writeHandler = new WriteHandler(this, out);
        this.readHandler = new ReadHandler(this, in);
    }

    public void start() {
        this.readHandler.start();
    }

    @Override
    public ConnectionType getType() {
        return this.type;
    }

    public TcpIpConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public boolean write(SocketWritable packet) {
        if (!this.live) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Connection is closed, won't write packet -> " + packet);
            }
            return false;
        }
        this.writeHandler.offer(packet);
        return true;
    }

    @Override
    public boolean isClient() {
        ConnectionType t = this.type;
        return t != null && t != ConnectionType.NONE && t.isClient();
    }

    public void setType(ConnectionType type) {
        if (this.type == ConnectionType.NONE) {
            this.type = type;
        }
    }

    public SocketChannelWrapper getSocketChannelWrapper() {
        return this.socketChannel;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.socketChannel.socket().getInetAddress();
    }

    @Override
    public int getPort() {
        return this.socketChannel.socket().getPort();
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress() {
        return (InetSocketAddress)this.socketChannel.socket().getRemoteSocketAddress();
    }

    public ReadHandler getReadHandler() {
        return this.readHandler;
    }

    public WriteHandler getWriteHandler() {
        return this.writeHandler;
    }

    @Override
    public boolean isAlive() {
        return this.live;
    }

    @Override
    public long lastWriteTime() {
        return this.writeHandler.getLastHandle();
    }

    @Override
    public long lastReadTime() {
        return this.readHandler.getLastHandle();
    }

    @Override
    public Address getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(Address endPoint) {
        this.endPoint = endPoint;
    }

    public void setMonitor(TcpIpConnectionMonitor monitor) {
        this.monitor = monitor;
    }

    public TcpIpConnectionMonitor getMonitor() {
        return this.monitor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TcpIpConnection)) {
            return false;
        }
        TcpIpConnection that = (TcpIpConnection)o;
        return this.connectionId == that.getConnectionId();
    }

    public int hashCode() {
        return this.connectionId;
    }

    private void close0() throws IOException {
        if (!this.live) {
            return;
        }
        this.live = false;
        if (this.socketChannel != null && this.socketChannel.isOpen()) {
            this.readHandler.shutdown();
            this.writeHandler.shutdown();
            this.socketChannel.close();
        }
    }

    @Override
    public void close() {
        this.close(null);
    }

    public void close(Throwable t) {
        if (!this.live) {
            return;
        }
        try {
            this.close0();
        }
        catch (Exception e) {
            this.logger.warning(e);
        }
        Address connAddress = this.endPoint == null ? this.socketChannel.socket().getRemoteSocketAddress() : this.endPoint;
        String message = "Connection [" + connAddress + "] lost. Reason: ";
        message = t != null ? message + t.getClass().getName() + "[" + t.getMessage() + "]" : message + "Socket explicitly closed";
        this.logger.info(message);
        this.connectionManager.destroyConnection(this);
        this.connectionManager.ioService.onDisconnect(this.endPoint);
        if (t != null && this.monitor != null) {
            this.monitor.onError(t);
        }
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public String toString() {
        Socket socket = this.socketChannel.socket();
        SocketAddress localSocketAddress = socket != null ? socket.getLocalSocketAddress() : null;
        SocketAddress remoteSocketAddress = socket != null ? socket.getRemoteSocketAddress() : null;
        return "Connection [" + localSocketAddress + " -> " + remoteSocketAddress + "], endpoint=" + this.endPoint + ", live=" + this.live + ", type=" + (Object)((Object)this.type);
    }
}

