/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs;

import java.io.IOException;
import org.apache.commons.vfs.util.Messages;

public final class FileSystemException
extends IOException {
    private final Throwable throwable;
    private final String code;
    private final String[] info;

    public FileSystemException(String code) {
        this(code, null, null);
    }

    public FileSystemException(String code, Object info0) {
        this(code, new Object[]{info0}, (Throwable)null);
    }

    public FileSystemException(String code, Object info0, Throwable throwable) {
        this(code, new Object[]{info0}, throwable);
    }

    public FileSystemException(String code, Object[] info) {
        this(code, info, (Throwable)null);
    }

    public FileSystemException(String code, Object[] info, Throwable throwable) {
        super(Messages.getString(code, info));
        if (info == null) {
            this.info = new String[0];
        } else {
            this.info = new String[info.length];
            int i = 0;
            while (i < info.length) {
                this.info[i] = String.valueOf(info[i]);
                ++i;
            }
        }
        this.code = code;
        this.throwable = throwable;
    }

    public FileSystemException(Throwable throwable) {
        this(throwable.getMessage(), null, throwable);
    }

    public final Throwable getCause() {
        return this.throwable;
    }

    public String getCode() {
        return this.code;
    }

    public String[] getInfo() {
        return this.info;
    }
}

