/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.example;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.FileUtil;
import org.apache.commons.vfs.Selectors;
import org.apache.commons.vfs.VFS;

public class Shell {
    private static final String CVS_ID = "$Id: Shell.java,v 1.6 2003/12/02 19:22:56 ggregory Exp $";
    private final FileSystemManager mgr = VFS.getManager();
    private FileObject cwd = this.mgr.resolveFile(System.getProperty("user.dir"));
    private BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));

    public static void main(String[] args) {
        try {
            new Shell().go();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private Shell() throws FileSystemException {
    }

    private void go() throws Exception {
        System.out.println("VFS Shell [$Id: Shell.java,v 1.6 2003/12/02 19:22:56 ggregory Exp $]");
        String[] cmd;
        while ((cmd = this.nextCommand()) != null) {
            if (cmd.length == 0) continue;
            String cmdName = cmd[0];
            if (cmdName.equalsIgnoreCase("exit") || cmdName.equalsIgnoreCase("quit")) {
                return;
            }
            try {
                this.handleCommand(cmd);
                continue;
            }
            catch (Exception e) {
                System.err.println("Command failed:");
                e.printStackTrace(System.err);
                continue;
            }
            break;
        }
        return;
    }

    private void handleCommand(String[] cmd) throws Exception {
        String cmdName = cmd[0];
        if (cmdName.equalsIgnoreCase("cat")) {
            this.cat(cmd);
        } else if (cmdName.equalsIgnoreCase("cd")) {
            this.cd(cmd);
        } else if (cmdName.equalsIgnoreCase("cp")) {
            this.cp(cmd);
        } else if (cmdName.equalsIgnoreCase("help")) {
            this.help();
        } else if (cmdName.equalsIgnoreCase("ls")) {
            this.ls(cmd);
        } else if (cmdName.equalsIgnoreCase("pwd")) {
            this.pwd();
        } else if (cmdName.equalsIgnoreCase("rm")) {
            this.rm(cmd);
        } else if (cmdName.equalsIgnoreCase("touch")) {
            this.touch(cmd);
        } else {
            System.err.println("Unknown command \"" + cmdName + "\".");
        }
    }

    private void help() {
        System.out.println("Commands:");
        System.out.println("cat <file>         Displays the contents of a file.");
        System.out.println("cd [folder]        Changes current folder.");
        System.out.println("cp <src> <dest>    Copies a file or folder.");
        System.out.println("help               Shows this message.");
        System.out.println("ls [-R] [path]     Lists contents of a file or folder.");
        System.out.println("pwd                Displays current folder.");
        System.out.println("rm <path>          Deletes a file or folder.");
        System.out.println("touch <path>       Sets the last-modified time of a file.");
        System.out.println("exit       Exits this program.");
        System.out.println("quit       Exits this program.");
    }

    private void rm(String[] cmd) throws Exception {
        if (cmd.length < 2) {
            throw new Exception("USAGE: rm <path>");
        }
        FileObject file = this.mgr.resolveFile(this.cwd, cmd[1]);
        file.delete(Selectors.SELECT_SELF);
    }

    private void cp(String[] cmd) throws Exception {
        if (cmd.length < 3) {
            throw new Exception("USAGE: cp <src> <dest>");
        }
        FileObject src = this.mgr.resolveFile(this.cwd, cmd[1]);
        FileObject dest = this.mgr.resolveFile(this.cwd, cmd[2]);
        if (dest.exists() && dest.getType() == FileType.FOLDER) {
            dest = dest.resolveFile(src.getName().getBaseName());
        }
        dest.copyFrom(src, Selectors.SELECT_ALL);
    }

    private void cat(String[] cmd) throws Exception {
        if (cmd.length < 2) {
            throw new Exception("USAGE: cat <path>");
        }
        FileObject file = this.mgr.resolveFile(this.cwd, cmd[1]);
        FileUtil.writeContent(file, System.out);
        System.out.println();
    }

    private void pwd() {
        System.out.println("Current folder is " + this.cwd.getName());
    }

    private void cd(String[] cmd) throws Exception {
        String path = cmd.length > 1 ? cmd[1] : System.getProperty("user.home");
        FileObject tmp = this.mgr.resolveFile(this.cwd, path);
        if (tmp.exists()) {
            this.cwd = tmp;
        } else {
            System.out.println("Folder does not exist: " + tmp.getName());
        }
        System.out.println("Current folder is " + this.cwd.getName());
    }

    private void ls(String[] cmd) throws FileSystemException {
        boolean recursive;
        int pos = 1;
        if (cmd.length > pos && cmd[pos].equals("-R")) {
            recursive = true;
            ++pos;
        } else {
            recursive = false;
        }
        FileObject file = cmd.length > pos ? this.mgr.resolveFile(this.cwd, cmd[pos]) : this.cwd;
        if (file.getType() == FileType.FOLDER) {
            System.out.println("Contents of " + file.getName());
            this.listChildren(file, recursive, "");
        } else {
            System.out.println(file.getName());
            FileContent content = file.getContent();
            System.out.println("Size: " + content.getSize() + " bytes.");
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
            String lastMod = dateFormat.format(new Date(content.getLastModifiedTime()));
            System.out.println("Last modified: " + lastMod);
        }
    }

    private void touch(String[] cmd) throws Exception {
        if (cmd.length < 2) {
            throw new Exception("USAGE: touch <path>");
        }
        FileObject file = this.mgr.resolveFile(this.cwd, cmd[1]);
        if (!file.exists()) {
            file.createFile();
        }
        file.getContent().setLastModifiedTime(System.currentTimeMillis());
    }

    private void listChildren(FileObject dir, boolean recursive, String prefix) throws FileSystemException {
        FileObject[] children = dir.getChildren();
        int i = 0;
        while (i < children.length) {
            FileObject child = children[i];
            System.out.print(prefix);
            System.out.print(child.getName().getBaseName());
            if (child.getType() == FileType.FOLDER) {
                System.out.println("/");
                if (recursive) {
                    this.listChildren(child, recursive, prefix + "    ");
                }
            } else {
                System.out.println();
            }
            ++i;
        }
    }

    private String[] nextCommand() throws IOException {
        System.out.print("> ");
        String line = this.reader.readLine();
        if (line == null) {
            return null;
        }
        ArrayList<String> cmd = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(line);
        while (tokens.hasMoreTokens()) {
            cmd.add(tokens.nextToken());
        }
        return cmd.toArray(new String[cmd.size()]);
    }
}

