/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.url;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.provider.AbstractFileProvider;
import org.apache.commons.vfs.provider.BasicFileName;
import org.apache.commons.vfs.provider.url.UrlFileSystem;

public class UrlFileProvider
extends AbstractFileProvider {
    public FileObject findFile(FileObject baseFile, String uri) throws FileSystemException {
        try {
            URL url = new URL(uri);
            URL rootUrl = new URL(url, "/");
            FileSystem fs = this.findFileSystem(rootUrl);
            if (fs == null) {
                BasicFileName rootName = new BasicFileName(rootUrl, "/");
                fs = new UrlFileSystem(rootName);
                this.addFileSystem(rootUrl, fs);
            }
            return fs.resolveFile(url.getPath());
        }
        catch (MalformedURLException e) {
            throw new FileSystemException("vfs.provider.url/badly-formed-uri.error", uri, (Throwable)e);
        }
    }
}

