/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.webdav;

import java.io.IOException;
import java.util.Collection;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.GenericFileName;
import org.apache.commons.vfs.provider.webdav.WebdavFileObject;
import org.apache.util.HttpURL;
import org.apache.webdav.lib.WebdavResource;

class WebDavFileSystem
extends AbstractFileSystem
implements FileSystem {
    private HttpClient client;

    public WebDavFileSystem(GenericFileName rootName) {
        super(rootName, null);
    }

    protected void addCapabilities(Collection caps) {
        caps.add(Capability.CREATE);
        caps.add(Capability.DELETE);
        caps.add(Capability.GET_TYPE);
        caps.add(Capability.LIST_CHILDREN);
        caps.add(Capability.READ_CONTENT);
        caps.add(Capability.URI);
        caps.add(Capability.WRITE_CONTENT);
        caps.add(Capability.GET_LAST_MODIFIED);
        caps.add(Capability.ATTRIBUTES);
    }

    protected HttpClient getClient() throws FileSystemException {
        if (this.client == null) {
            try {
                GenericFileName rootName = (GenericFileName)this.getRootName();
                HttpURL url = new HttpURL(rootName.getUserName(), rootName.getPassword(), rootName.getHostName(), rootName.getPort(), "/");
                WebdavResource resource = new WebdavResource(url, 1, 1);
                this.client = resource.retrieveSessionInstance();
            }
            catch (IOException e) {
                throw new FileSystemException("vfs.provider.webdav/create-client.error", this.getRootName(), (Throwable)e);
            }
        }
        return this.client;
    }

    protected FileObject createFile(FileName name) {
        GenericFileName fileName = (GenericFileName)name;
        return new WebdavFileObject(fileName, this);
    }
}

