/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dmr;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.ModelValue;

final class StringModelValue
extends ModelValue {
    private static final int THRESHOLD = 21845;
    private final String value;

    StringModelValue(String value) {
        super(ModelType.STRING);
        this.value = value;
    }

    StringModelValue(char typeChar, DataInput in) throws IOException {
        super(ModelType.STRING);
        if (typeChar == 's') {
            this.value = in.readUTF();
        } else {
            assert (typeChar == 'S');
            int length = in.readInt();
            char[] chars = new char[length];
            for (int i = 0; i < length; ++i) {
                int b;
                int a = in.readUnsignedByte();
                if (a < 128) {
                    chars[i] = (char)a;
                    continue;
                }
                if (a < 192) {
                    throw new UTFDataFormatException();
                }
                if (a < 224) {
                    b = in.readUnsignedByte();
                    if ((b & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    chars[i] = (char)((a & 0x1F) << 6 | b & 0x3F);
                    continue;
                }
                if (a < 240) {
                    b = in.readUnsignedByte();
                    if ((b & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    int c = in.readUnsignedByte();
                    if ((c & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    chars[i] = (char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F);
                    continue;
                }
                throw new UTFDataFormatException();
            }
            this.value = new String(chars);
        }
    }

    @Override
    void writeExternal(DataOutput out) throws IOException {
        int length = this.value.length();
        if (length > 21845) {
            char c;
            int i;
            int l = 0;
            for (i = 0; i < length; ++i) {
                c = this.value.charAt(i);
                if (c > '\u0000' && c <= '\u007f') {
                    ++l;
                    continue;
                }
                if (c <= '\u07ff') {
                    l += 2;
                    continue;
                }
                l += 3;
            }
            if (l > 65535) {
                out.write(83);
                out.writeInt(length);
                for (i = 0; i < length; ++i) {
                    c = this.value.charAt(i);
                    if (c > '\u0000' && c <= '\u007f') {
                        out.writeByte(c);
                        continue;
                    }
                    if (c <= '\u07ff') {
                        out.writeByte(0xC0 | 0x1F & c >> 6);
                        out.writeByte(0x80 | 0x3F & c);
                        continue;
                    }
                    out.writeByte(0xE0 | 0xF & c >> 12);
                    out.writeByte(0x80 | 0x3F & c >> 6);
                    out.writeByte(0x80 | 0x3F & c);
                }
                return;
            }
        }
        out.write(ModelType.STRING.typeChar);
        out.writeUTF(this.value);
    }

    @Override
    long asLong() {
        return Long.parseLong(this.value);
    }

    @Override
    long asLong(long defVal) {
        return Long.parseLong(this.value);
    }

    @Override
    int asInt() {
        return Integer.parseInt(this.value);
    }

    @Override
    int asInt(int defVal) {
        return Integer.parseInt(this.value);
    }

    @Override
    boolean asBoolean() {
        return Boolean.parseBoolean(this.value);
    }

    @Override
    boolean asBoolean(boolean defVal) {
        return Boolean.parseBoolean(this.value);
    }

    @Override
    double asDouble() {
        return Double.parseDouble(this.value);
    }

    @Override
    double asDouble(double defVal) {
        return Double.parseDouble(this.value);
    }

    @Override
    byte[] asBytes() {
        try {
            return this.value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return this.value.getBytes();
        }
    }

    @Override
    BigDecimal asBigDecimal() {
        return new BigDecimal(this.value);
    }

    @Override
    BigInteger asBigInteger() {
        return new BigInteger(this.value);
    }

    @Override
    String asString() {
        return this.value;
    }

    @Override
    ModelType asType() {
        return ModelType.valueOf(this.value);
    }

    @Override
    void format(PrintWriter writer, int indent, boolean multiLine) {
        writer.append(StringModelValue.quote(this.value));
    }

    @Override
    void formatAsJSON(PrintWriter writer, int indent, boolean multiLine) {
        writer.append(StringModelValue.jsonEscape(this.asString()));
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof StringModelValue && this.equals((StringModelValue)other);
    }

    public boolean equals(StringModelValue other) {
        return this == other || other != null && this.value.equals(other.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }
}

