/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.sasl.anonymous;

import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import org.jboss.sasl.util.AbstractSaslParticipant;
import org.jboss.sasl.util.AbstractSaslServer;
import org.jboss.sasl.util.Charsets;
import org.jboss.sasl.util.SaslState;
import org.jboss.sasl.util.SaslStateContext;

public final class AnonymousSaslServer
extends AbstractSaslServer {
    private static final SaslState INITIAL = new SaslState(){

        @Override
        public byte[] evaluateMessage(SaslStateContext context, byte[] message) throws SaslException {
            int length = message.length;
            if (length == 0) {
                return AbstractSaslParticipant.NO_BYTES;
            }
            if (length > 1020) {
                throw new SaslException("Authentication name string is too long");
            }
            String name = new String(message, Charsets.UTF_8);
            if (name.length() > 255) {
                throw new SaslException("Authentication name string is too long");
            }
            context.negotiationComplete();
            return null;
        }
    };

    public AnonymousSaslServer(String protocol, String serverName, CallbackHandler callbackHandler) {
        super("ANONYMOUS", protocol, serverName, callbackHandler);
        this.getContext().setNegotiationState(INITIAL);
    }

    @Override
    public String getAuthorizationID() {
        return "anonymous";
    }
}

