/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Digest;

public class Gossip
implements Serializable {
    Address sender = null;
    long id = -1L;
    Digest digest = null;
    Vector not_seen = null;
    Vector seen = new Vector(11);
    private static final long serialVersionUID = 7954243278668401185L;

    public Gossip(Address obj, long id) {
        this.sender = obj;
        this.id = id;
    }

    public Gossip(Address obj, long id, Digest d, Vector not_seen) {
        this.sender = obj;
        this.id = id;
        this.digest = d;
        this.not_seen = not_seen;
    }

    public void removeFromNotSeenList(Address mbr) {
        if (this.not_seen != null && mbr != null) {
            this.not_seen.removeElement(mbr);
        }
    }

    public void addToSeenList(Address mbr) {
        if (mbr != null && !this.seen.contains(mbr)) {
            this.seen.addElement(mbr);
        }
    }

    public int sizeOfNotSeenList() {
        return this.not_seen == null ? 0 : this.not_seen.size();
    }

    public Vector getNotSeenList() {
        return this.not_seen;
    }

    public Vector getSeenList() {
        return this.seen;
    }

    public boolean equals(Object o) {
        Gossip other = null;
        if (this.sender != null && o != null) {
            other = (Gossip)o;
            return this.sender.equals(other.sender) && this.id == other.id;
        }
        return false;
    }

    public int hashCode() {
        if (this.sender != null) {
            return this.sender.hashCode() + (int)this.id;
        }
        return (int)this.id;
    }

    public Gossip copy() {
        Gossip ret = new Gossip(this.sender, this.id);
        if (this.digest != null) {
            ret.digest = this.digest.copy();
        }
        if (this.not_seen != null) {
            ret.not_seen = (Vector)this.not_seen.clone();
        }
        if (this.seen != null) {
            ret.seen = (Vector)this.seen.clone();
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("sender=");
        if (this.sender != null) {
            sb.append(this.sender);
        } else {
            sb.append("<null>");
        }
        if (this.digest != null) {
            sb.append(", digest=" + this.digest);
        }
        if (this.not_seen != null) {
            sb.append(", not_seen=" + this.not_seen);
        }
        if (this.seen != null) {
            sb.append(", seen=" + this.seen);
        }
        sb.append(", id=" + this.id);
        return sb.toString();
    }

    public String shortForm() {
        StringBuilder sb = new StringBuilder();
        if (this.sender != null) {
            sb.append(this.sender);
        } else {
            sb.append("<null>");
        }
        sb.append("#" + this.id);
        return sb.toString();
    }

    public static void main(String[] args) throws UnknownHostException {
        Gossip id1 = new Gossip(new IpAddress("daddy", 4567), 23L);
        Gossip id2 = new Gossip(new IpAddress("133.164.130.19", 4567), 23L);
        System.out.println(id1.equals(id2));
    }
}

