/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import net.xeoh.plugins.base.Pluggable;
import net.xeoh.plugins.base.Plugin;
import net.xeoh.plugins.base.PluginInformation;
import net.xeoh.plugins.base.PluginManager;
import net.xeoh.plugins.base.annotations.Capabilities;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import net.xeoh.plugins.base.annotations.injections.InjectPlugin;
import net.xeoh.plugins.base.annotations.meta.Author;
import net.xeoh.plugins.base.annotations.meta.Version;
import net.xeoh.plugins.base.impl.PluginManagerImpl;
import net.xeoh.plugins.base.impl.metahandling.PluginWrapper;
import net.xeoh.plugins.base.impl.registry.PluggableMetaInformation;
import net.xeoh.plugins.base.impl.registry.PluginRegistry;

@Author(name="Ralf Biedert")
@Version(version=10000)
@PluginImplementation
public class PluginInformationImpl
implements PluginInformation {
    final Logger logger = Logger.getLogger(this.getClass().getName());
    @InjectPlugin
    public PluginManager pluginManager;

    @Override
    public Collection<String> getInformation(PluginInformation.Information item, Plugin _plugin) {
        PluginManagerImpl pmi = (PluginManagerImpl)this.pluginManager;
        Plugin pluggable = _plugin instanceof PluginWrapper ? ((PluginWrapper)((Object)_plugin)).getWrappedPlugin() : _plugin;
        ArrayList<String> rval = new ArrayList<String>();
        switch (item) {
            case CAPABILITIES: {
                String[] caps;
                for (String string : caps = this.getCaps(pluggable)) {
                    rval.add(string);
                }
                break;
            }
            case AUTHORS: {
                Author author = pluggable.getClass().getAnnotation(Author.class);
                if (author == null) break;
                rval.add(author.name());
                break;
            }
            case VERSION: {
                Version version = pluggable.getClass().getAnnotation(Version.class);
                if (version == null) break;
                rval.add(Integer.toString(version.version()));
                break;
            }
            case CLASSPATH_ORIGIN: {
                if (pluggable instanceof Plugin) {
                    PluginRegistry pluginRegistry = pmi.getPluginRegistry();
                    PluggableMetaInformation metaInformation = pluginRegistry.getMetaInformationFor(pluggable);
                    if (metaInformation == null || metaInformation.classMeta == null || metaInformation.classMeta.pluginOrigin == null) break;
                    rval.add(metaInformation.classMeta.pluginOrigin.toString());
                    break;
                }
                this.logger.info("CLASSPATH_ORIGIN cannot be requested for Pluglets at the moment");
                break;
            }
            default: {
                this.logger.info("Requested InformationItem is now known!");
            }
        }
        return rval;
    }

    private String[] getCaps(Pluggable plugin) {
        Method[] methods;
        Class<?> spawnClass = plugin.getClass();
        for (Method method : methods = spawnClass.getMethods()) {
            Capabilities caps = method.getAnnotation(Capabilities.class);
            if (caps == null) continue;
            Object result = null;
            try {
                result = method.invoke((Object)plugin, new Object[0]);
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
            if (result == null || !(result instanceof String[])) continue;
            return (String[])result;
        }
        return new String[0];
    }
}

