/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.xeoh.plugins.base.Plugin;
import net.xeoh.plugins.base.PluginSupervisor;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import net.xeoh.plugins.base.annotations.meta.Author;
import net.xeoh.plugins.base.annotations.meta.Version;
import net.xeoh.plugins.base.supervision.SupervisionListener;

@PluginImplementation
@Version(version=10000)
@Author(name="Ralf Biedert")
public class PluginSupervisorImpl
implements PluginSupervisor {
    private final List<SupervisionListener> generalListener = new ArrayList<SupervisionListener>();
    private final Map<Plugin, List<SupervisionListener>> pluginListener = new HashMap<Plugin, List<SupervisionListener>>();
    private final Lock generalLock = new ReentrantLock();
    private final Lock pluginLock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGeneralSupervisor(SupervisionListener supervisor) {
        this.generalLock.lock();
        try {
            this.generalListener.add(supervisor);
        }
        finally {
            this.generalLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSupervisorFor(Plugin plugin, SupervisionListener supervisor) {
        this.pluginLock.lock();
        try {
            if (!this.pluginListener.containsKey(plugin)) {
                this.pluginListener.put(plugin, new ArrayList());
            }
            this.pluginListener.get(plugin).add(supervisor);
        }
        finally {
            this.pluginLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SupervisionListener> getAllListenerFor(Plugin p) {
        ArrayList<SupervisionListener> rval = new ArrayList<SupervisionListener>();
        this.pluginLock.lock();
        this.generalLock.lock();
        try {
            rval.addAll(this.generalListener);
            if (this.pluginListener.containsKey(p)) {
                rval.addAll((Collection)this.pluginListener.get(p));
            }
        }
        finally {
            this.pluginLock.unlock();
            this.generalLock.unlock();
        }
        return rval;
    }
}

