/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.impl;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TimerTask;
import java.util.logging.Logger;
import net.xeoh.plugins.base.Pluggable;
import net.xeoh.plugins.base.Plugin;
import net.xeoh.plugins.base.Pluglet;
import net.xeoh.plugins.base.annotations.Thread;
import net.xeoh.plugins.base.annotations.Timer;
import net.xeoh.plugins.base.annotations.events.Init;
import net.xeoh.plugins.base.annotations.events.PluginLoaded;
import net.xeoh.plugins.base.annotations.events.Shutdown;
import net.xeoh.plugins.base.annotations.injections.InjectPlugin;
import net.xeoh.plugins.base.impl.PluginManagerImpl;
import net.xeoh.plugins.base.impl.SpawnResult;
import net.xeoh.plugins.base.impl.registry.PluggableClassMetaInformation;
import net.xeoh.plugins.base.impl.registry.PluggableMetaInformation;
import net.xeoh.plugins.base.options.getplugin.OptionCapabilities;

public class Spawner {
    final Logger logger = Logger.getLogger(this.getClass().getName());
    private final PluginManagerImpl pluginManagerImpl;

    public Spawner(PluginManagerImpl pmi) {
        this.pluginManagerImpl = pmi;
    }

    public void destroyPluggable(Plugin plugin, PluggableMetaInformation metaInformation) {
        for (TimerTask timerTask : metaInformation.timerTasks) {
            timerTask.cancel();
        }
        for (java.util.Timer timer : metaInformation.timers) {
            timer.cancel();
        }
        for (java.lang.Thread thread : metaInformation.threads) {
            try {
                thread.interrupt();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.callShutdownMethods(plugin);
    }

    public SpawnResult spawnPlugin(Class c) {
        return this.spawnPluggable(c, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpawnResult spawnPluggable(final Class c, boolean lazySpawn) {
        long startTime = System.nanoTime();
        java.util.Timer timer = new java.util.Timer();
        TimerTask lateMessage = new TimerTask(){

            @Override
            public void run() {
                Spawner.this.logger.warning("Class " + c + " takes very long to spawn. You should fix that.");
            }
        };
        try {
            timer.schedule(lateMessage, 100L);
            Pluggable spawnedPlugin = (Pluggable)c.newInstance();
            SpawnResult.SpawnType type = null;
            if (Pluglet.class.isAssignableFrom(c)) {
                type = SpawnResult.SpawnType.PLUGLET;
            }
            if (Plugin.class.isAssignableFrom(c)) {
                type = SpawnResult.SpawnType.PLUGIN;
            }
            SpawnResult spawnResult = new SpawnResult(spawnedPlugin, type);
            spawnResult.metaInformation.pluginStatus = PluggableMetaInformation.PluginStatus.SPAWNED;
            if (lazySpawn) {
                SpawnResult spawnResult2 = spawnResult;
                return spawnResult2;
            }
            SpawnResult spawnResult3 = this.continueSpawn(spawnResult);
            return spawnResult3;
        }
        catch (Throwable e) {
            this.logger.warning("Unable to load plugin " + c.getName());
            this.logger.warning(e.toString());
            e.printStackTrace();
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                cause.printStackTrace();
            }
        }
        finally {
            timer.cancel();
            long stopTime = System.nanoTime();
            long delta = (stopTime - startTime) / 1000L;
            this.logger.fine("Time to startup plugin " + c + " was " + delta + "\u00b5s");
        }
        return null;
    }

    public SpawnResult continueSpawn(SpawnResult spawnResult) {
        Pluggable spawnedPlugin = spawnResult.pluggable;
        Class<?> c = spawnedPlugin.getClass();
        try {
            this.injectVariables(spawnedPlugin);
            Method[] methods = this.getMethods(c);
            boolean initStatus = this.callInitMethods(spawnedPlugin, methods);
            if (!initStatus) {
                spawnResult.metaInformation.pluginStatus = PluggableMetaInformation.PluginStatus.FAILED;
                return null;
            }
            spawnResult.metaInformation.pluginStatus = PluggableMetaInformation.PluginStatus.INITIALIZED;
            this.spawnThreads(spawnResult, methods);
            this.spawnTimer(spawnResult, methods);
            this.obtainPluginLoadedMethods(spawnResult, methods);
            spawnResult.metaInformation.pluginStatus = PluggableMetaInformation.PluginStatus.ACTIVE;
            return spawnResult;
        }
        catch (Throwable e) {
            this.logger.warning("Unable to load plugin " + c.getName());
            this.logger.warning(e.toString());
            e.printStackTrace();
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                cause.printStackTrace();
            }
            return null;
        }
    }

    private boolean callInitMethods(Pluggable spawnedPlugin, Method[] methods) throws IllegalAccessException {
        Class<?> spawnClass = spawnedPlugin.getClass();
        this.logger.finer("Doing init for " + spawnedPlugin);
        for (Method method : methods) {
            this.logger.finest("Processing method " + method);
            Init annotation = method.getAnnotation(Init.class);
            if (annotation == null) continue;
            this.logger.finer("Annotation found on method " + method);
            try {
                Object invoke = method.invoke((Object)spawnedPlugin, new Object[0]);
                if (invoke == null || !(invoke instanceof Boolean) || ((Boolean)invoke).booleanValue()) continue;
                return false;
            }
            catch (IllegalArgumentException e) {
                this.logger.warning("Error invoking requested @Init on plugin " + spawnClass.getName());
                this.logger.warning(e.toString());
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                this.logger.warning("Error invoking requested @Init on plugin " + spawnClass.getName());
                this.logger.warning(e.toString());
                e.printStackTrace();
            }
            catch (Exception e) {
                this.logger.warning("Error invoking requested @Init on plugin (unknown exception): " + spawnClass.getName());
                this.logger.warning(e.toString());
                e.printStackTrace();
            }
        }
        return true;
    }

    private void callShutdownMethods(Plugin plugin) {
        Class<?> spawnClass = plugin.getClass();
        Method[] methods = spawnClass.getMethods();
        this.logger.finer("Doing shutdown for " + plugin);
        for (Method method : methods) {
            this.logger.finest("Processing method " + method);
            Shutdown annotation = method.getAnnotation(Shutdown.class);
            if (annotation == null) continue;
            this.logger.finer("Annotation found on method " + method);
            try {
                method.invoke((Object)plugin, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                this.logger.warning("Error invoking requested @Shutdown on plugin " + spawnClass.getName());
                this.logger.warning(e.toString());
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                this.logger.warning("Error invoking requested @Shutdown on plugin " + spawnClass.getName());
                this.logger.warning(e.toString());
                e.printStackTrace();
            }
            catch (Exception e) {
                this.logger.warning("Error invoking requested @Shutdown on plugin (unknown exception): " + spawnClass.getName());
                this.logger.warning(e.toString());
                e.printStackTrace();
            }
        }
    }

    private Method[] getMethods(Class<? extends Pluggable> c) {
        Method[] methods = c.getMethods();
        return methods;
    }

    private void injectVariables(Pluggable spawnedPlugin) throws IllegalAccessException {
        String[] capabilities;
        InjectPlugin ipannotation;
        Field[] fields = spawnedPlugin.getClass().getFields();
        Method[] methods = spawnedPlugin.getClass().getMethods();
        for (Field field : fields) {
            ipannotation = field.getAnnotation(InjectPlugin.class);
            if (ipannotation == null) continue;
            capabilities = ipannotation.requiredCapabilities();
            Class<?> typeOfField = field.getType();
            this.logger.fine("Injecting plugin by autodetection (" + typeOfField.getName() + ") into " + spawnedPlugin.getClass().getName());
            field.set(spawnedPlugin, this.pluginManagerImpl.getPlugin(typeOfField, new OptionCapabilities(capabilities)));
        }
        for (AccessibleObject accessibleObject : methods) {
            ipannotation = ((Method)accessibleObject).getAnnotation(InjectPlugin.class);
            if (ipannotation == null) continue;
            capabilities = ipannotation.requiredCapabilities();
            Class<?> typeOfMethod = ((Method)accessibleObject).getParameterTypes()[0];
            this.logger.fine("Injecting plugin by autodetection (" + typeOfMethod.getName() + ") into " + spawnedPlugin.getClass().getName());
            try {
                ((Method)accessibleObject).invoke(spawnedPlugin, this.pluginManagerImpl.getPlugin(typeOfMethod, new OptionCapabilities(capabilities)));
            }
            catch (IllegalArgumentException e) {
                this.logger.warning("Unable to inject plugin " + typeOfMethod + " into method " + accessibleObject);
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                this.logger.warning("Unable to inject plugin " + typeOfMethod + " into method " + accessibleObject);
                e.printStackTrace();
            }
        }
    }

    private void spawnThreads(final SpawnResult spawnResult, Method[] methods) {
        final Class<?> spawnClass = spawnResult.pluggable.getClass();
        for (final Method method : methods) {
            Thread annotation = method.getAnnotation(Thread.class);
            if (annotation == null) continue;
            java.lang.Thread t = new java.lang.Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        method.invoke((Object)spawnResult.pluggable, new Object[0]);
                    }
                    catch (IllegalArgumentException e) {
                        Spawner.this.logger.warning("Error starting requested thread on plugin " + spawnClass.getName());
                        Spawner.this.logger.warning(e.getMessage());
                    }
                    catch (IllegalAccessException e) {
                        Spawner.this.logger.warning("Error invoking requested threada on plugin " + spawnClass.getName());
                        Spawner.this.logger.warning(e.getMessage());
                    }
                    catch (InvocationTargetException e) {
                        Spawner.this.logger.warning("Error invoking requested thread on plugin " + spawnClass.getName());
                        Spawner.this.logger.warning(e.getMessage());
                    }
                }
            });
            t.setDaemon(annotation.isDaemonic());
            t.start();
            spawnResult.metaInformation.threads.add(t);
        }
    }

    private void obtainPluginLoadedMethods(SpawnResult spawnResult, Method[] methods) {
        for (Method method : methods) {
            PluginLoaded annotation = method.getAnnotation(PluginLoaded.class);
            if (annotation == null) continue;
            PluggableMetaInformation.PluginLoadedInformation pli = new PluggableMetaInformation.PluginLoadedInformation();
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 1) {
                this.logger.warning("Wrong number of parameters for PluginLoaded annotations");
                continue;
            }
            pli.method = method;
            pli.baseType = parameterTypes[0];
            spawnResult.metaInformation.pluginLoadedInformation.add(pli);
        }
    }

    private void spawnTimer(final SpawnResult spawnResult, Method[] methods) {
        final Class<?> spawnClass = spawnResult.pluggable.getClass();
        for (final Method method : methods) {
            Timer annotation = method.getAnnotation(Timer.class);
            if (annotation == null) continue;
            final java.util.Timer t = new java.util.Timer();
            TimerTask tt = new TimerTask(){

                @Override
                public void run() {
                    try {
                        Object invoke = method.invoke((Object)spawnResult.pluggable, new Object[0]);
                        if (invoke != null && invoke instanceof Boolean && ((Boolean)invoke).booleanValue()) {
                            t.cancel();
                        }
                    }
                    catch (IllegalArgumentException e) {
                        Spawner.this.logger.warning("Error starting requested timer on plugin " + spawnClass.getName());
                        Spawner.this.logger.warning(e.toString());
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        Spawner.this.logger.warning("Error invoking requested timer method on plugin " + spawnClass.getName());
                        Spawner.this.logger.warning(e.toString());
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        Spawner.this.logger.warning("Error invoking requested timer method on plugin " + spawnClass.getName());
                        Spawner.this.logger.warning(e.toString());
                        e.printStackTrace();
                    }
                }
            };
            if (annotation.timerType() == Timer.TimerType.RATE_BASED) {
                t.scheduleAtFixedRate(tt, annotation.startupDelay(), annotation.period());
            }
            if (annotation.timerType() == Timer.TimerType.DELAY_BASED) {
                t.schedule(tt, annotation.startupDelay(), annotation.period());
            }
            spawnResult.metaInformation.timerTasks.add(tt);
            spawnResult.metaInformation.timers.add(t);
        }
    }

    public Collection<PluggableClassMetaInformation.Dependency> getDependencies(Class<? extends Plugin> pluginClass) {
        Field[] fields;
        ArrayList<PluggableClassMetaInformation.Dependency> rval = new ArrayList<PluggableClassMetaInformation.Dependency>();
        for (Field field : fields = pluginClass.getFields()) {
            InjectPlugin ipannotation = field.getAnnotation(InjectPlugin.class);
            if (ipannotation == null || ipannotation.isOptional()) continue;
            PluggableClassMetaInformation.Dependency d = new PluggableClassMetaInformation.Dependency();
            d.capabilites = ipannotation.requiredCapabilities();
            d.pluginClass = field.getType();
            d.isOptional = ipannotation.isOptional();
            rval.add(d);
        }
        return rval;
    }
}

