/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.impl.classpath;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import net.xeoh.plugins.base.impl.classpath.cache.JARCache;
import net.xeoh.plugins.base.impl.classpath.locator.AbstractClassPathLocation;
import net.xeoh.plugins.base.impl.classpath.locator.JARClasspathLocation;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.classworlds.DuplicateRealmException;
import org.codehaus.classworlds.NoSuchRealmException;

public class ClassPathManager {
    final Logger logger = Logger.getLogger(this.getClass().getName());
    ClassWorld classWorld;
    boolean initializedProperly = false;

    public ClassPathManager() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    ClassPathManager.this.properInit();
                }
                catch (SecurityException e) {
                    ClassPathManager.this.logger.warning("Proper initialization failed due to security restrictions. Only classpath://xxx URIs will work. Sorry.");
                }
                return null;
            }
        });
    }

    void properInit() {
        this.classWorld = new ClassWorld();
        try {
            this.classWorld.newRealm("core", this.getClass().getClassLoader());
        }
        catch (DuplicateRealmException e) {
            e.printStackTrace();
        }
        this.initializedProperly = true;
    }

    public Class<?> loadClass(AbstractClassPathLocation location, String name) throws ClassNotFoundException {
        if (location == null) {
            return this.getClass().getClassLoader().loadClass(name);
        }
        try {
            if (this.initializedProperly) {
                ClassLoader classLoader = this.classWorld.getRealm(location.getRealm()).getClassLoader();
                return classLoader.loadClass(name);
            }
        }
        catch (ClassNotFoundException e) {
            return this.getClass().getClassLoader().loadClass(name);
        }
        catch (NoSuchRealmException e) {
            e.printStackTrace();
        }
        return this.getClass().getClassLoader().loadClass(name);
    }

    public Collection<String> findSubclassesFor(AbstractClassPathLocation location, Class<?> superclass) {
        Collection<String> collection;
        ArrayList<String> rval = new ArrayList<String>();
        if (!this.initializedProperly) {
            return rval;
        }
        JARCache.JARInformation cacheEntry = null;
        if (location instanceof JARClasspathLocation && (cacheEntry = ((JARClasspathLocation)location).getCacheEntry()) != null && (collection = cacheEntry.subclasses.get(superclass.getCanonicalName())) != null) {
            return collection;
        }
        try {
            ClassLoader classLoader = this.classWorld.getRealm(location.getRealm()).getClassLoader();
            Collection<String> listClassNames = location.listToplevelClassNames();
            for (String name : listClassNames) {
                Throwable cause;
                try {
                    Class<?> c = Class.forName(name, false, classLoader);
                    if (c.isInterface() || !superclass.isAssignableFrom(c) || superclass.getCanonicalName().equals(c.getCanonicalName())) continue;
                    rval.add(name);
                }
                catch (ClassNotFoundException e) {
                    this.logger.fine("ClassNotFoundException. Unable to inspect class " + name + " although it appears to be one.");
                    for (cause = e.getCause(); cause != null; cause = cause.getCause()) {
                        this.logger.fine("Reason " + cause.getMessage());
                    }
                }
                catch (NoClassDefFoundError e) {
                    this.logger.finer("Ignored class " + name + " due to unresolved dependencies");
                    for (cause = e.getCause(); cause != null; cause = cause.getCause()) {
                        this.logger.fine("Reason " + cause.getMessage());
                    }
                }
                catch (SecurityException e) {
                    this.logger.warning("SecurityException while trying to find subclasses. Cause of trouble: " + name + ". This does not neccessarily mean problems however.");
                    for (cause = e.getCause(); cause != null; cause = cause.getCause()) {
                        this.logger.fine("Reason " + cause.getMessage());
                    }
                }
            }
        }
        catch (NoSuchRealmException e1) {
            e1.printStackTrace();
        }
        if (cacheEntry != null) {
            cacheEntry.subclasses.put(superclass.getCanonicalName(), rval);
        }
        return rval;
    }

    public void registerLocation(AbstractClassPathLocation location) {
        if (!this.initializedProperly) {
            return;
        }
        try {
            ClassRealm newRealm = this.classWorld.newRealm(location.getRealm(), this.getClass().getClassLoader());
            newRealm.addConstituent(location.getLocation().toURL());
        }
        catch (DuplicateRealmException e) {
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public InputStream getResourceAsStream(AbstractClassPathLocation location, String name) {
        if (location == null) {
            return this.getClass().getClassLoader().getResourceAsStream(name);
        }
        try {
            ClassLoader classLoader = this.classWorld.getRealm(location.getRealm()).getClassLoader();
            return classLoader.getResourceAsStream(name);
        }
        catch (NoSuchRealmException e) {
            e.printStackTrace();
            return null;
        }
    }
}

