/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.impl.classpath.cache;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class JARCache {
    final Logger logger = Logger.getLogger(this.getClass().getName());
    private static final String DEFAULT_CACHE_FILE = "jspf.plugin.cache";
    private boolean cacheEnabled = false;
    private Map<String, JARInformation> cacheMap = new HashMap<String, JARInformation>();
    private boolean weakMode = false;

    public void loadCache(String _cacheFile) {
        if (!this.cacheEnabled) {
            return;
        }
        String cacheFile = _cacheFile == null ? DEFAULT_CACHE_FILE : _cacheFile;
        try {
            FileInputStream fis = new FileInputStream(cacheFile);
            ObjectInputStream ois = new ObjectInputStream(fis);
            Object rval = ois.readObject();
            ois.close();
            if (rval != null) {
                this.cacheMap = (Map)rval;
            }
        }
        catch (EOFException e) {
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            this.logger.warning("Your JSPF cache is outdated, please delete it. It will be regenerated with the next run. The next exception reflects this, so don't be afraid.");
            e.printStackTrace();
        }
    }

    public JARInformation getJARInformationFor(URI uri) {
        String hash;
        if (!this.cacheEnabled) {
            return new JARInformation();
        }
        File file = new File(uri);
        String string = hash = this.weakMode ? this.generateWeakHash(file) : this.generateStrongHash(file);
        if (hash == null) {
            this.logger.warning("Error generating hash. Caching won't work.");
            return new JARInformation();
        }
        if (!this.cacheMap.containsKey(hash)) {
            this.cacheMap.put(hash, new JARInformation());
        }
        JARInformation jarInformation = this.cacheMap.get(hash);
        jarInformation.lastAccess = System.currentTimeMillis();
        ++jarInformation.usageCount;
        return jarInformation;
    }

    public void saveCache(String _cacheFile) {
        if (!this.cacheEnabled) {
            return;
        }
        String cacheFile = _cacheFile;
        if (cacheFile == null) {
            cacheFile = DEFAULT_CACHE_FILE;
        }
        try {
            FileOutputStream fos = new FileOutputStream(cacheFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.cacheMap);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String generateWeakHash(File file) {
        String name = file.getName();
        long length = file.length();
        String hash = "weak:" + name + "@" + length;
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateStrongHash(File element) {
        boolean created = false;
        try {
            this.logger.fine("Processing JAR " + element);
            MessageDigest digest = MessageDigest.getInstance("MD5");
            FileInputStream fis = new FileInputStream(element);
            byte[] data = new byte[0x100000];
            int avail = fis.available();
            while (avail > 0) {
                avail = Math.min(avail, data.length);
                fis.read(data, 0, avail);
                digest.update(data, 0, avail);
                avail = fis.available();
            }
            byte[] hash = digest.digest();
            StringBuilder sb = new StringBuilder();
            sb.append("md5:");
            for (byte b : hash) {
                String format = String.format("%02x", b);
                sb.append(format);
            }
            fis.close();
            String hashValue = sb.toString().substring(0, sb.toString().length());
            created = true;
            this.logger.fine("Hash of " + element + " is " + hashValue);
            String string = hashValue;
            return string;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (!created) {
                this.logger.warning("Error creating hash of " + element);
            }
        }
        return null;
    }

    public void setEnabled(boolean u) {
        this.cacheEnabled = u;
    }

    public void setWeakMode(boolean w) {
        if (w) {
            this.logger.fine("Weak mode for caching was enabled.");
        }
        this.weakMode = w;
    }

    public static class JARInformation
    implements Serializable {
        private static final long serialVersionUID = 6734024814836912079L;
        public List<String> classes = new ArrayList<String>();
        public Map<String, Collection<String>> subclasses = new HashMap<String, Collection<String>>();
        public long lastAccess = System.currentTimeMillis();
        public int usageCount = 0;
        public boolean classesValid = false;
    }
}

