/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.impl.loader;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Collection;
import net.xeoh.plugins.base.Plugin;
import net.xeoh.plugins.base.impl.PluginManagerImpl;
import net.xeoh.plugins.base.impl.classpath.ClassPathManager;
import net.xeoh.plugins.base.impl.classpath.locator.AbstractClassPathLocation;
import net.xeoh.plugins.base.impl.classpath.locator.ClassPathLocator;
import net.xeoh.plugins.base.impl.classpath.locator.JARClasspathLocation;
import net.xeoh.plugins.base.impl.loader.AbstractLoader;

public class FileLoader
extends AbstractLoader {
    public FileLoader(PluginManagerImpl pluginManager) {
        super(pluginManager);
    }

    @Override
    public boolean handlesURI(URI uri) {
        return uri.getScheme().equals("file");
    }

    @Override
    public void loadFrom(URI url) {
        if (url.getScheme().equals("file")) {
            String file = url.getPath();
            if (file.startsWith("/") && file.substring(0, 4).contains(":")) {
                file = file.substring(1);
            }
            try {
                file = URLDecoder.decode(file, "utf8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            this.logger.fine("More specifically, trying to add from " + file);
            File root = new File(file);
            if (!root.exists()) {
                this.logger.warning("Supplied path does not exist. Unable to add plugins from there.");
                return;
            }
            this.locateAllPluginsAt(root);
            return;
        }
    }

    void locateAllPluginsAt(File root) {
        ClassPathManager manager = this.pluginManager.getClassPathManager();
        ClassPathLocator locator = this.pluginManager.getClassPathLocator();
        Collection<AbstractClassPathLocation> locations = locator.findBelow(root.toURI());
        for (AbstractClassPathLocation location : locations) {
            manager.registerLocation(location);
            Collection<String> subclasses = null;
            if (location instanceof JARClasspathLocation) {
                JARClasspathLocation jarLocation = (JARClasspathLocation)location;
                subclasses = jarLocation.getPredefinedPluginList();
            }
            if (subclasses == null) {
                subclasses = manager.findSubclassesFor(location, Plugin.class);
            }
            for (String string : subclasses) {
                this.tryToLoadClassAsPlugin(location, string);
            }
        }
    }
}

