/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.bus.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import net.xeoh.plugins.base.annotations.events.Init;
import net.xeoh.plugins.base.annotations.meta.Author;
import net.xeoh.plugins.bus.Bus;
import net.xeoh.plugins.bus.Channel;
import net.xeoh.plugins.bus.ChannelListener;
import net.xeoh.plugins.bus.messages.BusMessage;

@Author(name="Ralf Biedert")
@PluginImplementation
public class BusImpl
implements Bus {
    HashMap<Class<? extends Channel>, List<ChannelListener<?>>> knownListeners;
    Lock knownListenersLock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <B extends BusMessage, C extends Channel<B>> void addChannelListener(Class<C> channel, ChannelListener<B> listener) {
        if (channel == null || listener == null) {
            return;
        }
        assert (this.knownListeners != null) : "Lister must have been initialized!";
        this.knownListenersLock.lock();
        try {
            List<ChannelListener<?>> list = this.knownListeners.get(channel);
            if (list == null) {
                list = new ArrayList();
                this.knownListeners.put(channel, list);
            }
            list.add(listener);
        }
        finally {
            this.knownListenersLock.unlock();
        }
    }

    @Init
    public void init() {
        this.knownListeners = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <B extends BusMessage, D extends B, C extends Channel<B>> void sendOnChannel(Class<C> channel, D message) {
        if (channel == null || message == null) {
            return;
        }
        this.knownListenersLock.lock();
        try {
            List<ChannelListener<?>> _list = this.knownListeners.get(channel);
            if (_list == null) {
                return;
            }
            ArrayList list = new ArrayList(_list);
            for (ChannelListener channelListener : list) {
                try {
                    channelListener.incomingMessage(message);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            this.knownListenersLock.unlock();
        }
    }
}

