/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.informationbroker.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import net.xeoh.plugins.base.annotations.meta.Author;
import net.xeoh.plugins.informationbroker.InformationBroker;
import net.xeoh.plugins.informationbroker.InformationItem;
import net.xeoh.plugins.informationbroker.InformationItemIdentifier;
import net.xeoh.plugins.informationbroker.InformationListener;
import net.xeoh.plugins.informationbroker.SubscriptionMode;

@Author(name="Ralf Biedert")
@PluginImplementation
public class InformationBrokerImpl
implements InformationBroker {
    final Map<URI, InformationItem> items = new HashMap<URI, InformationItem>();
    final Lock itemsLock = new ReentrantLock();
    final Collection<Subscription> subscriptions = new ArrayList<Subscription>();
    final Lock subscriptionsLock = new ReentrantLock();
    final Logger logger = Logger.getLogger(this.getClass().getName());

    static final void callListener(InformationBroker broker, Subscription subscription) {
        ArrayList cmd = new ArrayList();
        for (InformationItemIdentifier item : subscription.allToWaitFor) {
            cmd.add(item);
        }
        subscription.l.informationUpdate(broker, cmd);
    }

    @Override
    public final <Type, I extends InformationItem<Type>> I getInformationItem(InformationItemIdentifier<Type, I> item) {
        return (I)((InformationItem)this._getInformationItem(item));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(InformationItem<?> ... newItems) {
        for (InformationItem<?> item : newItems) {
            this.logger.fine("Publishing item " + item.getIdentifier().getID());
            this.itemsLock.lock();
            try {
                this.items.put(item.getIdentifier().getID(), item);
            }
            finally {
                this.itemsLock.unlock();
            }
        }
        for (InformationItem<?> item : newItems) {
            this.checkSubscriptions(item.getIdentifier().getID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(InformationListener l, SubscriptionMode mode, InformationItemIdentifier<?, ?> ... toWaitFor) {
        this.subscriptionsLock.lock();
        try {
            this.subscriptions.add(new Subscription(l, mode, toWaitFor));
        }
        finally {
            this.subscriptionsLock.unlock();
        }
        this.checkSubscriptions(null);
    }

    private void checkSubscriptions(final URI justChanged) {
        final ExecutorService es = Executors.newCachedThreadPool();
        es.execute(new Runnable(){

            @Override
            public void run() {
                InformationBrokerImpl.this.subscriptionsLock.lock();
                ArrayList<Subscription> copy = new ArrayList<Subscription>(InformationBrokerImpl.this.subscriptions);
                InformationBrokerImpl.this.subscriptionsLock.unlock();
                for (Subscription subscription : copy) {
                    InformationItemIdentifier[] allToWaitFor = subscription.allToWaitFor;
                    boolean callSubscriptionListener = false;
                    switch (subscription.mode) {
                        case ALL_SET: {
                            boolean allFound = true;
                            for (InformationItemIdentifier informationItemIdentifier : allToWaitFor) {
                                Object informationItem = InformationBrokerImpl.this._getInformationItem(informationItemIdentifier);
                                if (informationItem != null) continue;
                                allFound = false;
                            }
                            callSubscriptionListener = allFound;
                            break;
                        }
                        case SOME_CHANGED: {
                            if (justChanged == null) break;
                            for (InformationItemIdentifier informationItemIdentifier : allToWaitFor) {
                                if (!informationItemIdentifier.getID().equals(justChanged)) continue;
                                callSubscriptionListener = true;
                            }
                            break;
                        }
                    }
                    if (!callSubscriptionListener) continue;
                    InformationBrokerImpl.callListener(InformationBrokerImpl.this, subscription);
                }
                es.shutdown();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Object _getInformationItem(InformationItemIdentifier item) {
        this.logger.fine("Requested information item " + item.getID());
        this.itemsLock.lock();
        try {
            InformationItem o;
            InformationItem informationItem = o = this.items.get(item.getID());
            return informationItem;
        }
        finally {
            this.itemsLock.unlock();
        }
    }

    private static class Subscription {
        public InformationItemIdentifier[] allToWaitFor;
        public InformationListener l;
        public SubscriptionMode mode;

        public Subscription(InformationListener l, SubscriptionMode mode, InformationItemIdentifier ... allToWaitFor) {
            this.l = l;
            this.mode = mode;
            this.allToWaitFor = allToWaitFor;
        }
    }
}

