/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.informationbroker.util;

import java.util.Collection;
import net.xeoh.plugins.informationbroker.InformationBroker;
import net.xeoh.plugins.informationbroker.InformationItem;
import net.xeoh.plugins.informationbroker.InformationItemIdentifier;
import net.xeoh.plugins.informationbroker.InformationListener;
import net.xeoh.plugins.informationbroker.SubscriptionMode;
import net.xeoh.plugins.informationbroker.util.ValueListener;

public class InformationBrokerUtil {
    private final InformationBroker broker;

    public InformationBrokerUtil(InformationBroker broker) {
        this.broker = broker;
    }

    public <Type, I extends InformationItem<Type>> Type getItem(InformationItemIdentifier<Type, I> item, Type ... dflt) {
        I informationItem = this.broker.getInformationItem(item);
        if (informationItem != null) {
            return informationItem.getContent();
        }
        if (dflt.length > 0) {
            return dflt[0];
        }
        return null;
    }

    public <Type, I extends InformationItem<Type>> void onValue(final InformationItemIdentifier<Type, I> item, final ValueListener<Type> valueListener) {
        this.broker.subscribe(new InformationListener(){

            @Override
            public void informationUpdate(InformationBroker brker, Collection<InformationItemIdentifier<?, InformationItem<?>>> ids) {
                valueListener.newValue(brker.getInformationItem(item).getContent());
            }
        }, SubscriptionMode.ALL_SET, item);
    }
}

