/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.LoggerModule;

import com.n2bb.LoggerModule.ISALogListener;
import com.n2bb.LoggerModule.LogSettingsClient;
import com.n2bb.LoggerModule.LoggerWriter;
import com.n2bb.LoggerModule.MSALogListener;
import java.io.File;
import java.util.Date;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.xml.DOMConfigurator;

public class LocalLogger {
    static final String CONFIG_FILE = System.getProperty("CONFIG_FILE", "/usr/local/n2bb/logger/conf/LocalLogger.xml");
    private static Logger logger;
    private LogSettingsClient settingsClient;
    private Thread watchLogLevels;

    public LocalLogger(int rcvBufferSize, String nameService) throws Exception {
        this.settingsClient = new LogSettingsClient(nameService);
        int listenPort = this.settingsClient.getIsaLogListenPort();
        int msaListenPort = this.settingsClient.getMSALogListenPort();
        int checkSecs = this.settingsClient.getCheckSecs();
        LogLog.setInternalDebugging((boolean)true);
        this.updateLogLevels();
        DOMConfigurator.configureAndWatch((String)CONFIG_FILE, (long)30000L);
        LoggerWriter.getInstance().initLogger();
        logger = Logger.getLogger(LocalLogger.class);
        ISALogListener isa = new ISALogListener(listenPort, rcvBufferSize);
        MSALogListener msa = new MSALogListener(msaListenPort, rcvBufferSize);
        this.watchLogLevels = new WatchLogLevels(checkSecs);
        this.watchLogLevels.start();
    }

    static void log(String msg) throws Exception {
        if (logger == null) {
            LogLog.debug((String)msg);
        } else {
            logger.info((Object)msg);
        }
    }

    static void logError(String msg, Throwable t) {
        if (logger == null) {
            LogLog.error((String)msg, (Throwable)t);
        } else {
            logger.error((Object)msg, t);
        }
    }

    private void updateLogLevels() throws Exception {
        try {
            String serverLevels = this.settingsClient.getLogSettings();
            LocalLogger.log("Got server log levels.");
            LoggerWriter.getInstance().writeCategories(serverLevels);
            LocalLogger.log("Updating last modified time on " + CONFIG_FILE + " so log4j reloads settings");
            new File(CONFIG_FILE).setLastModified(new Date().getTime());
        }
        catch (Exception e) {
            LocalLogger.logError(e.getMessage(), e);
            throw e;
        }
    }

    public static void usage() throws Exception {
        System.out.println("Usage:  LocalLogger rcvBufferSize nameServiceCorbaloc");
    }

    public static void main(String[] args) throws Exception {
        String nameService;
        int rcvBufferSize;
        if (args.length < 2) {
            LocalLogger.usage();
            return;
        }
        try {
            rcvBufferSize = Integer.parseInt(args[0]);
            nameService = args[1];
        }
        catch (Exception e) {
            LocalLogger.usage();
            throw e;
        }
        new LocalLogger(rcvBufferSize, nameService);
    }

    private class WatchLogLevels
    extends Thread {
        private int checkSecs;

        public WatchLogLevels(int checkSecs) {
            this.checkSecs = checkSecs;
        }

        public void run() {
            logger.info((Object)"WatchLogLevels thread running");
            while (true) {
                try {
                    while (true) {
                        WatchLogLevels.sleep(this.checkSecs * 1000);
                        LocalLogger.this.updateLogLevels();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

