
package com.smartgwt.client.docs;

/**
 * Data being displayed by a grid may be edited within the grid, by showing editing&#010 interfaces embedded inside the cells of the grid.&#010 <P>&#010 <b>Enabling editing</b>&#010 <P>&#010 Editing is enabled when {@link com.smartgwt.client.widgets.grid.ListGrid#getCanEdit canEdit} is <code>true</code>.  When enabled,&#010 the user can begin editing via the &#010 {@link com.smartgwt.client.widgets.grid.ListGrid#getEditEvent editEvent}, typically click or double-click.  Editing can also be triggered&#010 programmatically by a call to {@link com.smartgwt.client.widgets.grid.ListGrid#startEditing} or&#010 {@link com.smartgwt.client.widgets.grid.ListGrid#startEditingNew}.&#010 <P>&#010 <b>New record creation</b>&#010 <P>&#010 By default, editing is restricted to existing records.  Setting {@link com.smartgwt.client.widgets.grid.ListGrid#getListEndEditAction listEndEditAction} to&#010 "next" allows the user to create new records by simply navigating off the end of the dataset&#010 with the keyboard.  Editing of new records can also be initiated with &#010 {@link com.smartgwt.client.widgets.grid.ListGrid#startEditingNew}, for example, from a button outside the grid.&#010 <P>&#010 <b>Saving changes</b>&#010 <P>&#010 Saving of changes is triggered automatically when the user navigates out of the row or cell&#010 being edited (based on {@link com.smartgwt.client.widgets.grid.ListGrid#getSaveByCell saveByCell}) or when the user ends editing.   For&#010 a "mass update" interface, automatic saving of changes can be disabled entirely via &#010 {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoSaveEdits autoSaveEdits}, in which case a manual call to &#010 {@link com.smartgwt.client.widgets.grid.ListGrid#saveEdits} or {@link com.smartgwt.client.widgets.grid.ListGrid#saveAllEdits} is required&#010 to trigger saving. &#010 <P>&#010 If a grid has no DataSource, saving means that the properties of the {@link com.smartgwt.client.widgets.grid.ListGridRecord}s&#010 in {@link com.smartgwt.client.widgets.grid.ListGrid#getData data} are directly changed.&#010 <P>&#010 For a grid with a DataSource, saving will be accomplished by using DataSource "update"&#010 operations for existing records, and DataSource "add" operations for new records.  If multiple&#010 records have been edited and {@link com.smartgwt.client.widgets.grid.ListGrid#saveAllEdits} is called, &#010 {@link com.smartgwt.client.rpc.RPCManager#startQueue} will be automatically used to enable all&#010 edits to be saved in one HTTP turnaround (if using the SmartGWT Server).&#010 <P>&#010 By default, a grid will send only updated fields and the primaryKey field as part of &#010 {@link com.smartgwt.client.data.DSRequest#getData data} so that the server can discern which fields the user actually changed.&#010 However, the grid always includes the original field values in the&#010 dsRequest as {@link com.smartgwt.client.data.DSRequest#getOldValues oldValues}.&#010 <P>&#010 Note that although it is possible to load DataSource data without actually declaring a&#010 {@link com.smartgwt.client.data.DataSourceField#getPrimaryKey primaryKey}, a primaryKey must be declared for&#010 editing and saving.  The primaryKey value is how SmartGWT identifies the changed&#010 record to the server.&#010 <P>&#010 <b>Validation</b>&#010 <P>&#010 Any time saving is attempted, validation is automatically triggered.  Values entered by the&#010 user will be checked against the {@link com.smartgwt.client.widgets.grid.ListGridField#getValidators validators} and the&#010 {@link com.smartgwt.client.data.DataSourceField#getValidators validators}. Any invalid values abort an attempted save.&#010 <P>&#010 Similar to editing and saving, validation can be done on row transitions or on cell&#010 transitions by setting {@link com.smartgwt.client.widgets.grid.ListGrid#getValidateByCell validateByCell}, or can be disabled entirely&#010 via {@link com.smartgwt.client.widgets.grid.ListGrid#getNeverValidate neverValidate}.&#010 <P>&#010 <b>Editability of cells</b>&#010 <P>&#010 Editors will either be shown for the complete row or for a single cell based on &#010 {@link com.smartgwt.client.widgets.grid.ListGrid}.  Whether a cell can be edited can be controlled on a&#010 per field basis by setting {@link com.smartgwt.client.widgets.grid.ListGridField#getCanEdit canEdit}, or on a per-record basis&#010 by setting {@link com.smartgwt.client.widgets.grid.ListGrid#getRecordEditProperty recordEditProperty} on a &#010 ${isc.DocUtils.linkForRef('object:ListGridRecord','record')}, or can be controlled on an arbitrary, programmatic basis via&#010 an override of {@link com.smartgwt.client.widgets.grid.ListGrid#canEditCell}.&#010 <P>&#010 Cells which are not editable just display the cell's current value.&#010 <P>&#010 <b>Keyboard Navigation</b>&#010 <P>&#010 Full keyboard navigation is supported by default, including Tab and Shift-Tab to navigate&#010 between cells in a row, and Up Arrow and Down Arrow to traverse rows.  Several properties&#010 on both grids and fields, all named *EditAction, control navigation behavior of certain keys&#010 (eg Enter).&#010 <P>&#010 You can use {@link com.smartgwt.client.widgets.grid.ListGrid#startEditing} to &#010 programmatically move editing to a particular cell, for example, during a &#010 {@link com.smartgwt.client.widgets.grid.ListGridField#addChangedHandler} event.&#010 <P>&#010 <b>editValues (unsaved changes)</b>&#010 <P>&#010 The term "editValues" means changes that the user has made to the dataset which have not&#010 been saved.  The grid manages and stores editValues separately from the data itself in order&#010 to allow the user to revert to original values, and in order to enable to grid to send only&#010 updated fields to the server.  &#010 <P>&#010 Because editValues are stored separately, if you directly access the dataset (eg via &#010 <code>grid.data.get()</code>) you will see the records without the user's unsaved changes.&#010 Many APIs exist for retrieving and managing editValues (search for editValue).&#010 For the common case of needing to access the record-as-edited, you can call &#010 {@link com.smartgwt.client.widgets.grid.ListGrid#getEditedRecord}.&#010 <P>&#010 When accessing and manipulating edited data, you should think carefully about whether&#010 you want to be working with the original data or with the edited version.  Values entered&#010 by the user may not have been validated yet, or may have failed validation, hence you may&#010 find a String value in a field of type "date" or "int", which could cause naive formatters or&#010 totalling functions to crash.&#010 <P>&#010 Setting editValues is fully equivalent to the user making changes to data via the editing UI.&#010 If you <i>also</i> allow editing external to the grid, setting editValues is one way to &#010 combine changes from external editors into the grid's edits, so that you can do a single &#010 save.&#010 <P>&#010 <b>Customizing Cell Editors</b>&#010 <P>&#010 When a cell is being edited, the editor displayed in the cell will be a {@link com.smartgwt.client.widgets.form.fields.FormItem}.&#010 The editor type for the cell will be determined by {@link com.smartgwt.client.widgets.grid.ListGrid#getEditorType} based on the&#010 specified {@link com.smartgwt.client.widgets.grid.ListGridField#getEditorType editorType} or {@link com.smartgwt.client.widgets.grid.ListGridField#getType type} for the field in&#010 question.&#010 <P>&#010 You can customize the editor by setting {@link com.smartgwt.client.widgets.grid.ListGridField#getEditorProperties editorProperties} to a set of&#010 properties that is valid for that FormItem type.  Custom FormItem classes are also allowed,&#010 for example, you may use {@link com.smartgwt.client.widgets.form.fields.FormItem#getIcons icons} to create an icon that launches a separate&#010 {@link com.smartgwt.client.widgets.Dialog} in order to provide an arbitrary interface that allows the user to select the&#010 value for a field.&#010 <P>&#010 <b>Events</b>&#010 <P>&#010 Editing triggers several events which you can provide handlers for in order to customize&#010 editing behavior.  Some of the most popular are {@link com.smartgwt.client.widgets.grid.ListGridField#addChangeHandler},&#010 {@link com.smartgwt.client.widgets.grid.ListGridField#addChangedHandler} for detecting changes made by the user,&#010 {@link com.smartgwt.client.widgets.grid.ListGrid#addCellChangedHandler} for detecting changes that have been successfully saved,&#010 and {@link com.smartgwt.client.widgets.grid.ListGrid#addEditorEnterHandler} and {@link com.smartgwt.client.widgets.grid.ListGrid#addEditorExitHandler} for detecting user&#010 navigation during editing.&#010 <P>&#010 You can also install event handlers directly on the FormItem-based editors used in the grid&#010 via {@link com.smartgwt.client.widgets.grid.ListGridField#getEditorProperties editorProperties} as mentioned above.  When handling&#010 events on items, or which involve items, be aware that in addition to standard &#010 {@link com.smartgwt.client.widgets.form.fields.FormItem} APIs, editors have the following properties:&#010 <P>&#010 - <code>rowNum</code>: The rowNum of the record being edited.<br>&#010 - <code>colNum</code>: The colNum of the cell being edited.<br>&#010 - <code>grid</code>: A pointer back to the listGrid containing the record.
 * @see com.smartgwt.client.widgets.form.DynamicForm#getEditorType
 * @see com.smartgwt.client..CubeGrid#setEditValue
 * @see com.smartgwt.client..CubeGrid#getEditValue
 * @see com.smartgwt.client..CubeGrid#getEditedRecord
 * @see com.smartgwt.client..CubeGrid#getEditedCell
 * @see com.smartgwt.client..CubeGrid#getEditValues
 * @see com.smartgwt.client..CubeGrid#clearEditValue
 * @see com.smartgwt.client..CubeGrid#saveEdits
 * @see com.smartgwt.client..CubeGrid#getAllEditCells
 * @see com.smartgwt.client..CubeGrid#discardAllEdits
 * @see com.smartgwt.client..CubeGrid#recordHasChanges
 * @see com.smartgwt.client..CubeGrid#hasChanges
 * @see com.smartgwt.client..CubeGrid#saveAllEdits
 * @see com.smartgwt.client.widgets.grid.ListGridField#defaultDynamicValue
 * @see com.smartgwt.client.widgets.grid.ListGridField#editorEnter
 * @see com.smartgwt.client.widgets.grid.ListGridField#editorExit
 * @see com.smartgwt.client.widgets.grid.ListGridField#cellChanged
 * @see com.smartgwt.client.widgets.grid.ListGridField#formatEditorValue
 * @see com.smartgwt.client.widgets.grid.ListGridField#parseEditorValue
 * @see com.smartgwt.client.widgets.grid.ListGridField#change
 * @see com.smartgwt.client.widgets.grid.ListGridField#changed
 * @see com.smartgwt.client.widgets.grid.ListGrid#canEditCell
 * @see com.smartgwt.client.widgets.grid.ListGrid#startEditing
 * @see com.smartgwt.client.widgets.grid.ListGrid#getEditorValueMap
 * @see com.smartgwt.client.widgets.grid.ListGrid#setEditorValueMap
 * @see com.smartgwt.client.widgets.grid.ListGrid#getEditorType
 * @see com.smartgwt.client.widgets.grid.ListGrid#startEditingNew
 * @see com.smartgwt.client.widgets.grid.ListGrid#getAllEditRows
 * @see com.smartgwt.client.widgets.grid.ListGrid#getEditValues
 * @see com.smartgwt.client.widgets.grid.ListGrid#getEditedRecord
 * @see com.smartgwt.client.widgets.grid.ListGrid#getEditedCell
 * @see com.smartgwt.client.widgets.grid.ListGrid#setEditValue
 * @see com.smartgwt.client.widgets.grid.ListGrid#getEditValue
 * @see com.smartgwt.client.widgets.grid.ListGrid#clearEditValue
 * @see com.smartgwt.client.widgets.grid.ListGrid#getEditRow
 * @see com.smartgwt.client.widgets.grid.ListGrid#getEditCol
 * @see com.smartgwt.client.widgets.grid.ListGrid#getEditField
 * @see com.smartgwt.client.widgets.grid.ListGrid#cancelEditing
 * @see com.smartgwt.client.widgets.grid.ListGrid#endEditing
 * @see com.smartgwt.client.widgets.grid.ListGrid#discardAllEdits
 * @see com.smartgwt.client.widgets.grid.ListGrid#discardEdits
 * @see com.smartgwt.client.widgets.grid.ListGrid#saveEdits
 * @see com.smartgwt.client.widgets.grid.ListGrid#rowHasChanges
 * @see com.smartgwt.client.widgets.grid.ListGrid#hasChanges
 * @see com.smartgwt.client.widgets.grid.ListGrid#cellHasChanges
 * @see com.smartgwt.client.widgets.grid.ListGrid#saveAllEdits
 * @see com.smartgwt.client.widgets.grid.ListGrid#cellChanged
 * @see com.smartgwt.client.widgets.grid.ListGrid#editComplete
 * @see com.smartgwt.client.widgets.grid.ListGrid#editFailed
 * @see com.smartgwt.client.widgets.grid.ListGrid#editorEnter
 * @see com.smartgwt.client.widgets.grid.ListGrid#rowEditorEnter
 * @see com.smartgwt.client.widgets.grid.ListGrid#editorExit
 * @see com.smartgwt.client.widgets.grid.ListGrid#rowEditorExit
 * @see com.smartgwt.client.widgets.grid.ListGrid#formatEditorValue
 * @see com.smartgwt.client.widgets.grid.ListGrid#parseEditorValue
 * @see com.smartgwt.client.widgets.grid.ListGridField#getEditorImageURLPrefix
 * @see com.smartgwt.client.widgets.grid.ListGridField#getEditorImageURLSuffix
 * @see com.smartgwt.client.widgets.grid.ListGridField#getIcons
 * @see com.smartgwt.client.widgets.grid.ListGridField#getEditorIconWidth
 * @see com.smartgwt.client.widgets.grid.ListGridField#getEditorIconHeight
 * @see com.smartgwt.client.widgets.grid.ListGridField#getDefaultIconSrc
 * @see com.smartgwt.client.widgets.grid.ListGridField#getIconVAlign
 * @see com.smartgwt.client.widgets.grid.ListGridField#getCanEdit
 * @see com.smartgwt.client.widgets.grid.ListGridField#getDefaultValue
 * @see com.smartgwt.client.widgets.grid.ListGridField#getEnterKeyEditAction
 * @see com.smartgwt.client.widgets.grid.ListGridField#getEscapeKeyEditAction
 * @see com.smartgwt.client.widgets.grid.ListGridField#getEditorType
 * @see com.smartgwt.client.widgets.grid.ListGridField#getEditorProperties
 * @see com.smartgwt.client.widgets.grid.ListGrid#getModalEditing
 * @see com.smartgwt.client.widgets.grid.ListGridField#getEditorValueMap
 * @see com.smartgwt.client.widgets.grid.ListGrid#getCanEdit
 * @see com.smartgwt.client.widgets.grid.ListGrid#getRecordEditProperty
 * @see com.smartgwt.client.widgets.grid.ListGrid#getEditByCell
 * @see com.smartgwt.client.widgets.grid.ListGrid#getSaveByCell
 * @see com.smartgwt.client.widgets.grid.ListGrid#getWaitForSave
 * @see com.smartgwt.client.widgets.grid.ListGrid#getStopOnErrors
 * @see com.smartgwt.client.widgets.grid.ListGrid#getAutoSaveEdits
 * @see com.smartgwt.client.widgets.grid.ListGrid#getConfirmCancelEditing
 * @see com.smartgwt.client.widgets.grid.ListGrid#getCancelEditingConfirmationMessage
 * @see com.smartgwt.client.widgets.grid.ListGrid#getConfirmDiscardEdits
 * @see com.smartgwt.client.widgets.grid.ListGrid#getConfirmDiscardEditsMessage
 * @see com.smartgwt.client.widgets.grid.ListGrid#getDiscardEditsSaveButtonTitle
 * @see com.smartgwt.client.widgets.grid.ListGrid#getRowEndEditAction
 * @see com.smartgwt.client.widgets.grid.ListGrid#getListEndEditAction
 * @see com.smartgwt.client.widgets.grid.ListGrid#getEnterKeyEditAction
 * @see com.smartgwt.client.widgets.grid.ListGrid#getEscapeKeyEditAction
 * @see com.smartgwt.client.widgets.grid.ListGrid#getEditEvent
 * @see com.smartgwt.client.widgets.grid.ListGrid#getEditOnFocus
 * @see com.smartgwt.client.widgets.grid.ListGrid#getSelectOnEdit
 * @see com.smartgwt.client.widgets.grid.ListGridField#getCanToggle
 * @see com.smartgwt.client.widgets.grid.ListGrid#getLongTextEditorThreshold
 * @see com.smartgwt.client.widgets.grid.ListGrid#getLongTextEditorType
 * @see com.smartgwt.client.widgets.calendar.Calendar#getEventSnapGap
 * @see com.smartgwt.client.widgets.calendar.Calendar#getShowQuickEventDialog
 * @see com.smartgwt.client.widgets.calendar.Calendar#getEventEditorFields
 * @see com.smartgwt.client.widgets.calendar.Calendar#getEventDialogFields
 * @see com.smartgwt.client.types.RowEndEditAction
 * @see com.smartgwt.client.types.EnterKeyEditAction
 * @see com.smartgwt.client.types.EscapeKeyEditAction
 * @see com.smartgwt.client.types.EditCompletionEvent
 * @see com.smartgwt.client.types.ListGridEditEvent
 */
public interface Editing {
}
