
package com.smartgwt.client.docs;

/**
 * This section describes various methods for optimizing delivery of your SmartGWT-based&#010 application to the browser.  The various techniques discussed here should enable you to&#010 drastically reduce the time to load your SmartGWT based application and to cut down on&#010 bandwidth costs and server-side CPU usage.&#010&#010 There are three main ways of improving the performance of your application:&#010 <p>&#010 <u><b>Compression</b></u>&#010 <p>&#010 You'll want to deliver as much of your application assets compressed as possible.  For a start, the&#010 SmartGWT modules come pre-compressed.  The {@link com.smartgwt.client.docs.Compression} section describes how&#010 to make sure that SmartGWT modules and your application logic are delivered compressed&#010 and how to enable dynamic compression of your dynamic content.&#010 <p>&#010 Compression drastically reduces transfer times to the browser.  Compression ratios for css&#010 and javascript files can be as high as 8:1.&#010&#010 <p>&#010 <u><b>Caching</b></u>&#010 <p>&#010 The {@link com.smartgwt.client.docs.Caching} section deals with delivering as much content as possible with&#010 caching headers.  Setting these headers allows the end-user's browser and any intermediary&#010 proxies to keep a local copy of the file across browser reloads, ensuring the subsequent&#010 visits require almost no fetches from the server.  Eliminating these fetches is also&#010 important for the reasons explained under File Assembly below.&#010 &#010 <p>&#010 <u><b>File Assembly</b></u>&#010 <p>&#010 Modern browsers limit the number of HTTP connections they use to fetch the assets required&#010 to render your pages - typically to just 2 connections.  As a result, connection latency can&#010 play a much higher role than available bandwidth and the two connection limit effectively&#010 drastically limits the user's usable bandwidth.  For this reason, it's important to minimize&#010 the number of HTTP requests made to the server.  The File Assembly services make it easy to&#010 deliver multiple css and javascript file via one HTTP response.  Assembling files together&#010 also helps to increase the compression ratio because the commpression engine has more&#010 redundant data to work with.&#010&#010 <p>&#010 <u><b>FileLoader</b></u>&#010 <p>&#010 The FileLoader is a standalone client-side module that allows you to performing caching or&#010 loading of various resources in the background on any page.  The typical usage pattern is to&#010 use this module to pre-cache SmartGWT modules, skin images, and application logic while&#010 the user is, for example filling in a login form.  See the {@link com.smartgwt.client..FileLoader} documentation&#010 on usage.&#010&#010 <p>&#010 <u><b>SSL Considerations</b></u>&#010 <p>&#010 Some quirks to be aware of when optimizing for pages servied via HTTPS:&#010 <ul>&#010 <li>If your top-level https page loads an image via http, IE will pop a warning to the user&#010 asking if it's ok to serve the "unsecure" content.  Firefox does not pop an alert, bug shows&#010 a different lock icon to indicate that not all content is served from a secure server.&#010 <li>Firefox will not write images fetched via SSL to disk, even if expires headers are set.&#010 But it will cache them in memory for the duration of the browser session.  This makes the&#010 use of the {@link com.smartgwt.client..FileLoader} even more important for SSL applications.  IE will cache SSL&#010 content across browser restarts.&#010 <li>If your only concern is with actual security and not with perception, it makes a lot of&#010 sense to serve the top-level page via plain HTTP and then use the SmartGWT RPC mechanism&#010 to fetch sensitive data with no-cache headers via HTTPS.  Unfortunately this almost never&#010 practical because most users look for the secure lock icon on the top-level page and may&#010 become worried that the application is not secure if they don't see it.&#010 </ul>&#010&#010 <p>&#010 <u><b>Other Tips</b></u>&#010 <p>&#010 1.  Modern applications often use a number of cookies to keep track of session state,&#010 application state, etc.  If you don't limit the paths these cookies are served for, you can&#010 easily end up with these cookies being sent to the server with every HTTP request as&#010 part of the HTTP headers.  This can severely limit bandwidth where a large number of&#010 requests are made - typically for skin images.  Also note that most technologies used by&#010 end-users to connect to the internet such as DSL and Cable are half-duplex, meaning that&#010 downstream must pause for upstream traffic to be sent and these connections also are&#010 asymmetric, allowing much faster download speeds than upload speeds.  As a result, the&#010 limited upstream capability of most connections ends up limiting the download bandwidth by&#010 delayng the download of other assets required to render the page.&#010 <p>&#010 2.  Whenever possible, don't sent the "Cache-Control" header to "private" - this tells&#010 intermediary proxies to not allow caching of the specified content, eliminating that cache&#010 as a useful intermediary for other users behind it.&#010 <p>&#010 3.  For a good overview of performance considerations, see this post:&#010 <a href='http://www.die.net/musings/page_load_time/' onclick="window.open('http://www.die.net/musings/page_load_time/');return false;">http://www.die.net/musings/page_load_time/</a>
 */
public interface NetworkPerformance {
}
