
package com.smartgwt.client.docs;

/**
 * SmartGWT Operations are dynamic, transparent communications made from the client-side&#010 SmartGWT system running in the browser, to the server-side SmartGWT system running in&#010 a servlet engine, or to other non-SmartGWT servers available via HTTP. Operations are&#010 used to load new data or new behavior into a running SmartGWT application. Operations are&#010 also used to save data entered by users, and in general, to get the result of any process&#010 which must be run on the server for security reasons.&#010 <br><br>&#010&#010 <b>RPC Operations</b>&#010 <br><br>&#010 RPC Operations are low-level communications that send and retrieve arbitrary data.  RPC&#010 Operations are supported by the {@link com.smartgwt.client.rpc.RPCManager} class, which when used with the&#010 SmartGWT server, provides Java to JavaScript {@link com.smartgwt.client.rpc.RPCRequest#getData data} of&#010 basic data structures.  The RPCManager also provides a mechanism for client-side code to be&#010 invoked when an operation completes (called a "callback").  RPC Operations are intended for&#010 unstructured data; data that is ultimately destined for display in SmartGWT components&#010 will generally come from DataSource operations.&#010 <br><br>&#010&#010 <b>DataSource Operations and DataBound Components</b>&#010 <br><br>&#010 A {@link com.smartgwt.client.docs.DataSourceOperations 'DataSource Operation'} is an operation that acts on a&#010 DataSource, performing one of the basic actions that makes sense on a set of similar&#010 records: "fetch", "add", "update" or "remove".  Unlike RPC operations, DataSource operations&#010 have specific request data and response data, for example, in the "fetch" DataSource&#010 operation, the request data is expected to be search criteria, and the response data is&#010 expected to be a list of matching DataSource records.  Although DataSource operations can be&#010 invoked manually from the client, they are generally automatically invoked by DataBound&#010 components.&#010 <br><br>&#010 DataBound Components are components that understand DataSources.  Databound components&#010 configured with a DataSource are able to offer complete user interactions without further&#010 configuration (extensive customization is also supported).&#010 <br><br>&#010 For example, given a DataSource, the ListGrid component supports a sophisticated inline&#010 editing interaction, complete with automatically chosen editors like date pickers for dates,&#010 type-aware validation, saving, and error reporting. &#010 <br><br>&#010 A DataBound component supporting an interaction such as inline editing will automatically&#010 submit DataSource operations to the server at appropriate times.&#010 <br><br>&#010&#010 <b>DataSource Operation Integration</b>&#010 <br><br>&#010 Integrating DataSource operations with an existing system is best approached by implementing&#010 the the 4 basic DataSource operations in terms of your existing object model or data store.&#010 With these 4 operations implemented, the entire range of user interactions supported by&#010 SmartGWT {@link com.smartgwt.client.widgets.DataBoundComponent} becomes applicable to&#010 your server.  At that point authentication, authorization and other business rules can be&#010 layered on top.&#010 <br><br>&#010&#010 <b>Built-in SQL Connectivity</b>&#010 <br><br>&#010 The SmartGWT server comes with built-in SQL connectivity, so that SQL-based DataSources&#010 can be created and used without any server-side code needing to be written.  In contrast,&#010 any operation which uses custom server-side code is called a "Custom Operation".&#010 <br><br>&#010 Generally it makes sense to prototype an application using Built-in DataSource Operations,&#010 then on the backend, create Custom DataSource Operations to retrieve data from the data&#010 store you will use in production.  As you switch from using Built-in DataSources to Custom&#010 Operations, no client-side code changes will be required, because the client cares only&#010 about the DataSource definition, not the data store which the data is ultimately retrieved&#010 from.&#010 <br><br>&#010&#010 <b>Data Managers: ResultSet and ResultTree</b>&#010 <br><br>&#010 Data Managers manage datasets retrieved from DataSources.  Data Managers are automatically&#010 created by DataBound components, but can be created directly when more control is needed.&#010 <br><br>&#010 Data Managers provide load-on-demand for datasets too large to be loaded on the client,&#010 automatically invoking DataSource operations as necessary to retrieve data as it is&#010 requested, and optionally fetching ahead to anticipate further requests.   Data Managers&#010 will automatically perform actions locally when it is possible, for example, a sort&#010 action can be performed locally with a complete cache.  Data Managers also automatically&#010 manage the consistency of the client-side cache, observing update operations performed&#010 against DataSources and integrating updated rows automatically.&#010 <br><br>
 * @see com.smartgwt.client.data.DataSource#fetchData
 * @see com.smartgwt.client.data.DataSource#filterData
 * @see com.smartgwt.client.data.DataSource#exportData
 * @see com.smartgwt.client.data.DataSource#addData
 * @see com.smartgwt.client.data.DataSource#updateData
 * @see com.smartgwt.client.data.DataSource#removeData
 * @see com.smartgwt.client.rpc.RPCManager#handleError
 * @see com.smartgwt.client.data.DSRequest#getOperationId
 * @see com.smartgwt.client.widgets.DataBoundComponent#getFetchOperation
 * @see com.smartgwt.client.widgets.DataBoundComponent#getUpdateOperation
 * @see com.smartgwt.client.widgets.DataBoundComponent#getAddOperation
 * @see com.smartgwt.client.widgets.DataBoundComponent#getRemoveOperation
 */
public interface Operations {
}
