
package com.smartgwt.client.docs;

/**
 * For prototyping purposes, the ISC server supports basic SQL connectivity for DataSources&#010 defined in XML.  Because the request processing flow for the built-in SQL engine is&#010 identical to the flow used for &#010 {@link com.smartgwt.client.docs.ServerDataIntegration 'integrating with other Java storage engines'},&#010 when your application grows past prototype stage you can switch to a different storage&#010 engine without wasted work.&#010 <P>&#010 To use the built-in SQL engine, declare a {@link com.smartgwt.client.data.DataSource} in XML format with&#010 {@link com.smartgwt.client.data.DataSource#getServerType serverType} set to "sql", and place it in the shared dataSources directory&#010 ([webroot]/shared/ds by default) in a file called "[dataSourceId].ds.xml".&#010 <p>&#010 You can then use the {@link com.smartgwt.client.docs.AdminConsole 'Admin Console'} to configure database access,&#010 as well as to automatically create and populate a database table based on your DataSource.&#010 By default, DataSources will use the "default database" from the admin console, however you&#010 can set {@link com.smartgwt.client.data.DataSource#getDbName dbName} to the name of a specific database configuration you have&#010 configured via the Admin Console.&#010 <P>&#010 The list of databases known to work with the the built-in SQL logic is as follows:&#010 <p>&#010 <table class='normal'>&#010 <tr><td width=40></td><td width=200><i>HSQLDB 1.7.x, 1.8.x</i></td><td></td></tr>&#010 <tr><td></td><td><i>IBM DB2 8.x, 9.x</i></td><td></td></tr>&#010 <tr><td></td><td><i>MS SQL Server 2000</i></td><td></td></tr>&#010 <tr><td></td><td><i>MySQL 3.2.x, 4.0.x, 4.1.x, 5.0.x, 5.1.x</i></td><td></td></tr>&#010 <tr><td></td><td><i>Oracle 8.0.5, 8i, 9i, 10g</i></td><td></td></tr>&#010 <tr><td></td><td><i>PostgreSQL 7.x, 8.x</i></td><td></td></tr>&#010 </table>&#010 <p>You will also need a JDBC driver for your specific database. Licensing restrictions&#010 prevent us including any JDBC driver other than the one for HSQLDB.  However, you&#010 can download these drivers for free from the vendors' websites.  If your specific database&#010 server or version is not listed above, please go to the&#010 <a href="http://forums.smartclient.com">SmartGWT forums</a> for assistance.&#010 <P>&#010 You can also connect to an existing database table - the ISC SQL engine simply generates a&#010 DB table whose columns match the DataSource field names and types, so you can instead&#010 declare a DataSource whose fields match an existing table.  To troubleshoot such an&#010 integration, you can look at the generated SQL for both table creation and {@link com.smartgwt.client.data.DSRequest}&#010 handling in the server-side log.&#010 <P>&#010 Once you have your SQL DataSource connected to a table, in a default SDK installation,&#010 DSRequests for your DataSource will be sent to the default&#010 {@link com.smartgwt.client.rpc.RPCManager#actionURL}, and hence handled automatically, without you having&#010 to write any Java code, by the {@link com.smartgwt.client.docs.Xml}.&#010 IDACall is a very simple servlet that just calls the server-side method&#010 dsRequest.execute() for all inbound requests.&#010 <P>&#010 If you need to customize how DSRequests are handled on the server, you can write your own&#010 version of the IDACall servlet to dispatch requests, as described under {@link com.smartgwt.client.rpc.RPCManager}&#010 and exemplified by the&#010 <a href='/examples/server_integration/#customDataSourceIntegration' onclick="window.open('/examples/server_integration/#customDataSourceIntegration');return false;">Custom DataSource Integration example</a>.&#010 This allows you add your own logic either before or after calling dsRequest.execute() &#010 to invoke the normal behavior of the SQL engine.  This means you can implement:&#010 <ol>&#010 <li> authenticated access (also see {@link com.smartgwt.client.docs.Relogin})&#010 <li> custom validation rules, via inspecting the inbound DSRequest and sending back a&#010      DSResponse with errors set&#010 <li> business rules such as user-based data visibility, by eg calling&#010      dsRequest.setCriteria() to set certain fixed criteria on all requests&#010 <li> side effects such as sending notifications mails after data is updated&#010 <li> server-side formatting or other derived values such as totals, by retrieving the&#010      default returned dataset via dsResponse.getData(), and updating it via&#010      dsResponse.setData()&#010 </ol>&#010 When your application grows past prototype stage and you switch to a different storage&#010 engine, you should be able to reuse any logic that surrounds the dsRequest.execute() call,&#010 simply replacing that dsRequest.execute() call with code that performs the dsRequest against&#010 your own storage engine.
 * @see com.smartgwt.client.data.DataSourceField#getSequenceName
 */
public interface SqlDataSource {
}
