/*
 * Decompiled with CFR 0.152.
 */
package com.ireasoning.core.jmx;

import com.ireasoning.core.jmx.AdaptorServer;
import com.ireasoning.core.jmx.AdaptorServerMBean;
import com.ireasoning.util.Logger;
import com.ireasoning.util.config.ConfigFileManager;
import com.ireasoning.util.config.LoggerConfigManager;
import java.net.InetAddress;
import javax.management.Attribute;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;

public class BaseAgent {
    protected MBeanServer _mbeanServer = null;
    boolean a = false;
    public static int b;

    public BaseAgent() {
        this.a(null);
    }

    public BaseAgent(MBeanServer mBeanServer) {
        this.a(mBeanServer);
    }

    private void a(MBeanServer mBeanServer) {
        if (mBeanServer == null) {
            Logger.info("Start MBeanServer.");
            this._mbeanServer = MBeanServerFactory.createMBeanServer();
        } else {
            this._mbeanServer = mBeanServer;
        }
        this.registerHelperMBeans();
    }

    protected void registerHelperMBeans() {
        if (this.a) {
            return;
        }
        try {
            Object object;
            if (!this._mbeanServer.isRegistered(ConfigFileManager.OBJECT_NAME)) {
                Logger.info("Start ConfigFileManager MBean.");
                object = new ConfigFileManager();
                this._mbeanServer.registerMBean(object, ConfigFileManager.OBJECT_NAME);
            }
            if (!this._mbeanServer.isRegistered(LoggerConfigManager.OBJECT_NAME)) {
                Logger.info("Start LoggerConfigManager MBean.");
                object = new LoggerConfigManager();
                this._mbeanServer.registerMBean(object, LoggerConfigManager.OBJECT_NAME);
            }
            this.a = true;
        }
        catch (Exception exception) {
            Logger.error(exception);
        }
    }

    protected void unregisterHelperMBeans() {
        try {
            if (this._mbeanServer.isRegistered(ConfigFileManager.OBJECT_NAME)) {
                Logger.info("Unregister config MBean");
                this._mbeanServer.unregisterMBean(ConfigFileManager.OBJECT_NAME);
            }
            if (this._mbeanServer.isRegistered(LoggerConfigManager.OBJECT_NAME)) {
                Logger.info("Unregister logger MBean");
                this._mbeanServer.unregisterMBean(LoggerConfigManager.OBJECT_NAME);
                this.a = false;
            }
        }
        catch (Exception exception) {
            Logger.error(exception);
        }
    }

    protected void startAdaptorServer(AdaptorServerMBean adaptorServerMBean, String string, int n2) throws Exception {
        this.startAdaptorServer(adaptorServerMBean, string, n2, null);
    }

    protected void startAdaptorServer(AdaptorServerMBean adaptorServerMBean, String string, int n2, InetAddress inetAddress) throws Exception {
        try {
            Logger.info("Start AdaptorServer: " + string + ", port is " + n2);
            ObjectName objectName = new ObjectName(AdaptorServer.getObjectName(string, n2));
            if (!this._mbeanServer.isRegistered(objectName)) {
                this._mbeanServer.registerMBean(adaptorServerMBean, objectName);
            }
            Attribute attribute = new Attribute("Port", new Integer(n2));
            this._mbeanServer.setAttribute(objectName, attribute);
            attribute = new Attribute("IpAddress", inetAddress);
            this._mbeanServer.setAttribute(objectName, attribute);
            this._mbeanServer.invoke(objectName, "startService", null, null);
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            throw exception;
        }
    }

    protected void stopAdaptorServer(String string, int n2) throws Exception {
        Logger.info("Stop AdaptorServer: " + string + ", port is " + n2);
        ObjectName objectName = new ObjectName(AdaptorServer.getObjectName(string, n2));
        if (this._mbeanServer.isRegistered(objectName)) {
            try {
                this._mbeanServer.invoke(objectName, "stopService", null, null);
            }
            catch (MBeanException mBeanException) {
                Exception exception = mBeanException.getTargetException();
                throw exception;
            }
            this._mbeanServer.unregisterMBean(objectName);
        }
    }

    public MBeanServer getMBeanServer() throws Exception {
        return this._mbeanServer;
    }
}

