/*
 * Decompiled with CFR 0.152.
 */
package com.ireasoning.protocol.snmp;

import com.ireasoning.protocol.snmp.NameValue;
import com.ireasoning.protocol.snmp.SnmpBits;
import com.ireasoning.protocol.snmp.SnmpOID;
import com.ireasoning.protocol.snmp.SnmpOctetString;
import com.ireasoning.protocol.snmp.VarBindContainer;
import com.ireasoning.util.Logger;
import com.ireasoning.util.MibParseException;
import com.ireasoning.util.MibTreeNode;
import com.ireasoning.util.Syntax;
import com.ireasoning.util.bo;
import com.ireasoning.util.bt;
import com.ireasoning.util.bu;
import com.ireasoning.util.bw;
import com.ireasoning.util.cd;
import java.io.IOException;
import java.io.Reader;
import java.util.Vector;

public final class MibUtil {
    private static MibUtil a = new MibUtil();

    private MibUtil() {
    }

    public static void loadMibs(String[] stringArray) throws IOException, MibParseException {
        MibUtil.loadMibs(stringArray, true);
    }

    public static void loadMibs(String[] stringArray, boolean bl2) throws IOException, MibParseException {
        bt.loadMibs(stringArray, bl2);
    }

    public static void loadMib(String string) throws IOException, MibParseException {
        MibUtil.loadMib(string, true);
    }

    public static void loadMib(String string, boolean bl2) throws IOException, MibParseException {
        bt.loadMib(string, bl2);
    }

    public static void loadMib2() {
        try {
            Reader reader = bu.getResourceAsReader("RFC1213.MIB");
            String string = bu.getResource("RFC1213.MIB").toString();
            bt.loadMib(reader, string);
        }
        catch (Exception exception) {
            Logger.error(exception);
        }
    }

    public static void unloadMib(String string) {
        bt.unloadMib(string);
    }

    public static void unloadAllMibs() {
        bt.unloadAllMibs();
    }

    public static boolean isMibFileLoaded() {
        return bo.isMibFileLoaded();
    }

    /*
     * Unable to fully structure code
     */
    public static SnmpOID lookupOID(String var0) {
        block40: {
            block39: {
                block38: {
                    block26: {
                        block27: {
                            block37: {
                                block36: {
                                    block35: {
                                        block33: {
                                            block34: {
                                                block29: {
                                                    block28: {
                                                        block25: {
                                                            var14_1 = VarBindContainer.b;
                                                            v0 = var0.startsWith(".");
                                                            if (var14_1 == 0) {
                                                                if (v0 != 0) {
                                                                    var0 = var0.substring(1);
                                                                }
                                                                v0 = var0.indexOf(".");
                                                            }
                                                            if ((var1_2 = v0) < 0) {
                                                                var2_3 = null;
                                                                var2_3 = bt.lookupOID(var0);
                                                                return var2_3;
                                                            }
                                                            var2_4 = var0.substring(0, var1_2);
                                                            var3_5 = var0.substring(var1_2 + 1);
                                                            v1 = bw.isDigit(var2_4);
                                                            if (var14_1 != 0) break block25;
                                                            if (v1) {
                                                                return new SnmpOID(var0);
                                                            }
                                                            v2 = var3_5;
                                                            if (var14_1 != 0) break block26;
                                                            v1 = bw.isDigit(v2);
                                                        }
                                                        if (v1) break block27;
                                                        v3 = var4_6 = var0.indexOf(".", var1_2 + 1);
                                                        if (var14_1 != 0) break block28;
                                                        if (v3 >= 0) break block29;
                                                        v3 = var0.length();
                                                    }
                                                    var4_6 = v3;
                                                }
                                                v2 = var5_8 = var0.substring(var1_2 + 1, var4_6);
                                                if (var14_1 != 0) break block26;
                                                if (bw.isDigit(v2)) break block27;
                                                var6_9 = cd.parse(var0, '.');
                                                var7_10 = bt.getRoot();
                                                var8_11 = false;
                                                var9_12 = var6_9.length;
                                                var10_13 = 0;
                                                var10_13 = 0;
                                                if (var14_1 == 0) ** GOTO lbl51
                                                block0: while (true) {
                                                    v4 = bw.isDigit(var6_9[var10_13]);
                                                    do {
                                                        block32: {
                                                            block31: {
                                                                block30: {
                                                                    if (var14_1 != 0) break block30;
                                                                    if (!v4) break block31;
                                                                    v4 = var8_11 = true;
                                                                }
                                                                if (var14_1 == 0) break block32;
                                                            }
                                                            if ((var7_10 = var7_10.searchIgnoreCase(var6_9[var10_13])) == null) {
                                                                return null;
                                                            }
                                                            ++var10_13;
lbl51:
                                                            // 2 sources

                                                            if (var10_13 < var6_9.length) continue block0;
                                                        }
                                                        var11_14 = var7_10.getOID();
                                                        v5 = var8_11;
                                                    } while (var14_1 != 0);
                                                    break;
                                                }
                                                if (var14_1 != 0) break block33;
                                                if (!v5) break block34;
                                                var12_15 = "." + var6_9[var10_13];
                                                var13_16 = var10_13 + 1;
                                                if (var14_1 == 0) ** GOTO lbl65
                                                block2: while (true) {
                                                    var12_15 = var12_15 + "." + var6_9[var13_16];
                                                    do {
                                                        ++var13_16;
lbl65:
                                                        // 2 sources

                                                        if (var13_16 < var6_9.length) continue block2;
                                                    } while (var14_1 != 0);
                                                    break;
                                                }
                                                var11_14.append(var12_15);
                                            }
                                            v6 = var7_10.isScalarNode();
                                        }
                                        if (var14_1 != 0) break block35;
                                        if (!v6) break block36;
                                        v7 = var11_14;
                                        if (var14_1 != 0) break block37;
                                        v6 = v7.endsWith(".0");
                                    }
                                    if (!v6) {
                                        var11_14.append(".0");
                                    }
                                }
                                v7 = var11_14;
                            }
                            return v7;
                        }
                        v2 = var2_4;
                    }
                    v8 = var4_7 = bt.lookupOID(v2);
                    if (var14_1 != 0) ** GOTO lbl94
                    if (v8 == null) {
                        v9 = null;
                    } else {
                        v8 = var4_7;
lbl94:
                        // 2 sources

                        v9 = v8.append(var3_5);
                    }
                    var4_7 = v9;
                    v10 = bt.isScalarNode(var2_4);
                    if (var14_1 != 0) break block38;
                    if (!v10) break block39;
                    v11 = var4_7;
                    if (var14_1 != 0) break block40;
                    v10 = v11.endsWith(".0.0");
                }
                if (v10) {
                    var4_7 = var4_7.suboid(0, var4_7.getLength() - 1);
                }
            }
            v11 = var4_7;
        }
        return v11;
    }

    public static String translateOID(String string, boolean bl2) {
        MibTreeNode mibTreeNode;
        block5: {
            MibTreeNode mibTreeNode2;
            block4: {
                mibTreeNode2 = mibTreeNode = bt.get(string);
                if (VarBindContainer.b != 0) break block4;
                if (mibTreeNode2 != null) break block5;
                mibTreeNode2 = mibTreeNode = bt.searchOther(new SnmpOID(string));
            }
            if (mibTreeNode2 == null) {
                return null;
            }
        }
        String string2 = MibUtil.a(string, mibTreeNode, bl2);
        return string2;
    }

    public static String translateOID(SnmpOID snmpOID, boolean bl2) {
        return MibUtil.translateOID(snmpOID.toString(), bl2);
    }

    public static String translateValue(String string, String string2) {
        String string3;
        MibTreeNode mibTreeNode = bt.get(string);
        String string4 = string3 = MibUtil.a(string2, mibTreeNode);
        if (VarBindContainer.b == 0) {
            if (string4 == null) {
                string3 = string2;
            }
            string4 = string3;
        }
        return string4;
    }

    public static String translateValue(SnmpOID snmpOID, String string) {
        return MibUtil.translateValue(snmpOID.toString(), string);
    }

    public static NameValue translate(String string, String string2, boolean bl2) {
        MibTreeNode mibTreeNode = bt.get(string);
        if (mibTreeNode == null) {
            return null;
        }
        String string3 = MibUtil.a(string, mibTreeNode, bl2);
        string2 = MibUtil.a(string2, mibTreeNode);
        return new NameValue(string3, string2);
    }

    public static NameValue translate(SnmpOID snmpOID, String string, boolean bl2) {
        return MibUtil.translate(snmpOID.toString(), string, bl2);
    }

    public static MibTreeNode parseMib(String string) throws IOException, MibParseException {
        return MibUtil.parseMib(string, true);
    }

    public static MibTreeNode parseMib(String string, boolean bl2) throws IOException, MibParseException {
        MibTreeNode mibTreeNode;
        bo bo2 = bo.loadMib(string, bl2);
        MibTreeNode mibTreeNode2 = mibTreeNode = bo2.getRoot();
        if (VarBindContainer.b == 0) {
            if (mibTreeNode2 != null) {
                mibTreeNode.setTrapNodes(bo2.getTraps());
            }
            mibTreeNode2 = mibTreeNode;
        }
        return mibTreeNode2;
    }

    public static MibTreeNode parseMibs(String[] stringArray) throws IOException, MibParseException {
        return MibUtil.parseMibs(stringArray, true);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static MibTreeNode parseMibs(String[] var0, boolean var1_1) throws IOException, MibParseException {
        var8_2 = VarBindContainer.b;
        var2_3 = bo.loadMib(var0[0], var1_1);
        var3_4 = new Vector<E>();
        var3_4.addAll(var2_3.getTraps());
        var4_5 = 1;
        if (var8_2 == 0) ** GOTO lbl29
        block0: while (true) {
            v0 = bo.loadMib(var0[var4_5]);
            do {
                block9: {
                    block10: {
                        block8: {
                            var5_6 = v0;
                            v1 /* !! */  = var5_6;
                            if (var8_2 != 0) break block8;
                            if (v1 /* !! */  == null) break block9;
                            var3_4.addAll(var5_6.getTraps());
                            v1 /* !! */  = var5_6;
                        }
                        v2 /* !! */  = var6_7 = v1 /* !! */ .getRoot();
                        if (var8_2 != 0) break block10;
                        if (v2 /* !! */  == null) break block9;
                        v2 /* !! */  = var6_7.getFirstChild();
                    }
                    if ((var7_8 = v2 /* !! */ ) != null) {
                        var2_3.addOtherSubTree((MibTreeNode)var7_8.getFirstChild());
                    }
                }
                ++var4_5;
lbl29:
                // 2 sources

                if (var4_5 < var0.length) continue block0;
                v0 = var2_3;
            } while (var8_2 != 0);
            break;
        }
        v3 = var5_6 = v0.getRoot();
        if (var8_2 == 0) {
            if (v3 != null) {
                var5_6.setTrapNodes(var3_4);
            }
            v3 = var5_6;
        }
        return v3;
    }

    public static MibTreeNode[] parseMibsWithoutMerge(String[] stringArray) throws IOException, MibParseException {
        return MibUtil.parseMibsWithoutMerge(stringArray, true);
    }

    /*
     * Unable to fully structure code
     */
    public static MibTreeNode[] parseMibsWithoutMerge(String[] var0, boolean var1_1) throws IOException, MibParseException {
        var4_2 = VarBindContainer.b;
        var2_3 = new MibTreeNode[var0.length];
        var3_4 = 0;
        if (var4_2 == 0) ** GOTO lbl10
        block0: while (true) {
            v0 = var2_3;
            do {
                v0[var3_4] = MibUtil.parseMib(var0[var3_4], var1_1);
                ++var3_4;
lbl10:
                // 2 sources

                if (var3_4 < var2_3.length) continue block0;
                v0 = var2_3;
            } while (var4_2 != 0);
            break;
        }
        return v0;
    }

    private static String a(String string, MibTreeNode mibTreeNode) {
        String string2;
        block14: {
            block13: {
                String string3;
                Syntax syntax;
                int n2;
                block12: {
                    Syntax syntax2;
                    block11: {
                        String string4;
                        block9: {
                            block10: {
                                String string5;
                                n2 = VarBindContainer.b;
                                MibTreeNode mibTreeNode2 = mibTreeNode;
                                if (n2 == 0) {
                                    if (mibTreeNode2 == null) {
                                        return null;
                                    }
                                    mibTreeNode2 = mibTreeNode;
                                }
                                syntax2 = mibTreeNode2.getSyntax();
                                string4 = string5 = mibTreeNode.getSyntaxType();
                                if (n2 != 0) break block9;
                                if (string4.equals("BITS")) break block10;
                                string4 = string5;
                                if (n2 != 0) break block9;
                                if (!string4.equals("FcPortFCClass")) break block11;
                            }
                            string4 = MibUtil.b(string, mibTreeNode);
                        }
                        return string4;
                    }
                    syntax = syntax2;
                    if (n2 != 0) break block12;
                    if (syntax == null) break block13;
                    syntax = syntax2;
                }
                string2 = string3 = syntax.get(string);
                if (n2 != 0) break block14;
                if (string2 != null) {
                    string = string3;
                }
            }
            string2 = string;
        }
        return string2;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String b(String string, MibTreeNode mibTreeNode) {
        int n2;
        int n3 = VarBindContainer.b;
        int n4 = n2 = string.indexOf("{");
        if (n3 == 0) {
            n4 = n4 >= 0 ? 1 : 0;
        }
        int n5 = n4;
        SnmpBits snmpBits = new SnmpBits();
        int n6 = n2;
        if (n3 == 0) {
            if (n6 < 0) {
                byte[] byArray = SnmpOctetString.getBytes(string);
                snmpBits.setValue(byArray);
                string = snmpBits.toString();
                n2 = string.indexOf("{");
            }
            n6 = string.indexOf("}");
        }
        int n7 = n6;
        string = string.substring(n2 + 1, n7);
        String[] stringArray = cd.parse(string, ',', true);
        Syntax syntax = mibTreeNode.getSyntax();
        String string2 = "{";
        boolean bl2 = true;
        int n8 = 0;
        boolean bl3 = true;
        do {
            block16: {
                String string3;
                block14: {
                    block15: {
                        String string4;
                        block13: {
                            Syntax syntax2;
                            block12: {
                                if (bl3 && !(bl3 = false) && n3 == 0) continue;
                                string4 = null;
                                syntax2 = syntax;
                                if (n3 != 0) break block12;
                                if (syntax2 == null) break block13;
                                syntax2 = syntax;
                            }
                            string4 = syntax2.get(stringArray[n8]);
                        }
                        boolean bl4 = bl2;
                        if (n3 == 0) {
                            if (!bl4) {
                                string2 = string2 + ", ";
                            }
                            bl4 = false;
                        }
                        bl2 = bl4;
                        string3 = string4;
                        if (n3 != 0) break block14;
                        if (string3 == null) break block15;
                        string2 = string2 + string4;
                        if (n3 == 0) break block16;
                    }
                    string3 = string2 + stringArray[n8];
                }
                string2 = string3;
            }
            ++n8;
        } while (n8 < stringArray.length);
        return string2 + "}";
    }

    private static String a(String string, MibTreeNode mibTreeNode, boolean bl2) {
        Object object;
        int n2;
        String string2;
        block6: {
            block7: {
                int n3 = VarBindContainer.b;
                MibTreeNode mibTreeNode2 = mibTreeNode;
                if (n3 == 0) {
                    if (mibTreeNode2 == null) {
                        return null;
                    }
                    mibTreeNode2 = mibTreeNode;
                }
                SnmpOID snmpOID = mibTreeNode2.getOID();
                string2 = ".0";
                n2 = string.endsWith(".0");
                if (n3 != 0) break block6;
                if (n2 != 0) break block7;
                object = new SnmpOID(string);
                string2 = "";
                n2 = snmpOID.getLength();
                if (n3 != 0) break block6;
                if (n2 < ((SnmpOID)object).getLength()) {
                    SnmpOID snmpOID2 = ((SnmpOID)object).suboid(snmpOID.getLength(), ((SnmpOID)object).getLength());
                    string2 = snmpOID2.toString();
                }
            }
            n2 = bl2;
        }
        object = n2 != 0 ? mibTreeNode.getFullName() + string2 : mibTreeNode.getName().toString() + string2;
        return object;
    }
}

