/*
 * Decompiled with CFR 0.152.
 */
package com.ireasoning.protocol.snmp;

import com.ireasoning.protocol.snmp.SnmpDataType;
import com.ireasoning.protocol.snmp.SnmpEncodingException;
import com.ireasoning.protocol.snmp.SnmpOctetString;
import com.ireasoning.protocol.snmp.bc;
import com.ireasoning.util.cd;

public class SnmpBits
extends SnmpOctetString {
    protected int _radix = 16;
    static final byte[][] b = new byte[][]{{0, 0, 0, 0}, {0, 0, 0, 1}, {0, 0, 1, 0}, {0, 0, 1, 1}, {0, 1, 0, 0}, {0, 1, 0, 1}, {0, 1, 1, 0}, {0, 1, 1, 1}, {1, 0, 0, 0}, {1, 0, 0, 1}, {1, 0, 1, 0}, {1, 0, 1, 1}, {1, 1, 0, 0}, {1, 1, 0, 1}, {1, 1, 1, 0}, {1, 1, 1, 1}};
    private long[] c = new long[SnmpBits.a(63) + 1];
    private transient int d = 0;

    public SnmpBits() {
    }

    public SnmpBits(int n2) {
        this._radix = n2;
        if (n2 != 2 && n2 != 16) {
            throw new IllegalArgumentException("Unknown radix");
        }
    }

    public SnmpBits(SnmpBits snmpBits) {
        this.or(snmpBits);
    }

    public int getType() {
        return 4;
    }

    public String getTypeString() {
        return "BITS";
    }

    public byte[] getValue() {
        int n2 = this.b();
        if (n2 % 8 != 0) {
            int n3 = n2 / 8;
            n2 = 8 * (n3 + 1);
        }
        byte[] byArray = null;
        if (this._radix == 2) {
            byArray = new byte[n2];
            int n4 = 0;
            while (n4 < n2) {
                byArray[n4] = n4 < this.b() ? (this.get(n4) ? (byte)1 : 0) : (byte)0;
                ++n4;
            }
        } else {
            int n5 = n2 / 8;
            byArray = new byte[n5];
            int n6 = 0;
            char[] cArray = new char[8];
            int n7 = 0;
            while (n7 < n5) {
                int n8 = 0;
                while (n8 < 8) {
                    int n9 = n6 < this.b() ? (this.get(n6++) ? 1 : 0) : 0;
                    cArray[n8] = n9 = (int)((char)(n9 + 48));
                    ++n8;
                }
                String string = new String(cArray);
                int n10 = Integer.parseInt(string, 2);
                byArray[n7] = (byte)n10;
                ++n7;
            }
        }
        return byArray;
    }

    public void setValue(byte[] byArray) {
        int n2 = 0;
        while (n2 < this.b()) {
            this.clear(n2);
            ++n2;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < byArray.length) {
            if (this._radix == 2) {
                if (byArray[n4] == 1) {
                    this.set(n4);
                }
            } else {
                int n5 = byArray[n4];
                if (byArray[n4] < 0) {
                    n5 = byArray[n4] + 256;
                }
                int n6 = 0;
                while (n6 < 2) {
                    int n7 = 0;
                    n7 = n6 == 0 ? n5 >> 4 : n5 & 0xF;
                    byte[] byArray2 = b[n7];
                    int n8 = 0;
                    while (n8 < byArray2.length) {
                        if (byArray2[n8] == 1) {
                            this.set(n3 + n8);
                        }
                        ++n8;
                    }
                    n3 += 4;
                    ++n6;
                }
            }
            ++n4;
        }
    }

    public void setValue(String string, boolean bl2) {
        if (bl2) {
            int n2 = string.indexOf("{");
            int n3 = string.indexOf("}");
            string = string.substring(n2 + 1, n3);
            String[] stringArray = cd.parse(string, ',', true);
            int n4 = 0;
            while (n4 < stringArray.length) {
                if (stringArray[n4].length() > 0) {
                    int n5 = Integer.parseInt(stringArray[n4]);
                    this.set(n5);
                }
                ++n4;
            }
        } else {
            this.a(string);
        }
    }

    public void setValue(String string) {
        this.a(string);
    }

    private void a(String string) {
        int n2 = 0;
        while (n2 < this.b()) {
            this.clear(n2);
            ++n2;
        }
        int n3 = 0;
        string = string.trim();
        char[] cArray = string.toCharArray();
        int n4 = 0;
        while (n4 < cArray.length) {
            int n5;
            if (this._radix == 2) {
                n5 = this.a(cArray[n4]);
                if (n5 == 1) {
                    this.set(n4);
                }
            } else {
                n5 = this.a(cArray[n4]);
                byte[] byArray = b[n5];
                int n6 = 0;
                while (n6 < byArray.length) {
                    if (byArray[n6] == 1) {
                        this.set(n3 + n6);
                    }
                    ++n6;
                }
                n3 += 4;
            }
            ++n4;
        }
    }

    private int a(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            c2 = (char)(c2 - 48);
        } else if (c2 >= 'A' && c2 <= 'Z') {
            c2 = (char)(c2 - 55);
        } else if (c2 >= 'a' && c2 <= 'z') {
            c2 = (char)(c2 - 87);
        }
        return c2;
    }

    public String toString() {
        int n2 = this.d << 6;
        StringBuffer stringBuffer = new StringBuffer(8 * n2 + 2);
        String string = "";
        stringBuffer.append('{');
        int n3 = 0;
        while (n3 < n2) {
            if (this.get(n3)) {
                stringBuffer.append(string);
                string = ", ";
                stringBuffer.append(n3);
            }
            ++n3;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public SnmpDataType copy() {
        return new SnmpBits(this);
    }

    public int encode(bc bc2) throws SnmpEncodingException {
        return bc2.a(this);
    }

    private static int a(int n2) {
        return n2 >> 6;
    }

    private static long b(int n2) {
        return 1L << (n2 & 0x3F);
    }

    private void a() {
        int n2 = this.d - 1;
        while (n2 >= 0) {
            if (this.c[n2] != 0L) break;
            --n2;
        }
        this.d = n2 + 1;
    }

    private void c(int n2) {
        if (this.c.length < n2) {
            int n3 = Math.max(2 * this.c.length, n2);
            long[] lArray = new long[n3];
            System.arraycopy(this.c, 0, lArray, 0, this.d);
            this.c = lArray;
        }
    }

    public void flip(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + n2);
        }
        int n3 = SnmpBits.a(n2);
        int n4 = n3 + 1;
        if (this.d < n4) {
            this.c(n4);
            int n5 = n3;
            this.c[n5] = this.c[n5] ^ SnmpBits.b(n2);
            this.d = n4;
        } else {
            int n6 = n3;
            this.c[n6] = this.c[n6] ^ SnmpBits.b(n2);
            if (this.c[this.d - 1] == 0L) {
                this.a();
            }
        }
    }

    public void flip(int n2, int n3) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n2);
        }
        if (n3 < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + n3);
        }
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("fromIndex: " + n2 + " > toIndex: " + n3);
        }
        int n4 = SnmpBits.a(n3);
        int n5 = n4 + 1;
        if (this.d < n5) {
            this.c(n5);
            this.d = n5;
        }
        int n6 = SnmpBits.a(n2);
        long l2 = 0L;
        if (n6 == n4) {
            l2 = (1L << (n3 & 0x3F)) - (1L << (n2 & 0x3F));
            int n7 = n6;
            this.c[n7] = this.c[n7] ^ l2;
            if (this.c[this.d - 1] == 0L) {
                this.a();
            }
            return;
        }
        l2 = SnmpBits.e(n2 & 0x3F);
        int n8 = n6;
        this.c[n8] = this.c[n8] ^ l2;
        if (n4 - n6 > 1) {
            int n9 = n6 + 1;
            while (n9 < n4) {
                int n10 = n9++;
                this.c[n10] = this.c[n10] ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        l2 = SnmpBits.d(n3 & 0x3F);
        int n11 = n4;
        this.c[n11] = this.c[n11] ^ l2;
        if (this.c[this.d - 1] == 0L) {
            this.a();
        }
    }

    private static long d(int n2) {
        return n2 == 0 ? 0L : -1L >>> 64 - n2;
    }

    private static long e(int n2) {
        return -1L << n2;
    }

    public void set(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + n2);
        }
        int n3 = SnmpBits.a(n2);
        int n4 = n3 + 1;
        if (this.d < n4) {
            this.c(n4);
            int n5 = n3;
            this.c[n5] = this.c[n5] | SnmpBits.b(n2);
            this.d = n4;
        } else {
            int n6 = n3;
            this.c[n6] = this.c[n6] | SnmpBits.b(n2);
        }
    }

    public void set(int n2, boolean bl2) {
        if (bl2) {
            this.set(n2);
        } else {
            this.clear(n2);
        }
    }

    public void set(int n2, int n3) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n2);
        }
        if (n3 < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + n3);
        }
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("fromIndex: " + n2 + " > toIndex: " + n3);
        }
        int n4 = SnmpBits.a(n3);
        int n5 = n4 + 1;
        if (this.d < n5) {
            this.c(n5);
            this.d = n5;
        }
        int n6 = SnmpBits.a(n2);
        long l2 = 0L;
        if (n6 == n4) {
            l2 = (1L << (n3 & 0x3F)) - (1L << (n2 & 0x3F));
            int n7 = n6;
            this.c[n7] = this.c[n7] | l2;
            return;
        }
        l2 = SnmpBits.e(n2 & 0x3F);
        int n8 = n6;
        this.c[n8] = this.c[n8] | l2;
        if (n4 - n6 > 1) {
            int n9 = n6 + 1;
            while (n9 < n4) {
                int n10 = n9++;
                this.c[n10] = this.c[n10] | 0xFFFFFFFFFFFFFFFFL;
            }
        }
        l2 = SnmpBits.d(n3 & 0x3F);
        int n11 = n4;
        this.c[n11] = this.c[n11] | l2;
    }

    public void set(int n2, int n3, boolean bl2) {
        if (bl2) {
            this.set(n2, n3);
        } else {
            this.clear(n2, n3);
        }
    }

    public void clear(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + n2);
        }
        int n3 = SnmpBits.a(n2);
        if (n3 >= this.d) {
            return;
        }
        int n4 = n3;
        this.c[n4] = this.c[n4] & (SnmpBits.b(n2) ^ 0xFFFFFFFFFFFFFFFFL);
        if (this.c[this.d - 1] == 0L) {
            this.a();
        }
    }

    public void clear(int n2, int n3) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n2);
        }
        if (n3 < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + n3);
        }
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("fromIndex: " + n2 + " > toIndex: " + n3);
        }
        int n4 = SnmpBits.a(n2);
        if (n4 >= this.d) {
            return;
        }
        int n5 = SnmpBits.a(n3);
        long l2 = 0L;
        if (n4 == n5) {
            l2 = (1L << (n3 & 0x3F)) - (1L << (n2 & 0x3F));
            int n6 = n4;
            this.c[n6] = this.c[n6] & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
            if (this.c[this.d - 1] == 0L) {
                this.a();
            }
            return;
        }
        l2 = SnmpBits.e(n2 & 0x3F);
        int n7 = n4;
        this.c[n7] = this.c[n7] & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
        if (n5 - n4 > 1) {
            int n8 = n4 + 1;
            while (n8 < n5) {
                if (n8 < this.d) {
                    this.c[n8] = 0L;
                }
                ++n8;
            }
        }
        if (n5 < this.d) {
            l2 = SnmpBits.d(n3 & 0x3F);
            int n9 = n5;
            this.c[n9] = this.c[n9] & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
        }
        if (this.c[this.d - 1] == 0L) {
            this.a();
        }
    }

    public void clear() {
        while (this.d > 0) {
            this.c[--this.d] = 0L;
        }
    }

    public boolean get(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + n2);
        }
        boolean bl2 = false;
        int n3 = SnmpBits.a(n2);
        if (n3 < this.d) {
            bl2 = (this.c[n3] & SnmpBits.b(n2)) != 0L;
        }
        return bl2;
    }

    private int b() {
        if (this.d == 0) {
            return 0;
        }
        long l2 = this.c[this.d - 1];
        int n2 = (int)(l2 >>> 32);
        return 64 * (this.d - 1) + (n2 == 0 ? SnmpBits.f((int)l2) : 32 + SnmpBits.f(n2));
    }

    private static int f(int n2) {
        return n2 < 32768 ? (n2 < 128 ? (n2 < 8 ? (n2 < 2 ? (n2 < 1 ? (n2 < 0 ? 32 : 0) : 1) : (n2 < 4 ? 2 : 3)) : (n2 < 32 ? (n2 < 16 ? 4 : 5) : (n2 < 64 ? 6 : 7))) : (n2 < 2048 ? (n2 < 512 ? (n2 < 256 ? 8 : 9) : (n2 < 1024 ? 10 : 11)) : (n2 < 8192 ? (n2 < 4096 ? 12 : 13) : (n2 < 16384 ? 14 : 15)))) : (n2 < 0x800000 ? (n2 < 524288 ? (n2 < 131072 ? (n2 < 65536 ? 16 : 17) : (n2 < 262144 ? 18 : 19)) : (n2 < 0x200000 ? (n2 < 0x100000 ? 20 : 21) : (n2 < 0x400000 ? 22 : 23))) : (n2 < 0x8000000 ? (n2 < 0x2000000 ? (n2 < 0x1000000 ? 24 : 25) : (n2 < 0x4000000 ? 26 : 27)) : (n2 < 0x20000000 ? (n2 < 0x10000000 ? 28 : 29) : (n2 < 0x40000000 ? 30 : 31))));
    }

    public boolean isEmpty() {
        return this.d == 0;
    }

    public int cardinality() {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.d) {
            n2 += SnmpBits.a(this.c[n3]);
            ++n3;
        }
        return n2;
    }

    private static int a(long l2) {
        l2 -= (l2 & 0xAAAAAAAAAAAAAAAAL) >>> 1;
        l2 = (l2 & 0x3333333333333333L) + (l2 >>> 2 & 0x3333333333333333L);
        l2 = l2 + (l2 >>> 4) & 0xF0F0F0F0F0F0F0FL;
        l2 += l2 >>> 8;
        l2 += l2 >>> 16;
        return (int)l2 + (int)(l2 >>> 32) & 0xFF;
    }

    public void and(SnmpBits snmpBits) {
        if (this == snmpBits) {
            return;
        }
        int n2 = this.d;
        this.d = Math.min(this.d, snmpBits.d);
        int n3 = 0;
        while (n3 < this.d) {
            int n4 = n3;
            this.c[n4] = this.c[n4] & snmpBits.c[n3];
            ++n3;
        }
        while (n3 < n2) {
            this.c[n3] = 0L;
            ++n3;
        }
        if (this.d > 0 && this.c[this.d - 1] == 0L) {
            this.a();
        }
    }

    public void or(SnmpBits snmpBits) {
        if (this == snmpBits) {
            return;
        }
        this.c(snmpBits.d);
        int n2 = Math.min(this.d, snmpBits.d);
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3;
            this.c[n4] = this.c[n4] | snmpBits.c[n3];
            ++n3;
        }
        while (n3 < snmpBits.d) {
            this.c[n3] = snmpBits.c[n3];
            ++n3;
        }
        if (this.d < snmpBits.d) {
            this.d = snmpBits.d;
        }
    }

    public void xor(SnmpBits snmpBits) {
        int n2;
        int n3;
        if (this.d >= snmpBits.d) {
            n3 = snmpBits.d;
        } else {
            n3 = this.d;
            n2 = snmpBits.d;
            this.c(n2);
            this.d = n2;
        }
        n2 = 0;
        while (n2 < n3) {
            int n4 = n2;
            this.c[n4] = this.c[n4] ^ snmpBits.c[n2];
            ++n2;
        }
        while (n2 < snmpBits.d) {
            this.c[n2] = snmpBits.c[n2];
            ++n2;
        }
        this.a();
    }

    public void andNot(SnmpBits snmpBits) {
        int n2 = Math.min(this.d, snmpBits.d);
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3;
            this.c[n4] = this.c[n4] & (snmpBits.c[n3] ^ 0xFFFFFFFFFFFFFFFFL);
            ++n3;
        }
        this.a();
    }

    public int hashCode() {
        long l2 = 1234L;
        int n2 = this.c.length;
        while (--n2 >= 0) {
            l2 ^= this.c[n2] * (long)(n2 + 1);
        }
        return (int)(l2 >> 32 ^ l2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SnmpBits)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        SnmpBits snmpBits = (SnmpBits)object;
        int n2 = Math.min(this.d, snmpBits.d);
        int n3 = 0;
        while (n3 < n2) {
            if (this.c[n3] != snmpBits.c[n3]) {
                return false;
            }
            ++n3;
        }
        if (this.d > n2) {
            int n4 = n2;
            while (n4 < this.d) {
                if (this.c[n4] != 0L) {
                    return false;
                }
                ++n4;
            }
        } else {
            int n5 = n2;
            while (n5 < snmpBits.d) {
                if (snmpBits.c[n5] != 0L) {
                    return false;
                }
                ++n5;
            }
        }
        return true;
    }
}

