/*
 * Decompiled with CFR 0.152.
 */
package com.ireasoning.protocol.snmp;

import com.ireasoning.protocol.snmp.SnmpDataType;
import com.ireasoning.protocol.snmp.SnmpEncodingException;
import com.ireasoning.protocol.snmp.SnmpOctetString;
import com.ireasoning.protocol.snmp.bc;
import com.ireasoning.util.cd;
import java.net.InetAddress;

public class SnmpIpAddress
extends SnmpOctetString {
    public SnmpIpAddress() {
        byte[] byArray = new byte[]{0, 0, 0, 0};
        this.setValue(byArray);
    }

    public SnmpIpAddress(byte[] byArray) {
        super(byArray);
    }

    public SnmpIpAddress(SnmpIpAddress snmpIpAddress) {
        super(snmpIpAddress);
    }

    public SnmpIpAddress(String string) {
        this.a(string);
    }

    public SnmpIpAddress(InetAddress inetAddress) {
        if (inetAddress == null) {
            this.setValue(new byte[]{0, 0, 0, 0});
        } else {
            this.setValue(inetAddress.getAddress());
        }
    }

    private void a(String string) {
        if (string == null || string.trim().length() == 0) {
            this.setValue(new byte[]{0, 0, 0, 0});
            return;
        }
        String[] stringArray = cd.parse(string, '.', true);
        byte[] byArray = new byte[4];
        if (stringArray.length != 4) {
            throw new IllegalArgumentException("Passed ip address is invalid");
        }
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = Integer.parseInt(stringArray[n2]);
            if (n3 > 255 || n3 < 0) {
                throw new IllegalArgumentException("Passed ip address is invalid");
            }
            byArray[n2] = (byte)n3;
            ++n2;
        }
        this.setValue(byArray);
    }

    public int getType() {
        return 64;
    }

    public String getTypeString() {
        return "IpAddress";
    }

    public String toString() {
        return this.b("");
    }

    private String b(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < this.a.length) {
            int n3 = this.a[n2];
            if (n3 < 0) {
                n3 += 256;
            }
            stringBuffer.append(n3);
            if (n2 != this.a.length - 1) {
                stringBuffer.append(".");
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public InetAddress toInetAddress() {
        try {
            return InetAddress.getByName(this.toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public SnmpDataType copy() {
        return new SnmpIpAddress(this);
    }

    public int encode(bc bc2) throws SnmpEncodingException {
        return bc2.a(this);
    }
}

