/*
 * Decompiled with CFR 0.152.
 */
package com.ireasoning.protocol.snmp;

import com.ireasoning.protocol.snmp.SnmpDataType;
import com.ireasoning.protocol.snmp.SnmpEncodingException;
import com.ireasoning.protocol.snmp.bc;
import com.ireasoning.util.bv;

public class SnmpOID
implements SnmpDataType,
Comparable {
    protected int[] _value = new int[0];
    public static final int MAX_LENGTH = 128;

    public SnmpOID() {
    }

    public SnmpOID(String string) {
        if (string == null) {
            return;
        }
        this._value = SnmpOID.a(string);
    }

    public SnmpOID(int[] nArray, int n2) {
        this(nArray, 0, n2);
    }

    public SnmpOID(int[] nArray, int n2, int n3) {
        this();
        if (!(n2 < nArray.length && n2 >= 0 && n2 + n3 <= nArray.length || n2 == nArray.length && n2 == 0)) {
            throw new IndexOutOfBoundsException("offset: " + n2 + ", length: " + n3 + ", data length: " + nArray.length);
        }
        if (n3 > 128) {
            throw new IllegalArgumentException("OID containts too many sub-identifiers");
        }
        if (nArray != null) {
            this._value = new int[n3];
            System.arraycopy(nArray, n2, this._value, 0, n3);
        }
    }

    public SnmpOID(int[] nArray) {
        this(nArray, nArray.length);
    }

    public SnmpOID(long[] lArray, int n2) {
        this(lArray, 0, n2);
    }

    public SnmpOID(long[] lArray, int n2, int n3) {
        this();
        if (!(n2 < lArray.length && n2 >= 0 && n2 + n3 <= lArray.length && n3 <= 128 || n2 == lArray.length && n2 == 0)) {
            throw new IndexOutOfBoundsException("offset: " + n2 + ", length: " + n3 + ", data length: " + lArray.length);
        }
        if (lArray != null) {
            this._value = new int[n3];
            SnmpOID.a(lArray, n2, this._value, 0, n3);
        }
    }

    public SnmpOID(SnmpOID snmpOID, SnmpOID snmpOID2) {
        this._value = new int[snmpOID._value.length + snmpOID2._value.length];
        System.arraycopy(snmpOID._value, 0, this._value, 0, snmpOID._value.length);
        System.arraycopy(snmpOID2._value, 0, this._value, snmpOID._value.length, snmpOID2._value.length);
    }

    public SnmpOID(int[] nArray, int[] nArray2) {
        this._value = new int[nArray.length + nArray2.length];
        System.arraycopy(nArray, 0, this._value, 0, nArray.length);
        System.arraycopy(nArray2, 0, this._value, nArray.length, nArray2.length);
    }

    private static void a(long[] lArray, int n2, int[] nArray, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            nArray[n3++] = (int)lArray[n2++];
            ++n5;
        }
    }

    public SnmpOID(long[] lArray) {
        this(lArray, lArray.length);
    }

    public SnmpOID(SnmpOID snmpOID) {
        this(snmpOID._value);
    }

    public int indexOf(SnmpOID snmpOID) {
        int[] nArray = snmpOID._value;
        if (nArray.length > this._value.length) {
            return -1;
        }
        if (nArray.length == this._value.length && nArray[0] != this._value[0]) {
            return -1;
        }
        int n2 = 0;
        while (n2 < this._value.length) {
            if (this._value[n2] == nArray[0]) {
                boolean bl2 = true;
                int n3 = 1;
                while (n3 < nArray.length) {
                    if (n2 + n3 >= this._value.length) {
                        return -1;
                    }
                    if (nArray[n3] != this._value[n2 + n3]) {
                        bl2 = false;
                        break;
                    }
                    ++n3;
                }
                if (bl2) {
                    return n2;
                }
            }
            ++n2;
        }
        return -1;
    }

    public SnmpOID suboid(int n2) {
        return new SnmpOID(this._value, n2, this._value.length - n2);
    }

    public SnmpOID suboid(int n2, int n3) {
        return new SnmpOID(this._value, n2, n3 - n2);
    }

    public int getLength() {
        return this._value.length;
    }

    public int[] getValue() {
        return this._value;
    }

    public int get(int n2) {
        return this._value[n2];
    }

    public void setValue(int[] nArray) {
        this._value = nArray;
    }

    public void setValue(long[] lArray) {
        this._value = new int[lArray.length];
        int n2 = 0;
        while (n2 < lArray.length) {
            this._value[n2] = (int)lArray[n2];
            ++n2;
        }
    }

    public void setValue(String string) {
        this._value = SnmpOID.a(string);
    }

    public void setValue(SnmpOID snmpOID) {
        this.setValue(snmpOID._value);
    }

    public boolean endsWith(String string) {
        if (this._value.length == 0) {
            return false;
        }
        int[] nArray = SnmpOID.a(string);
        return this.a(nArray);
    }

    private boolean a(int[] nArray) {
        int n2 = this._value.length - 1;
        int n3 = nArray.length - 1;
        while (n3 >= 0) {
            if (this._value[n2] != nArray[n3]) {
                return false;
            }
            --n2;
            --n3;
        }
        return true;
    }

    public boolean endsWith(SnmpOID snmpOID) {
        if (this._value.length == 0) {
            return false;
        }
        return this.a(snmpOID._value);
    }

    public boolean endsWith(int[] nArray) {
        if (this._value.length == 0) {
            return false;
        }
        return this.a(nArray);
    }

    private static int[] a(String string) {
        int n2 = 0;
        char[] cArray = string.toCharArray();
        if (cArray.length == 0) {
            int[] nArray = new int[]{};
            return nArray;
        }
        if (cArray[0] != '.') {
            ++n2;
        }
        int n3 = 0;
        while (n3 < cArray.length) {
            if (cArray[n3++] != '.') continue;
            ++n2;
        }
        if (n2 == 0) {
            int[] nArray = new int[]{};
            return nArray;
        }
        int[] nArray = new int[n2];
        int n4 = 0;
        int n5 = 0;
        if (cArray[0] == '.') {
            ++n5;
        }
        int n6 = 0;
        while (n5 < cArray.length) {
            if (cArray[n5] == '.') {
                nArray[n4++] = n6;
                n6 = 0;
            } else {
                n6 *= 10;
                n6 += cArray[n5] - 48;
            }
            ++n5;
        }
        nArray[n4++] = n6;
        return nArray;
    }

    public SnmpOID append(int[] nArray) {
        if (nArray != null && nArray.length != 0) {
            int[] nArray2 = new int[this._value.length + nArray.length];
            System.arraycopy(this._value, 0, nArray2, 0, this._value.length);
            System.arraycopy(nArray, 0, nArray2, this._value.length, nArray.length);
            this._value = nArray2;
        }
        return this;
    }

    public SnmpOID append(long[] lArray) {
        if (lArray != null && lArray.length != 0) {
            int[] nArray = new int[this._value.length + lArray.length];
            System.arraycopy(this._value, 0, nArray, 0, this._value.length);
            SnmpOID.a(lArray, 0, nArray, this._value.length, lArray.length);
            this._value = nArray;
        }
        return this;
    }

    public SnmpOID append(String string) {
        if (string == null || string.length() == 0) {
            return this;
        }
        int[] nArray = SnmpOID.a(string);
        return this.append(nArray);
    }

    public SnmpOID append(SnmpOID snmpOID) {
        return this.append(snmpOID._value);
    }

    private int b(int[] nArray) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n2 < this._value.length || n3 < nArray.length) {
            int n5 = 0;
            if (n2 < this._value.length) {
                n5 = this._value[n2++] + 1;
            }
            int n6 = 0;
            if (n3 < nArray.length) {
                n6 = nArray[n3++] + 1;
            }
            if ((n4 = n5 - n6) != 0) break;
        }
        return n4;
    }

    private int a(int[] nArray, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n3 < n2 && n3 < this._value.length || n4 < n2 && n4 < nArray.length) {
            int n6 = 0;
            if (n3 < this._value.length) {
                n6 = this._value[n3++] + 1;
            }
            int n7 = 0;
            if (n4 < nArray.length) {
                n7 = nArray[n4++] + 1;
            }
            if ((n5 = n6 - n7) != 0) break;
        }
        return n5;
    }

    public int compareTo(Object object) {
        return this.compareTo((SnmpOID)object);
    }

    public int compareTo(SnmpOID snmpOID) {
        return this.b(snmpOID._value);
    }

    public int compareTo(SnmpOID snmpOID, int n2) {
        return this.a(snmpOID._value, n2);
    }

    public boolean startsWith(String string) {
        return this.startsWith(new SnmpOID(string));
    }

    public boolean startsWith(SnmpOID snmpOID) {
        if (snmpOID == null) {
            return false;
        }
        return this.compareTo(snmpOID, snmpOID._value.length) == 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SnmpOID) {
            return this.b(((SnmpOID)object)._value) == 0;
        }
        if (object instanceof String) {
            return this.b(SnmpOID.a((String)object)) == 0;
        }
        if (object instanceof int[]) {
            return this.b((int[])object) == 0;
        }
        return false;
    }

    public String toString() {
        return SnmpOID.c(this._value);
    }

    private static String c(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.ensureCapacity(nArray.length * 3);
        int n2 = 0;
        while (n2 < nArray.length) {
            stringBuffer.append('.');
            long l2 = (long)nArray[n2] & 0xFFFFFFFFL;
            stringBuffer.append(Long.toString(l2));
            ++n2;
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this._value.length) {
            n2 = n2 * 31 + this._value[n3];
            ++n3;
        }
        return n2;
    }

    public int getType() {
        return 6;
    }

    public String getTypeString() {
        return "OID";
    }

    public SnmpDataType copy() {
        return new SnmpOID(this);
    }

    public int encode(bc bc2) throws SnmpEncodingException {
        return bc2.a(this);
    }

    public static String getCommonSuffix(SnmpOID snmpOID, SnmpOID snmpOID2) {
        int[] nArray = snmpOID.getValue();
        int[] nArray2 = snmpOID2.getValue();
        int n2 = nArray.length - 1;
        int n3 = nArray2.length - 1;
        bv bv2 = new bv();
        while (n2 >= 0 && n3 >= 0) {
            if (nArray[n2] != nArray2[n3]) break;
            bv2.add("" + nArray[n2]);
            --n2;
            --n3;
        }
        if (bv2.isEmpty()) {
            return "";
        }
        String[] stringArray = bv2.toArray();
        String string = ".";
        n2 = stringArray.length - 1;
        while (n2 >= 0) {
            string = string + stringArray[n2];
            if (n2 != 0) {
                string = string + ".";
            }
            --n2;
        }
        return string;
    }
}

