/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.asn;

import cryptix.jce.provider.asn.AsnBitString;
import cryptix.jce.provider.asn.AsnInteger;
import cryptix.jce.provider.asn.AsnNull;
import cryptix.jce.provider.asn.AsnObject;
import cryptix.jce.provider.asn.AsnObjectId;
import cryptix.jce.provider.asn.AsnSequence;
import cryptix.jce.provider.asn.AsnUnknown;
import cryptix.jce.provider.asn.SubInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class AsnInputStream {
    private final InputStream is;

    public AsnInputStream(InputStream inputStream) {
        this.is = inputStream;
    }

    public AsnInputStream(byte[] byArray) {
        this.is = new ByteArrayInputStream(byArray);
    }

    public int available() throws IOException {
        return this.is.available();
    }

    AsnInputStream getSubStream(int n2) {
        return new AsnInputStream(new SubInputStream(this.is, n2));
    }

    public AsnObject read() throws IOException {
        int n2 = this.is.read();
        if (n2 == -1) {
            throw new IOException("End of stream.");
        }
        byte by2 = (byte)n2;
        switch (by2) {
            case 6: {
                return new AsnObjectId(this);
            }
            case 3: {
                return new AsnBitString(this);
            }
            case 2: {
                return new AsnInteger(this);
            }
            case 5: {
                return new AsnNull(this);
            }
            case 48: {
                return new AsnSequence(this);
            }
        }
        return new AsnUnknown(by2, this);
    }

    byte readByte() throws IOException {
        return this.readBytes(1)[0];
    }

    byte[] readBytes(int n2) throws IOException {
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (n2 > 0) {
            int n4 = this.is.read(byArray, n3, n2);
            if (n4 == -1) {
                throw new IOException("EOF");
            }
            n2 -= n4;
            n3 += n4;
        }
        return byArray;
    }

    int readLength() throws IOException {
        int n2 = this.is.read();
        if (n2 == -1) {
            throw new IOException("Unexpected end of stream.");
        }
        if (n2 <= 127) {
            return n2;
        }
        if ((n2 &= 0x7F) > 4) {
            throw new IOException("Length too big.");
        }
        int n3 = 0;
        while (n2-- > 0) {
            int n4 = this.is.read();
            if (n4 == -1) {
                throw new IOException("Unexpected end of stream.");
            }
            n3 = n3 << 8 | n4;
        }
        if (n3 < 0) {
            throw new IOException("Negative length.");
        }
        return n3;
    }
}

