/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.cipher;

import cryptix.jce.provider.cipher.BlockCipher;
import cryptix.jce.provider.cipher.Mode;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;

final class ModeCBC
extends Mode {
    private final byte[] buf = new byte[this.CIPHER_BLOCK_SIZE];
    private final byte[] prevBlock = new byte[this.CIPHER_BLOCK_SIZE];
    private byte[] IV = null;

    ModeCBC(BlockCipher blockCipher) {
        super(blockCipher);
    }

    final byte[] coreGetIV() {
        return this.IV;
    }

    final int coreGetOutputSize(int n2) {
        return (this.bufCount + n2) / this.CIPHER_BLOCK_SIZE * this.CIPHER_BLOCK_SIZE;
    }

    final AlgorithmParameterSpec coreGetParamSpec() {
        if (this.IV == null) {
            return new IvParameterSpec(this.generateIV());
        }
        return new IvParameterSpec(this.IV);
    }

    final void coreInit(boolean bl2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cipher.coreInit(key, bl2);
        this.IV = this.extractIV(algorithmParameterSpec);
        if (bl2) {
            System.arraycopy(this.IV, 0, this.prevBlock, 0, this.CIPHER_BLOCK_SIZE);
            this.bufCount = 0;
        } else {
            System.arraycopy(this.IV, 0, this.buf, 0, this.CIPHER_BLOCK_SIZE);
            this.bufCount = 0;
        }
    }

    int coreUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        int n5;
        int n6;
        if (this.decrypt) {
            int n7;
            int n8;
            int n9 = 0;
            while (n3 >= (n8 = this.CIPHER_BLOCK_SIZE - this.bufCount)) {
                n7 = 0;
                while (n7 < n8) {
                    this.buf[this.bufCount++] = byArray[n2++];
                    ++n7;
                }
                this.cipher.coreCrypt(this.buf, 0, byArray2, n4);
                int n10 = 0;
                while (n10 < this.CIPHER_BLOCK_SIZE) {
                    int n11 = n4++;
                    byArray2[n11] = (byte)(byArray2[n11] ^ this.prevBlock[n10]);
                    ++n10;
                }
                int n12 = 0;
                while (n12 < this.CIPHER_BLOCK_SIZE) {
                    this.prevBlock[n12] = this.buf[n12];
                    ++n12;
                }
                n3 -= this.CIPHER_BLOCK_SIZE;
                n9 += this.CIPHER_BLOCK_SIZE;
                this.bufCount = 0;
            }
            n7 = 0;
            while (n7 < n3) {
                this.buf[this.bufCount++] = byArray[n2++];
                ++n7;
            }
            return n9;
        }
        int n13 = 0;
        while (n3 >= (n6 = this.CIPHER_BLOCK_SIZE - this.bufCount)) {
            n5 = 0;
            while (n5 < n6) {
                int n14 = this.bufCount++;
                this.buf[n14] = (byte)(this.buf[n14] ^ byArray[n2++]);
                ++n5;
            }
            this.cipher.coreCrypt(this.buf, 0, this.buf, 0);
            System.arraycopy(this.buf, 0, byArray2, n4, this.CIPHER_BLOCK_SIZE);
            n3 -= n6;
            n4 += this.CIPHER_BLOCK_SIZE;
            n13 += this.CIPHER_BLOCK_SIZE;
            this.bufCount = 0;
        }
        n5 = 0;
        while (n5 < n3) {
            int n15 = this.bufCount++;
            this.buf[n15] = (byte)(this.buf[n15] ^ byArray[n2++]);
            ++n5;
        }
        return n13;
    }

    final boolean needsPadding() {
        return true;
    }
}

