/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.cipher;

import cryptix.jce.provider.cipher.BlockCipher;
import cryptix.jce.provider.cipher.Mode;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;

class ModeCFB
extends Mode {
    private final byte[] keyStreamBuf;
    private int keyStreamPtr;
    private final byte[] shiftReg;
    private int shiftRegPtr;
    protected long byteCount;
    private int feedbackSize;
    private boolean decrypt;
    private byte[] iVec = null;

    ModeCFB(BlockCipher blockCipher) {
        super(blockCipher);
        this.keyStreamBuf = new byte[this.CIPHER_BLOCK_SIZE];
        this.shiftReg = new byte[this.CIPHER_BLOCK_SIZE];
        this.feedbackSize = this.CIPHER_BLOCK_SIZE;
    }

    ModeCFB(BlockCipher blockCipher, int n2) throws NoSuchAlgorithmException {
        super(blockCipher);
        if (n2 == 0 || n2 % 8 != 0) {
            throw new NoSuchAlgorithmException("Feedback size is 0 or not a multiple of 8 bits.");
        }
        if ((n2 /= 8) < 1 || n2 > this.CIPHER_BLOCK_SIZE) {
            throw new NoSuchAlgorithmException("Feedback size <1 or >CIPHER_BLOCK_SIZE");
        }
        this.keyStreamBuf = new byte[this.CIPHER_BLOCK_SIZE];
        this.shiftReg = new byte[this.CIPHER_BLOCK_SIZE];
        this.feedbackSize = n2;
    }

    final byte[] coreGetIV() {
        return this.iVec;
    }

    final int coreGetOutputSize(int n2) {
        return n2;
    }

    final AlgorithmParameterSpec coreGetParamSpec() {
        if (this.iVec == null) {
            return new IvParameterSpec(this.generateIV());
        }
        return new IvParameterSpec(this.iVec);
    }

    void coreInit(boolean bl2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cipher.coreInit(key, false);
        this.decrypt = bl2;
        this.iVec = this.extractIV(algorithmParameterSpec);
        int n2 = this.iVec.length;
        if (n2 != this.CIPHER_BLOCK_SIZE) {
            throw new InvalidAlgorithmParameterException("Invalid IV specified, incorrect length.");
        }
        this.byteCount = 0L;
        System.arraycopy(this.iVec, 0, this.shiftReg, 0, n2);
        this.crank();
    }

    int coreUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        int n5 = n3;
        while (n5-- > 0) {
            byte by2 = this.keyStreamBuf[this.keyStreamPtr++];
            byte by3 = byArray[n2++];
            byte by4 = (byte)(by3 ^ by2);
            this.shiftInByte(this.decrypt ? by3 : by4);
            byArray2[n4++] = by4;
        }
        return n3;
    }

    private void crank() {
        int n2 = 0;
        while (n2 < this.CIPHER_BLOCK_SIZE) {
            this.keyStreamBuf[n2] = this.shiftReg[this.shiftRegPtr++ % this.CIPHER_BLOCK_SIZE];
            ++n2;
        }
        this.cipher.coreCrypt(this.keyStreamBuf, 0, this.keyStreamBuf, 0);
        this.keyStreamPtr = 0;
    }

    protected boolean needCrank() {
        return this.byteCount % (long)this.feedbackSize == 0L;
    }

    final boolean needsPadding() {
        return false;
    }

    private void shiftInByte(byte by2) {
        this.shiftReg[this.shiftRegPtr++ % this.CIPHER_BLOCK_SIZE] = by2;
        ++this.byteCount;
        if (this.needCrank()) {
            this.crank();
        }
    }
}

