/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.cipher;

import cryptix.jce.provider.cipher.Mode;
import cryptix.jce.provider.cipher.PaddingNone;
import cryptix.jce.provider.cipher.PaddingPKCS5;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

abstract class Padding {
    private final Mode mode;
    private byte[] scratchBuf;
    private int blSize;
    private boolean isBuffered;
    protected boolean decrypt;

    Padding(Mode mode) {
        this.mode = mode;
        this.blSize = this.getBlockSize();
        this.scratchBuf = new byte[this.blSize];
        this.isBuffered = false;
    }

    abstract byte[] corePad(byte[] var1, int var2) throws IllegalBlockSizeException;

    abstract int coreUnPad(byte[] var1, int var2);

    final int doFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (byArray2.length < this.getOutputSize(n3)) {
            throw new ShortBufferException("The output buffer is too short");
        }
        if (this.decrypt) {
            if (byArray == null && !this.isBuffered) {
                return 0;
            }
            if (byArray != null && n3 < this.getPadSize(n3)) {
                throw new BadPaddingException("Input data not bounded by the padding size");
            }
            int n5 = 0;
            if (this.isBuffered) {
                n5 = this.mode.update(this.scratchBuf, 0, this.blSize, byArray2, n4);
                if (byArray != null) {
                    n5 += this.mode.update(byArray, n2, n3, byArray2, n4 + this.blSize);
                }
            } else {
                n5 = this.mode.update(byArray, n2, n3, byArray2, n4);
            }
            this.isBuffered = false;
            return this.coreUnPad(byArray2, n5);
        }
        byte[] byArray3 = this.corePad(byArray, n3);
        return this.mode.update(byArray3, n2, byArray3.length, byArray2, n4);
    }

    final int getBlockSize() {
        return this.mode.getBlockSize();
    }

    protected int getBufSize() {
        return this.mode.getBufSize();
    }

    final byte[] getIV() {
        return this.mode.getIV();
    }

    static Padding getInstance(String string, Mode mode) throws NoSuchPaddingException {
        if (string.equalsIgnoreCase("None") || string.equalsIgnoreCase("NoPadding")) {
            return new PaddingNone(mode);
        }
        if (string.equalsIgnoreCase("PKCS5") || string.equalsIgnoreCase("PKCS#5") || string.equalsIgnoreCase("PKCS5Padding") || string.equalsIgnoreCase("PKCS7") || string.equalsIgnoreCase("PKCS#7")) {
            return new PaddingPKCS5(mode);
        }
        throw new NoSuchPaddingException("Padding not available [" + string + "]");
    }

    final int getOutputSize(int n2) {
        return this.mode.getOutputSize(n2 + this.getPadSize(n2));
    }

    abstract int getPadSize(int var1);

    final AlgorithmParameterSpec getParamSpec() {
        return this.mode.getParamSpec();
    }

    final void init(boolean bl2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.decrypt = bl2;
        this.mode.init(this.decrypt, key, algorithmParameterSpec, secureRandom);
    }

    final int update(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException {
        if (byArray2.length < this.getOutputSize(n3)) {
            throw new ShortBufferException("The output buffer is too short");
        }
        if (this.decrypt) {
            int n5 = 0;
            if (!this.isBuffered) {
                n5 = this.mode.update(byArray, n2, n3 - this.blSize, byArray2, n4);
                System.arraycopy(byArray, n2 + (n3 - this.blSize), this.scratchBuf, 0, this.blSize);
                this.isBuffered = true;
            } else {
                n5 = this.mode.update(this.scratchBuf, 0, this.blSize, byArray2, n4);
                System.arraycopy(byArray, n2 + (n3 - this.blSize), this.scratchBuf, 0, this.blSize);
                n5 += this.mode.update(byArray, n2, n3 - this.blSize, byArray2, n4 + this.blSize);
            }
            return n5;
        }
        return this.mode.update(byArray, n2, n3, byArray2, n4);
    }
}

