/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.elgamal;

import cryptix.jce.ElGamalKey;
import cryptix.jce.ElGamalParams;
import cryptix.jce.ElGamalPrivateKey;
import cryptix.jce.ElGamalPublicKey;
import cryptix.jce.provider.elgamal.ElGamalAlgorithm;
import cryptix.jce.provider.util.Util;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public final class ElGamalCipher
extends CipherSpi {
    private BigInteger p;
    private BigInteger g;
    private BigInteger a;
    private int messageMaxLength;
    private boolean decrypt;

    protected final byte[] engineDoFinal(byte[] byArray, int n2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        int n4;
        byte[] byArray2 = new byte[this.engineGetOutputSize(n3)];
        try {
            n4 = this.engineDoFinal(byArray, n2, n3, byArray2, 0);
            if (n4 == byArray2.length) {
                return byArray2;
            }
        }
        catch (ShortBufferException shortBufferException) {
            throw new RuntimeException("PANIC: Should not happned!");
        }
        byte[] byArray3 = new byte[n4];
        System.arraycopy(byArray2, 0, byArray3, 0, n4);
        return byArray3;
    }

    protected final int engineDoFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (byArray2.length < this.engineGetOutputSize(n3)) {
            throw new ShortBufferException("Output buffer too small!");
        }
        int n5 = this.engineGetBlockSize() / 2;
        if (this.decrypt) {
            BigInteger[] bigIntegerArray = new BigInteger[2];
            byte[] byArray3 = new byte[n5];
            System.arraycopy(byArray, 0, byArray3, 0, n5);
            bigIntegerArray[0] = new BigInteger(1, byArray3);
            byte[] byArray4 = new byte[n5];
            System.arraycopy(byArray, n5, byArray4, 0, n5);
            bigIntegerArray[1] = new BigInteger(1, byArray4);
            BigInteger bigInteger = null;
            try {
                bigInteger = ElGamalAlgorithm.decrypt(bigIntegerArray, this.p, this.a);
            }
            catch (ArithmeticException arithmeticException) {
                throw new BadPaddingException("Decryption Failed.");
            }
            byte[] byArray5 = Util.toFixedLenByteArray(bigInteger, n5);
            return this.unpad(byArray5, byArray5.length, 0, byArray2, n4);
        }
        BigInteger bigInteger = new BigInteger(1, this.pad(byArray, n3, n2, 2));
        BigInteger[] bigIntegerArray = ElGamalAlgorithm.encrypt(bigInteger, this.p, this.g, this.a);
        byte[] byArray6 = Util.toFixedLenByteArray(bigIntegerArray[0], n5);
        byte[] byArray7 = Util.toFixedLenByteArray(bigIntegerArray[1], n5);
        System.arraycopy(byArray6, 0, byArray2, n4, byArray6.length);
        System.arraycopy(byArray7, 0, byArray2, n4 + byArray6.length, byArray7.length);
        return byArray6.length + byArray7.length;
    }

    protected final int engineGetBlockSize() {
        return (this.p.bitLength() + 7) / 8 * 2;
    }

    protected final byte[] engineGetIV() {
        return null;
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (!(key instanceof ElGamalKey)) {
            throw new InvalidKeyException("Not an ElGamalKey!");
        }
        ElGamalParams elGamalParams = ((ElGamalKey)((Object)key)).getParams();
        return elGamalParams.getP().bitLength();
    }

    protected final int engineGetOutputSize(int n2) {
        return n2 < this.engineGetBlockSize() + 1 ? this.engineGetBlockSize() + 1 : n2;
    }

    protected final AlgorithmParameters engineGetParameters() {
        throw new RuntimeException("NYI");
    }

    protected final void engineInit(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("This cipher do not support AlgorithmParameters");
    }

    protected final void engineInit(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        boolean bl2 = this.decrypt = n2 == 2;
        if (!(key instanceof ElGamalKey)) {
            throw new InvalidKeyException("Not an ElGamalKey");
        }
        this.g = ((ElGamalKey)((Object)key)).getParams().getG();
        this.p = ((ElGamalKey)((Object)key)).getParams().getP();
        if (this.decrypt) {
            if (!(key instanceof ElGamalPrivateKey)) {
                throw new InvalidKeyException("Not a private key");
            }
            this.a = ((ElGamalPrivateKey)key).getX();
        } else {
            if (!(key instanceof ElGamalPublicKey)) {
                throw new InvalidKeyException("Not a public key");
            }
            this.a = ((ElGamalPublicKey)key).getY();
        }
        this.messageMaxLength = (this.p.bitLength() - 1) / 8;
    }

    protected final void engineInit(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("This cipher do not support AlgorithmParameterSpecs");
    }

    protected final void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (!string.equalsIgnoreCase("ECB")) {
            throw new NoSuchAlgorithmException("Wrong mode type!");
        }
    }

    protected final void engineSetPadding(String string) throws NoSuchPaddingException {
        if (!(string.equalsIgnoreCase("PKCS1") || string.equalsIgnoreCase("PKCS#1") || string.equalsIgnoreCase("PKCS1Padding"))) {
            throw new NoSuchPaddingException("Wrong padding scheme!");
        }
    }

    protected Key engineUnwrap(byte[] byArray, String string, int n2) throws InvalidKeyException, NoSuchAlgorithmException {
        if (n2 != 5) {
            throw new InvalidKeyException("Wrong keytype!");
        }
        try {
            KeyGenerator.getInstance(string, "Cryptix");
            byte[] byArray2 = this.engineDoFinal(byArray, 0, byArray.length);
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, 0, byArray2.length, string);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string);
            return secretKeyFactory.generateSecret(secretKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchAlgorithmException("Algorithm not supported!");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException("PANIC: Should not happend!");
        }
        catch (BadPaddingException badPaddingException) {
            throw new RuntimeException("PANIC: This should not happend!");
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new RuntimeException("PANIC: This should not happend!");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new RuntimeException("PANIC: This should not happend!");
        }
    }

    protected final byte[] engineUpdate(byte[] byArray, int n2, int n3) {
        throw new RuntimeException("You can't do an update when using PKCS1!");
    }

    protected final int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException {
        throw new RuntimeException("You can't do an update when using PKCS1!");
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        String string = key.getFormat();
        if (string == null || !string.equalsIgnoreCase("RAW")) {
            throw new InvalidKeyException("Wrong format on key!");
        }
        byte[] byArray = key.getEncoded();
        try {
            return this.engineDoFinal(byArray, 0, byArray.length);
        }
        catch (BadPaddingException badPaddingException) {
            throw new RuntimeException("PANIC: This should not happend!");
        }
    }

    private byte[] pad(byte[] byArray, int n2, int n3, int n4) throws BadPaddingException {
        int n5 = (this.p.bitLength() + 7) / 8;
        if (n2 > n5 - 11) {
            throw new BadPaddingException("Data too long for this modulus!");
        }
        byte[] byArray2 = new byte[n5];
        int n6 = n5 - 3 - n2;
        byArray2[2 + n6] = 0;
        byArray2[0] = 0;
        switch (n4) {
            case 0: {
                int n7 = 1;
                while (n7 < 2 + n6) {
                    byArray2[n7] = 0;
                    ++n7;
                }
                break;
            }
            case 1: {
                byArray2[1] = 1;
                int n8 = 2;
                while (n8 < 2 + n6) {
                    byArray2[n8] = -1;
                    ++n8;
                }
                break;
            }
            case 2: {
                byArray2[1] = 2;
                byte[] byArray3 = new byte[1];
                SecureRandom secureRandom = new SecureRandom();
                int n9 = 2;
                while (n9 < 2 + n6) {
                    byArray3[0] = 0;
                    while (byArray3[0] == 0) {
                        secureRandom.nextBytes(byArray3);
                    }
                    byArray2[n9] = byArray3[0];
                    ++n9;
                }
                break;
            }
            default: {
                throw new BadPaddingException("Wrong block type!");
            }
        }
        System.arraycopy(byArray, n3, byArray2, n6 + 3, n2);
        return byArray2;
    }

    private int unpad(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws BadPaddingException {
        byte by2 = byArray[n3 + 1];
        int n5 = 1;
        try {
            switch (by2) {
                case 0: {
                    while (byArray[n3 + n5 + 1] == 0) {
                        ++n5;
                    }
                    break;
                }
                case 1: 
                case 2: {
                    while (byArray[n3 + n5] != 0) {
                        ++n5;
                    }
                    break;
                }
                default: {
                    throw new BadPaddingException("Wrong block type!");
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new BadPaddingException("Cannot unpad: padding incorrect for PKCS#1 block type " + by2);
        }
        int n6 = n2 - n3 - ++n5;
        System.arraycopy(byArray, n3 + n5, byArray2, n4, n6);
        return n6;
    }
}

