/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.key;

import cryptix.jce.provider.key.RawKeyGenerator;

public class DESKeyGenerator
extends RawKeyGenerator {
    public DESKeyGenerator() {
        super("DES", 56);
    }

    protected byte[] fixUp(byte[] byArray) {
        int n2 = 0;
        while (n2 < byArray.length) {
            byte by2 = byArray[n2];
            byArray[n2] = (byte)(by2 & 0xFE | (by2 >> 1 ^ by2 >> 2 ^ by2 >> 3 ^ by2 >> 4 ^ by2 >> 5 ^ by2 >> 6 ^ by2 >> 7) & 1);
            ++n2;
        }
        return byArray;
    }

    protected boolean isValidSize(int n2) {
        return n2 == 56;
    }

    protected boolean isWeak(byte[] byArray) {
        return this.isWeak(byArray, 0);
    }

    private boolean isWeak(byte[] byArray, int n2) {
        int n3 = (byArray[n2] & 0xFE) << 8 | byArray[n2 + 1] & 0xFE;
        int n4 = (byArray[n2 + 2] & 0xFE) << 8 | byArray[n2 + 3] & 0xFE;
        int n5 = (byArray[n2 + 4] & 0xFE) << 8 | byArray[n2 + 5] & 0xFE;
        int n6 = (byArray[n2 + 6] & 0xFE) << 8 | byArray[n2 + 7] & 0xFE;
        return !(n3 != 0 && n3 != 65278 || n4 != 0 && n4 != 65278 || n5 != 0 && n5 != 65278 || n6 != 0 && n6 != 65278);
    }

    protected int strengthToBits(int n2) {
        if (n2 != 56) {
            throw new RuntimeException("Invalid strength value");
        }
        return 64;
    }
}

