/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.keyfactory;

import cryptix.jce.provider.key.RawSecretKey;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.PBEKeySpec;

public final class PBEKeyFactory
extends SecretKeyFactorySpi {
    private PBEKeySpec pbeKeySpec = null;
    static /* synthetic */ Class array$C;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec == null || !(keySpec instanceof PBEKeySpec)) {
            throw new InvalidKeySpecException("Cannot generate SecretKey using given KeySpec.");
        }
        this.pbeKeySpec = (PBEKeySpec)keySpec;
        RawSecretKey rawSecretKey = new RawSecretKey("PBE", new String(this.pbeKeySpec.getPassword()).getBytes());
        return rawSecretKey;
    }

    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        if (secretKey == null || clazz == null) {
            throw new InvalidKeySpecException("Null parameter provided.");
        }
        Class<?> clazz2 = null;
        try {
            clazz2 = Class.forName("javax.crypto.spec.PBEKeySpec");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidKeySpecException("Cannot create KeySpec class not found!");
        }
        if (clazz.isAssignableFrom(clazz2)) {
            byte[] byArray = secretKey.getEncoded();
            char[] cArray = new char[byArray.length];
            int n2 = 0;
            while (n2 < byArray.length) {
                cArray[n2] = (char)byArray[n2];
                ++n2;
            }
            Object[] objectArray = new Object[]{cArray};
            Class[] classArray = new Class[]{array$C != null ? array$C : (array$C = PBEKeyFactory.class$("[C"))};
            KeySpec keySpec = null;
            try {
                Constructor constructor = clazz.getConstructor(classArray);
                keySpec = (KeySpec)constructor.newInstance(objectArray);
            }
            catch (InstantiationException instantiationException) {
                throw new InvalidKeySpecException("InvalidKeySpec.");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InvalidKeySpecException("IllegalAccess.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidKeySpecException("Illegal constr. argument.");
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new InvalidKeySpecException("InvocationTargetException.");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new InvalidKeySpecException("Method not found.");
            }
            return keySpec;
        }
        throw new InvalidKeySpecException("Cannot assign to KeySpec.");
    }

    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        if (secretKey == null) {
            throw new InvalidKeyException();
        }
        if (secretKey instanceof RawSecretKey && secretKey.getAlgorithm() == "PBE") {
            return secretKey;
        }
        try {
            KeySpec keySpec = this.engineGetKeySpec(secretKey, null);
            return this.engineGenerateSecret(keySpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Translation not possible.");
        }
    }
}

