/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.md;

import java.security.DigestException;
import java.security.MessageDigestSpi;

abstract class PaddingMD
extends MessageDigestSpi {
    private static final int DEFAULT_BLOCKSIZE = 64;
    private final int blockSize;
    private final int hashSize;
    private final byte[] buf;
    private int bufOff;
    private long byteCount;
    private final int mode;
    static final int MODE_MD = 0;
    static final int MODE_SHA = 1;
    static final int MODE_TIGER = 2;

    protected PaddingMD(int n2, int n3) {
        this(64, n2, n3);
    }

    protected PaddingMD(int n2, int n3, int n4) {
        if (n2 != 64 && n2 != 128) {
            throw new RuntimeException("blockSize must be 64 or 128!");
        }
        this.blockSize = n2;
        this.hashSize = n3;
        this.buf = new byte[n2];
        this.bufOff = 0;
        this.byteCount = 0L;
        this.mode = n4;
    }

    protected PaddingMD(PaddingMD paddingMD) {
        this.blockSize = paddingMD.blockSize;
        this.hashSize = paddingMD.hashSize;
        this.buf = (byte[])paddingMD.buf.clone();
        this.bufOff = paddingMD.bufOff;
        this.byteCount = paddingMD.byteCount;
        this.mode = paddingMD.mode;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("You have just found a bug!");
    }

    protected abstract void coreDigest(byte[] var1, int var2);

    protected abstract void coreReset();

    protected abstract void coreUpdate(byte[] var1, int var2);

    protected byte[] engineDigest() {
        byte[] byArray = new byte[this.hashSize];
        this.privateDigest(byArray, 0, this.hashSize);
        return byArray;
    }

    protected int engineDigest(byte[] byArray, int n2, int n3) throws DigestException {
        if (n3 < this.hashSize) {
            throw new DigestException();
        }
        return this.privateDigest(byArray, n2, n3);
    }

    protected int engineGetDigestLength() {
        return this.hashSize;
    }

    protected void engineReset() {
        this.bufOff = 0;
        this.byteCount = 0L;
        this.coreReset();
    }

    protected void engineUpdate(byte by2) {
        ++this.byteCount;
        this.buf[this.bufOff++] = by2;
        if (this.bufOff == this.blockSize) {
            this.coreUpdate(this.buf, 0);
            this.bufOff = 0;
        }
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) {
        int n4;
        this.byteCount += (long)n3;
        while (n3 >= (n4 = this.blockSize - this.bufOff)) {
            System.arraycopy(byArray, n2, this.buf, this.bufOff, n4);
            this.coreUpdate(this.buf, 0);
            n3 -= n4;
            n2 += n4;
            this.bufOff = 0;
        }
        System.arraycopy(byArray, n2, this.buf, this.bufOff, n3);
        this.bufOff += n3;
    }

    private int privateDigest(byte[] byArray, int n2, int n3) {
        int n4;
        this.buf[this.bufOff++] = this.mode == 2 ? 1 : -128;
        int n5 = this.blockSize == 128 ? 16 : 8;
        int n6 = this.blockSize - n5;
        if (this.bufOff > n6) {
            while (this.bufOff < this.blockSize) {
                this.buf[this.bufOff++] = 0;
            }
            this.coreUpdate(this.buf, 0);
            this.bufOff = 0;
        }
        while (this.bufOff < n6) {
            this.buf[this.bufOff++] = 0;
        }
        long l2 = this.byteCount * 8L;
        if (this.blockSize == 128) {
            n4 = 0;
            while (n4 < 8) {
                this.buf[this.bufOff++] = 0;
                ++n4;
            }
        }
        if (this.mode == 1) {
            n4 = 56;
            while (n4 >= 0) {
                this.buf[this.bufOff++] = (byte)(l2 >>> n4);
                n4 -= 8;
            }
        } else {
            n4 = 0;
            while (n4 < 64) {
                this.buf[this.bufOff++] = (byte)(l2 >>> n4);
                n4 += 8;
            }
        }
        this.coreUpdate(this.buf, 0);
        this.coreDigest(byArray, n2);
        this.engineReset();
        return this.hashSize;
    }
}

