/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.random;

import cryptix.jce.provider.random.StatisticalTests;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.SecureRandomSpi;

public final class DevRandom
extends SecureRandomSpi {
    private static final String RANDOM_DEV_NAME = "/dev/urandom";
    private static final File RANDOM_DEV = new File("/dev/urandom");
    private static FileInputStream randomStream = null;

    static {
        try {
            randomStream = new FileInputStream(RANDOM_DEV);
            byte[] byArray = new byte[2500];
            DevRandom.getRandomBytes(byArray);
            if (!StatisticalTests.looksRandom(byArray)) {
                System.out.println("CryptixRandom Provider:Output of /dev/urandom doesn't look random, this may indicate a serious security problem!");
                randomStream.close();
                randomStream = null;
            }
        }
        catch (IOException iOException) {
            randomStream = null;
        }
    }

    public DevRandom() {
        if (randomStream == null) {
            throw new InternalError("randomStream == null");
        }
    }

    protected byte[] engineGenerateSeed(int n2) {
        byte[] byArray = new byte[n2];
        this.engineNextBytes(byArray);
        return byArray;
    }

    protected void engineNextBytes(byte[] byArray) {
        try {
            DevRandom.getRandomBytes(byArray);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot read from randomness device: " + iOException);
        }
    }

    protected void engineSetSeed(byte[] byArray) {
    }

    private static void getRandomBytes(byte[] byArray) throws IOException {
        int n2 = 0;
        int n3 = byArray.length;
        while (n3 > 0) {
            int n4;
            FileInputStream fileInputStream = randomStream;
            synchronized (fileInputStream) {
                n4 = randomStream.read(byArray, n2, n3);
                if (n4 == -1) {
                    throw new IOException("EOF");
                }
            }
            n2 += n4;
            n3 -= n4;
        }
    }

    public static boolean isAvailable() {
        return randomStream != null;
    }
}

