/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.rsa;

import cryptix.jce.provider.rsa.RSAAlgorithm;
import cryptix.jce.provider.util.Util;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public abstract class RSACipher_OAEP
extends CipherSpi {
    private final MessageDigest _md;
    private final int _hLen;
    private final byte[] _lHash;
    private SecureRandom _rng;
    private BigInteger _n;
    private BigInteger _exp;
    private BigInteger _p;
    private BigInteger _q;
    private BigInteger _u;
    private int _k;
    private int _mode;

    public RSACipher_OAEP(String string) {
        try {
            this._md = MessageDigest.getInstance(string);
            this._hLen = this._md.getDigestLength();
            this._lHash = this._md.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError("MessageDigest not found! (" + string + "): " + noSuchAlgorithmException.toString());
        }
    }

    private byte[] RSAES_OAEP_DECRYPT(byte[] byArray) throws BadPaddingException, IllegalBlockSizeException {
        if (byArray.length != this._k) {
            throw new IllegalBlockSizeException();
        }
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = RSAAlgorithm.rsa(bigInteger, this._n, this._exp, this._p, this._q, this._u);
        byte[] byArray2 = Util.toFixedLenByteArray(bigInteger2, this._k);
        if (byArray2[0] != 0) {
            throw new BadPaddingException();
        }
        byte[] byArray3 = new byte[this._hLen];
        System.arraycopy(byArray2, 1, byArray3, 0, byArray3.length);
        byte[] byArray4 = new byte[this._k - this._hLen - 1];
        System.arraycopy(byArray2, 1 + this._hLen, byArray4, 0, byArray4.length);
        byte[] byArray5 = this.mgf1(byArray4, this._hLen);
        byte[] byArray6 = RSACipher_OAEP.xor(byArray3, byArray5);
        byte[] byArray7 = this.mgf1(byArray6, this._k - this._hLen - 1);
        byte[] byArray8 = RSACipher_OAEP.xor(byArray4, byArray7);
        byte[] byArray9 = new byte[this._hLen];
        System.arraycopy(byArray8, 0, byArray9, 0, byArray9.length);
        if (!Util.equals(this._lHash, byArray9)) {
            throw new BadPaddingException();
        }
        int n2 = this._hLen;
        while (n2 < byArray8.length) {
            if (byArray8[n2] != 0) break;
            ++n2;
        }
        if (byArray8[n2++] != 1) {
            throw new BadPaddingException();
        }
        int n3 = byArray8.length - n2;
        byte[] byArray10 = new byte[n3];
        System.arraycopy(byArray8, n2, byArray10, 0, n3);
        return byArray10;
    }

    private byte[] RSAES_OAEP_ENCRYPT(byte[] byArray) throws IllegalBlockSizeException {
        int n2 = byArray.length;
        if (n2 > this._k - 2 * this._hLen - 2) {
            throw new IllegalBlockSizeException();
        }
        byte[] byArray2 = new byte[this._k - n2 - 2 * this._hLen - 2];
        byte[] byArray3 = this.concat(this._lHash, byArray2, new byte[]{1}, byArray);
        byte[] byArray4 = new byte[this._hLen];
        this._rng.nextBytes(byArray4);
        byte[] byArray5 = this.mgf1(byArray4, this._k - this._hLen - 1);
        byte[] byArray6 = RSACipher_OAEP.xor(byArray3, byArray5);
        byte[] byArray7 = this.mgf1(byArray6, this._hLen);
        byte[] byArray8 = RSACipher_OAEP.xor(byArray4, byArray7);
        byte[] byArray9 = this.concat(new byte[1], byArray8, byArray6);
        BigInteger bigInteger = new BigInteger(1, byArray9);
        BigInteger bigInteger2 = RSAAlgorithm.rsa(bigInteger, this._n, this._exp, this._p, this._q, this._u);
        byte[] byArray10 = Util.toFixedLenByteArray(bigInteger2, this._k);
        return byArray10;
    }

    private byte[] concat(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    private byte[] concat(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.concat(byArray, this.concat(byArray2, byArray3));
    }

    private byte[] concat(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        return this.concat(byArray, this.concat(byArray2, this.concat(byArray3, byArray4)));
    }

    protected final byte[] engineDoFinal(byte[] byArray, int n2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        if (this._mode == 1) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
            byte[] byArray3 = this.RSAES_OAEP_ENCRYPT(byArray2);
            return byArray3;
        }
        byte[] byArray4 = new byte[n3];
        System.arraycopy(byArray, n2, byArray4, 0, n3);
        byte[] byArray5 = this.RSAES_OAEP_DECRYPT(byArray4);
        return byArray5;
    }

    protected final int engineDoFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray, n2, byArray3, 0, n3);
        byte[] byArray4 = this.RSAES_OAEP_ENCRYPT(byArray3);
        int n5 = byArray2.length - n4;
        if (byArray4.length > n5) {
            throw new ShortBufferException();
        }
        System.arraycopy(byArray4, 0, byArray2, n4, byArray4.length);
        return byArray4.length;
    }

    protected final int engineGetBlockSize() {
        throw new IllegalArgumentException();
    }

    protected final byte[] engineGetIV() {
        return null;
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key instanceof RSAPublicKey) {
            return ((RSAPublicKey)key).getModulus().bitLength();
        }
        if (key instanceof RSAPrivateKey) {
            return ((RSAPrivateKey)key).getModulus().bitLength();
        }
        throw new InvalidKeyException("Not an RSA key.");
    }

    protected final int engineGetOutputSize(int n2) {
        throw new IllegalArgumentException();
    }

    protected final AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected final void engineInit(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameters != null) {
            throw new InvalidAlgorithmParameterException("This cipher do not support AlgorithmParameters");
        }
        this.engineInit(n2, key, secureRandom);
    }

    protected final void engineInit(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(key instanceof RSAPrivateKey) && !(key instanceof RSAPublicKey)) {
            throw new InvalidKeyException("Key must be instance of either RSAPublicKey or RSAPrivateKey!");
        }
        this._mode = n2;
        this._rng = secureRandom;
        if (this._mode == 2) {
            this._n = ((RSAPrivateKey)key).getModulus();
            this._exp = ((RSAPrivateKey)key).getPrivateExponent();
        } else if (this._mode == 1) {
            this._n = ((RSAPublicKey)key).getModulus();
            this._exp = ((RSAPublicKey)key).getPublicExponent();
        } else {
            throw new IllegalArgumentException("opmode not supported.");
        }
        if (key instanceof RSAPrivateCrtKey) {
            this._p = ((RSAPrivateCrtKey)key).getPrimeP();
            this._q = ((RSAPrivateCrtKey)key).getPrimeQ();
            this._u = ((RSAPrivateCrtKey)key).getCrtCoefficient();
        } else {
            this._u = null;
            this._q = null;
            this._p = null;
        }
        this._k = (this._n.bitLength() + 7) / 8;
        if (this._k < 2 * this._hLen + 2) {
            throw new InvalidKeyException("Modulus too short.");
        }
    }

    protected final void engineInit(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("This cipher do not support AlgorithmParameterSpecs");
        }
        this.engineInit(n2, key, secureRandom);
    }

    protected final void engineSetMode(String string) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("Wrong mode type!");
    }

    protected final void engineSetPadding(String string) throws NoSuchPaddingException {
    }

    protected final byte[] engineUpdate(byte[] byArray, int n2, int n3) {
        throw new RuntimeException("You can't do an update when using OAEP!");
    }

    protected final int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException {
        throw new RuntimeException("You can't do an update when using OAEP!");
    }

    private byte[] mgf1(byte[] byArray, int n2) {
        int n3 = (n2 + this._hLen - 1) / this._hLen;
        byte[] byArray2 = new byte[]{};
        int n4 = 0;
        while (n4 < n3) {
            byArray2 = this.concat(byArray2, this.mgf1Hash(byArray, (byte)n4));
            ++n4;
        }
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
        return byArray3;
    }

    private byte[] mgf1Hash(byte[] byArray, byte by2) {
        this._md.update(byArray);
        this._md.update(new byte[3]);
        this._md.update(by2);
        return this._md.digest();
    }

    private static byte[] xor(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            throw new InternalError("a.len != b.len");
        }
        byte[] byArray3 = new byte[byArray.length];
        int n2 = 0;
        while (n2 < byArray3.length) {
            byArray3[n2] = (byte)(byArray[n2] ^ byArray2[n2]);
            ++n2;
        }
        return byArray3;
    }
}

