/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.AttributeValueExp;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.StringValueExp;
import javax.management.ValueExp;

class MatchQueryExp
extends QueryEval
implements QueryExp {
    private static final long serialVersionUID = -7156603696948215014L;
    private AttributeValueExp exp;
    private String pattern;

    MatchQueryExp(AttributeValueExp exp, StringValueExp pattern) {
        this.exp = exp;
        this.pattern = pattern == null ? null : pattern.getValue();
    }

    public void setMBeanServer(MBeanServer server) {
        super.setMBeanServer(server);
        if (this.exp != null) {
            this.exp.setMBeanServer(server);
        }
    }

    public boolean apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        ValueExp value = this.exp.apply(name);
        if (value instanceof StringValueExp) {
            return this.wildcardMatch(((StringValueExp)value).getValue(), this.pattern);
        }
        return false;
    }

    private boolean wildcardMatch(String s2, String p2) {
        if (s2 == null && p2 == null) {
            return true;
        }
        if (s2 == null) {
            return false;
        }
        if (p2 == null) {
            return true;
        }
        int si = 0;
        int pi = 0;
        int slen = s2.length();
        int plen = p2.length();
        while (pi < plen) {
            char c2;
            if ((c2 = p2.charAt(pi++)) == '?') {
                if (++si <= slen) continue;
                return false;
            }
            if (c2 == '[') {
                boolean wantit = true;
                boolean seenit = false;
                if (p2.charAt(pi) == '!') {
                    wantit = false;
                    ++pi;
                }
                while (++pi < plen && (c2 = p2.charAt(pi)) != ']') {
                    if (p2.charAt(pi) == '-' && pi + 1 < plen) {
                        if (s2.charAt(si) >= c2 && s2.charAt(si) <= p2.charAt(pi + 1)) {
                            seenit = true;
                        }
                        ++pi;
                        continue;
                    }
                    if (c2 != s2.charAt(si)) continue;
                    seenit = true;
                }
                if (pi >= plen || wantit != seenit) {
                    return false;
                }
                ++pi;
                ++si;
                continue;
            }
            if (c2 == '*') {
                if (pi >= plen) {
                    return true;
                }
                do {
                    if (!this.wildcardMatch(s2.substring(si), p2.substring(pi))) continue;
                    return true;
                } while (++si < slen);
                return false;
            }
            if (!(c2 == '\\' ? pi >= plen || p2.charAt(pi++) != s2.charAt(si++) : si >= slen || c2 != s2.charAt(si++))) continue;
            return false;
        }
        return si == slen;
    }
}

