/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;

public class CompositeType
extends OpenType
implements Serializable {
    private static final long serialVersionUID = -5366242454346948798L;
    private TreeMap nameToDescription;
    private TreeMap nameToType;
    private transient String m_classStringValue = null;
    private transient int m_hashcode = 0;
    static /* synthetic */ Class class$javax$management$openmbean$CompositeData;

    public CompositeType(String typeName, String description, String[] itemNames, String[] itemDescriptions, OpenType[] itemTypes) throws OpenDataException {
        super((class$javax$management$openmbean$CompositeData == null ? (class$javax$management$openmbean$CompositeData = CompositeType.class$("javax.management.openmbean.CompositeData")) : class$javax$management$openmbean$CompositeData).getName(), typeName, description);
        this.validate(itemNames, itemDescriptions, itemTypes);
        this.initialize(itemNames, itemDescriptions, itemTypes);
    }

    private void initialize(String[] itemNames, String[] itemDescriptions, OpenType[] itemTypes) throws OpenDataException {
        this.nameToDescription = new TreeMap();
        this.nameToType = new TreeMap();
        int i2 = 0;
        while (i2 < itemNames.length) {
            String item = itemNames[i2].trim();
            if (this.nameToDescription.containsKey(item)) {
                throw new OpenDataException("The key: " + item + " is already mapped to a previous entry");
            }
            this.nameToDescription.put(item, itemDescriptions[i2]);
            this.nameToType.put(item, itemTypes[i2]);
            ++i2;
        }
    }

    private void validate(String[] itemNames, String[] itemDescriptions, OpenType[] itemTypes) throws OpenDataException {
        if (itemNames == null || itemNames.length == 0) {
            throw new IllegalArgumentException("The String[] of itemNames cannot be null or empty");
        }
        if (itemDescriptions == null || itemDescriptions.length == 0) {
            throw new IllegalArgumentException("The String[] of itemDescriptions cannot be null or empty");
        }
        if (itemDescriptions.length != itemNames.length || itemTypes.length != itemNames.length) {
            throw new OpenDataException("itemNames, itemDescriptions and itemTypes must all be the same length");
        }
        int i2 = 0;
        while (i2 < itemNames.length) {
            String value = itemNames[i2];
            String description = itemDescriptions[i2];
            if (value == null) {
                throw new IllegalArgumentException("The itemName at index: " + i2 + " cannot be a null value");
            }
            if (description == null) {
                throw new IllegalArgumentException("The itemDescription at index: " + i2 + " cannot be a null value");
            }
            if (value.trim().equals("")) {
                throw new IllegalArgumentException("The itemName at index: " + i2 + " cannot be an empty string");
            }
            if (description.trim().equals("")) {
                throw new IllegalArgumentException("The itemDescription at index: " + i2 + " cannot be an empty string");
            }
            if (itemTypes[i2] == null) {
                throw new IllegalArgumentException("The OpenType at index: " + i2 + " cannot be a null value");
            }
            ++i2;
        }
    }

    public boolean containsKey(String itemName) {
        if (itemName == null || itemName.length() == 0) {
            return false;
        }
        return this.nameToDescription.containsKey(itemName);
    }

    public String getDescription(String itemName) {
        if (itemName == null || itemName.length() == 0) {
            return null;
        }
        return (String)this.nameToDescription.get(itemName);
    }

    public OpenType getType(String itemName) {
        if (itemName == null || itemName.length() == 0) {
            return null;
        }
        return (OpenType)this.nameToType.get(itemName);
    }

    public Set keySet() {
        return Collections.unmodifiableSet(this.nameToDescription.keySet());
    }

    public boolean isValue(Object object) {
        if (!(object instanceof CompositeData)) {
            return false;
        }
        CompositeData compositeData = (CompositeData)object;
        return this.equals(compositeData.getCompositeType());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CompositeType)) {
            return false;
        }
        CompositeType type = (CompositeType)object;
        if (!this.getTypeName().equals(type.getTypeName())) {
            return false;
        }
        return this.nameToDescription.equals(type.nameToDescription) && this.nameToType.equals(type.nameToType);
    }

    public int hashCode() {
        if (this.m_hashcode == 0) {
            int result = 17;
            result = 3 * result + this.getTypeName().hashCode();
            Iterator i2 = this.nameToType.keySet().iterator();
            while (i2.hasNext()) {
                result = 3 * result + i2.next().hashCode();
            }
            this.m_hashcode = result;
        }
        return this.m_hashcode;
    }

    public String toString() {
        if (this.m_classStringValue == null) {
            StringBuffer value = new StringBuffer(100);
            value.append(this.getClassName()).append(" TypeName: ").append(this.getTypeName()).append(" contains data:\n");
            Iterator i2 = this.nameToType.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry entry = i2.next();
                value.append("ItemName: ").append((String)entry.getKey()).append(" OpenType value: ").append(((OpenType)entry.getValue()).toString()).append("\n");
            }
            this.m_classStringValue = value.toString();
        }
        return this.m_classStringValue;
    }

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        inputStream.defaultReadObject();
        String[] itemNames = this.nameToDescription.keySet().toArray(new String[this.nameToDescription.size()]);
        String[] itemDescriptions = this.nameToDescription.values().toArray(new String[this.nameToDescription.size()]);
        OpenType[] itemTypes = this.nameToType.values().toArray(new OpenType[this.nameToType.size()]);
        try {
            this.validate(itemNames, itemDescriptions, itemTypes);
            this.initialize(itemNames, itemDescriptions, itemTypes);
        }
        catch (OpenDataException e2) {
            throw new StreamCorruptedException("validation failed for deserialized object, unable to create object in the correct state");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

