/*
 * Decompiled with CFR 0.152.
 */
package mx4j.adaptor.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.JMException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import mx4j.adaptor.http.CommandProcessorUtil;
import mx4j.adaptor.http.HttpCommandProcessorAdaptor;
import mx4j.adaptor.http.HttpInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InvokeOperationCommandProcessor
extends HttpCommandProcessorAdaptor {
    public Document executeRequest(HttpInputStream in) throws IOException, JMException {
        Document document;
        block27: {
            ObjectName name;
            Element operationElement;
            block23: {
                boolean match;
                ArrayList<Object> values;
                ArrayList<String> types;
                String operationVariable;
                block24: {
                    document = this.builder.newDocument();
                    Element root = document.createElement("MBeanOperation");
                    document.appendChild(root);
                    operationElement = document.createElement("Operation");
                    operationElement.setAttribute("operation", "invoke");
                    root.appendChild(operationElement);
                    String objectVariable = in.getVariable("objectname");
                    operationVariable = in.getVariable("operation");
                    if (objectVariable == null || objectVariable.equals("") || operationVariable == null || operationVariable.equals("")) {
                        operationElement.setAttribute("result", "error");
                        operationElement.setAttribute("errorMsg", "Incorrect parameters in the request");
                        return document;
                    }
                    operationElement.setAttribute("objectname", objectVariable);
                    types = new ArrayList<String>();
                    values = new ArrayList<Object>();
                    int i2 = 0;
                    boolean unmatchedParameters = false;
                    boolean valid = false;
                    do {
                        String parameterType = in.getVariable("type" + i2);
                        String parameterValue = in.getVariable("value" + i2);
                        boolean bl2 = valid = parameterType != null && parameterValue != null;
                        if (valid) {
                            types.add(parameterType);
                            Object value = null;
                            try {
                                value = CommandProcessorUtil.createParameterValue(parameterType, parameterValue);
                            }
                            catch (Exception e2) {
                                operationElement.setAttribute("result", "error");
                                operationElement.setAttribute("errorMsg", "Parameter " + i2 + ": " + parameterValue + " cannot be converted to type " + parameterType);
                                return document;
                            }
                            if (value != null) {
                                values.add(value);
                            }
                        }
                        if (parameterType == null ^ parameterValue == null) {
                            unmatchedParameters = true;
                            break;
                        }
                        ++i2;
                    } while (valid);
                    if (objectVariable == null || objectVariable.equals("") || operationVariable == null || operationVariable.equals("")) {
                        operationElement.setAttribute("result", "error");
                        operationElement.setAttribute("errorMsg", "Incorrect parameters in the request");
                        return document;
                    }
                    if (unmatchedParameters) {
                        operationElement.setAttribute("result", "error");
                        operationElement.setAttribute("errorMsg", "count of parameter types doesn't match count of parameter values");
                        return document;
                    }
                    name = null;
                    try {
                        name = new ObjectName(objectVariable);
                    }
                    catch (MalformedObjectNameException e3) {
                        operationElement.setAttribute("result", "error");
                        operationElement.setAttribute("errorMsg", "Malformed object name");
                        return document;
                    }
                    if (!this.server.isRegistered(name)) break block23;
                    MBeanInfo info = this.server.getMBeanInfo(name);
                    MBeanOperationInfo[] operations = info.getOperations();
                    match = false;
                    if (operations == null) break block24;
                    int j2 = 0;
                    while (j2 < operations.length) {
                        block26: {
                            block25: {
                                if (!operations[j2].getName().equals(operationVariable)) break block25;
                                MBeanParameterInfo[] parameters = operations[j2].getSignature();
                                if (parameters.length != types.size()) break block26;
                                Iterator k2 = types.iterator();
                                boolean signatureMatch = true;
                                int p2 = 0;
                                while (p2 < types.size()) {
                                    if (!parameters[p2].getType().equals(k2.next())) {
                                        signatureMatch = false;
                                        break;
                                    }
                                    ++p2;
                                }
                                match = signatureMatch;
                            }
                            if (match) break;
                        }
                        ++j2;
                    }
                }
                if (!match) {
                    operationElement.setAttribute("result", "error");
                    operationElement.setAttribute("errorMsg", "Operation singature has no match in the MBean");
                } else {
                    try {
                        Object[] params = values.toArray();
                        String[] signature = new String[types.size()];
                        types.toArray(signature);
                        Object returnValue = this.server.invoke(name, operationVariable, params, signature);
                        operationElement.setAttribute("result", "success");
                        operationElement.setAttribute("return", returnValue != null ? returnValue.toString() : null);
                    }
                    catch (Exception e4) {
                        operationElement.setAttribute("result", "error");
                        operationElement.setAttribute("errorMsg", e4.getMessage());
                    }
                }
                break block27;
            }
            if (name != null) {
                operationElement.setAttribute("result", "error");
                operationElement.setAttribute("errorMsg", "MBean " + name + " not registered");
            }
        }
        return document;
    }
}

